/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<Object> {
    public static final VersionNumber zeroVersion = new VersionNumber(0, 0, 0);
    protected final int major;
    protected final int minor;
    protected final int sub;

    public VersionNumber(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.sub = n3;
    }

    public VersionNumber(String string, String string2) {
        Pattern pattern = Pattern.compile("(\\D*)(\\d*)(.*)");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int[] nArray = new int[3];
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 3; ++i) {
            try {
                Matcher matcher = pattern.matcher(stringTokenizer.nextToken());
                if (!matcher.matches()) continue;
                nArray[i] = Integer.parseInt(matcher.group(2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.major = nArray[0];
        this.minor = nArray[1];
        this.sub = nArray[2];
    }

    public final boolean isZero() {
        return this.major == 0 && this.minor == 0 && this.sub == 0;
    }

    public final int hashCode() {
        int n = 31 + this.major;
        n = (n << 5) - n + this.minor;
        return (n << 5) - n + this.sub;
    }

    public final boolean equals(Object object) {
        if (object instanceof VersionNumber) {
            return 0 == this.compareTo((VersionNumber)object);
        }
        return false;
    }

    @Override
    public final int compareTo(Object object) {
        if (!(object instanceof VersionNumber)) {
            Class<?> clazz = null != object ? object.getClass() : null;
            throw new ClassCastException("Not a VersionNumber object: " + clazz);
        }
        return this.compareTo((VersionNumber)object);
    }

    @Override
    public final int compareTo(VersionNumber versionNumber) {
        if (this.major > versionNumber.major) {
            return 1;
        }
        if (this.major < versionNumber.major) {
            return -1;
        }
        if (this.minor > versionNumber.minor) {
            return 1;
        }
        if (this.minor < versionNumber.minor) {
            return -1;
        }
        if (this.sub > versionNumber.sub) {
            return 1;
        }
        if (this.sub < versionNumber.sub) {
            return -1;
        }
        return 0;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getSub() {
        return this.sub;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.sub;
    }
}

