/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.io.PrintStream;
import jogamp.common.Debug;

public abstract class TaskBase
implements Runnable {
    private static final boolean TRACE_SOURCE = Debug.isPropertyDefined("jogamp.debug.TaskBase.TraceSource", true);
    protected final Object syncObject;
    protected final boolean catchExceptions;
    protected final PrintStream exceptionOut;
    protected final Throwable sourceStack;
    protected Object attachment;
    protected Throwable runnableException;
    protected long tCreated;
    protected long tStarted;
    protected volatile long tExecuted;
    protected volatile boolean isFlushed;

    protected TaskBase(Object object, boolean bl, PrintStream printStream) {
        this.syncObject = object;
        this.catchExceptions = bl;
        this.exceptionOut = printStream;
        this.sourceStack = TRACE_SOURCE ? new Throwable("Creation @") : null;
        this.tCreated = System.currentTimeMillis();
        this.tStarted = 0L;
        this.tExecuted = 0L;
        this.isFlushed = false;
    }

    protected final String getExceptionOutIntro() {
        return this.catchExceptions ? "A catched" : "An uncatched";
    }

    protected final void printSourceTrace() {
        if (null != this.sourceStack && null != this.exceptionOut) {
            this.sourceStack.printStackTrace(this.exceptionOut);
        }
    }

    public final Object getSyncObject() {
        return this.syncObject;
    }

    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (!this.isExecuted() && this.hasWaiter()) {
            Object object = this.syncObject;
            synchronized (object) {
                this.isFlushed = true;
                this.syncObject.notifyAll();
            }
        }
    }

    public final boolean isInQueue() {
        return 0L != this.tExecuted && !this.isFlushed;
    }

    public final boolean isExecuted() {
        return 0L != this.tExecuted;
    }

    public final boolean isFlushed() {
        return this.isFlushed;
    }

    public final boolean hasWaiter() {
        return null != this.syncObject;
    }

    public final Throwable getThrowable() {
        return this.runnableException;
    }

    public final long getTimestampCreate() {
        return this.tCreated;
    }

    public final long getTimestampBeforeExec() {
        return this.tStarted;
    }

    public final long getTimestampAfterExec() {
        return this.tExecuted;
    }

    public final long getDurationInQueue() {
        return this.tStarted - this.tCreated;
    }

    public final long getDurationInExec() {
        return 0L < this.tExecuted ? this.tExecuted - this.tStarted : 0L;
    }

    public final long getDurationTotal() {
        return 0L < this.tExecuted ? this.tExecuted - this.tCreated : this.tStarted - this.tCreated;
    }

    public String toString() {
        return "RunnableTask[executed " + this.isExecuted() + ", tTotal " + this.getDurationTotal() + " ms, tExec " + this.getDurationInExec() + " ms, tQueue " + this.getDurationInQueue() + " ms, attachment " + this.attachment + ", throwable " + this.getThrowable() + "]";
    }
}

