/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.syphon;

import codeanticode.syphon.Syphon;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import jsyphon.JSyphonClient;
import jsyphon.JSyphonImage;
import jsyphon.JSyphonServerList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyphonClient {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected JSyphonClient client;
    protected IntBuffer getBuffer;
    public PGraphics tempDest;

    public SyphonClient(PApplet pApplet) {
        this.parent = pApplet;
        this.pg = (PGraphicsOpenGL)pApplet.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
    }

    public SyphonClient(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.pg = (PGraphicsOpenGL)pApplet.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
        if (string == null || string.equals("")) {
            throw new RuntimeException("No valid application name was provided");
        }
        this.client.setApplicationName(string);
    }

    public SyphonClient(PApplet pApplet, String string, String string2) {
        this.parent = pApplet;
        this.pg = (PGraphicsOpenGL)pApplet.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
        boolean bl = false;
        if (string != null && !string.equals("")) {
            this.client.setApplicationName(string);
            bl = true;
        }
        boolean bl2 = false;
        if (string2 != null && !string2.equals("")) {
            this.client.setServerName(string2);
            bl2 = true;
        }
        if (!bl && !bl2) {
            throw new RuntimeException("No valid application or server names were provided");
        }
    }

    public static HashMap<String, String>[] listServers() {
        Syphon.init();
        ArrayList arrayList = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 50; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            arrayList = JSyphonServerList.getList();
            if (arrayList.size() == n) {
                ++n2;
            }
            n = arrayList.size();
            if (10 < n2) break;
        }
        HashMap[] hashMapArray = new HashMap[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap hashMap = (HashMap)arrayList.get(i);
            String string = (String)hashMap.get("SyphonServerDescriptionAppNameKey");
            String string2 = (String)hashMap.get("SyphonServerDescriptionNameKey");
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("AppName", string);
            hashMap2.put("ServerName", string2);
            hashMapArray[i] = hashMap2;
        }
        return hashMapArray;
    }

    public HashMap<String, String> getServerName() {
        HashMap hashMap = this.client.serverDescription();
        String string = (String)hashMap.get("SyphonServerDescriptionAppNameKey");
        String string2 = (String)hashMap.get("SyphonServerDescriptionNameKey");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("AppName", string);
        hashMap2.put("ServerName", string2);
        return hashMap2;
    }

    public boolean available() {
        return this.client.hasNewFrame();
    }

    public PGraphics getGraphics(PGraphics pGraphics) {
        JSyphonImage jSyphonImage = this.client.newFrameImageForContext();
        int n = jSyphonImage.textureName();
        int n2 = jSyphonImage.textureWidth();
        int n3 = jSyphonImage.textureHeight();
        if (pGraphics == null || pGraphics.width != n2 || pGraphics.height != n3) {
            pGraphics = this.parent.createGraphics(n2, n3, "processing.opengl.PGraphics2D");
        }
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)pGraphics;
        pGraphicsOpenGL.beginDraw();
        pGraphicsOpenGL.background(0);
        pGraphicsOpenGL.drawTexture(34037, n, n2, n3, 0, 0, n2, n3);
        pGraphicsOpenGL.endDraw();
        return pGraphics;
    }

    public PImage getImage(PImage pImage) {
        return this.getImage(pImage, true);
    }

    public PImage getImage(PImage pImage, boolean bl) {
        JSyphonImage jSyphonImage = this.client.newFrameImageForContext();
        int n = jSyphonImage.textureName();
        int n2 = jSyphonImage.textureWidth();
        int n3 = jSyphonImage.textureHeight();
        if (pImage == null || pImage.width != n2 || pImage.height != n3) {
            pImage = this.parent.createImage(n2, n3, 2);
        }
        if (this.tempDest == null || this.tempDest.width != n2 || this.tempDest.height != n3) {
            this.tempDest = this.parent.createGraphics(n2, n3, "processing.opengl.PGraphics2D");
        }
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this.tempDest;
        pGraphicsOpenGL.beginDraw();
        pGraphicsOpenGL.background(0);
        pGraphicsOpenGL.drawTexture(34037, n, n2, n3, 0, 0, n2, n3);
        pGraphicsOpenGL.endDraw();
        this.pg.setCache(pImage, (Object)pGraphicsOpenGL.getTexture());
        if (bl) {
            pImage.loadPixels();
        }
        return pImage;
    }

    public void stop() {
        this.client.stop();
    }
}

