/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.syphon;

import codeanticode.syphon.Syphon;
import jsyphon.JSyphonServer;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class SyphonServer {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected JSyphonServer server;
    protected String serverName;

    public SyphonServer(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.pg = (PGraphicsOpenGL)pApplet.g;
        this.serverName = string;
        Syphon.init();
    }

    public boolean hasClients() {
        return this.server.hasClients();
    }

    public void sendImage(PImage pImage) {
        if (this.parent.frameCount == 0) {
            PGraphics.showWarning((String)"Only can send frames in draw()");
            return;
        }
        Texture texture = this.pg.getTexture(pImage);
        if (texture != null) {
            if (this.server == null) {
                this.server = new JSyphonServer();
                this.server.initWithName(this.serverName);
            }
            this.server.publishFrameTexture(texture.glName, texture.glTarget, 0, 0, texture.glWidth, texture.glHeight, texture.glWidth, texture.glHeight, false);
        } else {
            PGraphics.showWarning((String)"Texture is null");
        }
    }

    public void stop() {
        this.server.stop();
    }
}

