/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.syphon;

import codeanticode.syphon.Syphon;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import jsyphon.JSyphonClient;
import jsyphon.JSyphonImage;
import jsyphon.JSyphonServerList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;

public class SyphonClient {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected JSyphonClient client;
    protected IntBuffer getBuffer;
    public PGraphics tempDest;

    public SyphonClient(PApplet parent) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
    }

    public SyphonClient(PApplet parent, String appName) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
        if (appName == null || appName.equals("")) {
            throw new RuntimeException("No valid application name was provided");
        }
        this.client.setApplicationName(appName);
    }

    public SyphonClient(PApplet parent, String appName, String serverName) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        Syphon.init();
        this.client = new JSyphonClient();
        this.client.init();
        boolean setAppName = false;
        if (appName != null && !appName.equals("")) {
            this.client.setApplicationName(appName);
            setAppName = true;
        }
        boolean setServerName = false;
        if (serverName != null && !serverName.equals("")) {
            this.client.setServerName(serverName);
            setServerName = true;
        }
        if (!setAppName && !setServerName) {
            throw new RuntimeException("No valid application or server names were provided");
        }
    }

    public static HashMap<String, String>[] listServers() {
        Syphon.init();
        ArrayList tempList = null;
        int size0 = 0;
        int count = 0;
        for (int i = 0; i < 50; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            tempList = JSyphonServerList.getList();
            if (tempList.size() == size0) {
                ++count;
            }
            size0 = tempList.size();
            if (10 < count) break;
        }
        HashMap[] outArray = new HashMap[tempList.size()];
        for (int i = 0; i < tempList.size(); ++i) {
            HashMap desc = (HashMap)tempList.get(i);
            String appName = (String)desc.get("SyphonServerDescriptionAppNameKey");
            String serverName = (String)desc.get("SyphonServerDescriptionNameKey");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("AppName", appName);
            res.put("ServerName", serverName);
            outArray[i] = res;
        }
        return outArray;
    }

    public HashMap<String, String> getServerName() {
        HashMap desc = this.client.serverDescription();
        String appName = (String)desc.get("SyphonServerDescriptionAppNameKey");
        String serverName = (String)desc.get("SyphonServerDescriptionNameKey");
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("AppName", appName);
        res.put("ServerName", serverName);
        return res;
    }

    public boolean available() {
        return this.client.hasNewFrame();
    }

    public PGraphics getGraphics(PGraphics dest) {
        JSyphonImage img = this.client.newFrameImageForContext();
        int texId = img.textureName();
        int texWidth = img.textureWidth();
        int texHeight = img.textureHeight();
        if (dest == null || dest.width != texWidth || dest.height != texHeight) {
            dest = this.parent.createGraphics(texWidth, texHeight, "processing.opengl.PGraphics2D");
        }
        PGraphicsOpenGL destpg = (PGraphicsOpenGL)dest;
        destpg.beginDraw();
        destpg.background(0);
        destpg.drawTexture(34037, texId, texWidth, texHeight, 0, 0, texWidth, texHeight);
        destpg.endDraw();
        return dest;
    }

    public PImage getImage(PImage dest) {
        return this.getImage(dest, true);
    }

    public PImage getImage(PImage dest, boolean loadPixels) {
        JSyphonImage img = this.client.newFrameImageForContext();
        int texId = img.textureName();
        int texWidth = img.textureWidth();
        int texHeight = img.textureHeight();
        if (dest == null || dest.width != texWidth || dest.height != texHeight) {
            dest = this.parent.createImage(texWidth, texHeight, 2);
        }
        if (this.tempDest == null || this.tempDest.width != texWidth || this.tempDest.height != texHeight) {
            this.tempDest = this.parent.createGraphics(texWidth, texHeight, "processing.opengl.PGraphics2D");
        }
        PGraphicsOpenGL destpg = (PGraphicsOpenGL)this.tempDest;
        destpg.beginDraw();
        destpg.background(0);
        destpg.drawTexture(34037, texId, texWidth, texHeight, 0, 0, texWidth, texHeight);
        destpg.endDraw();
        this.pg.setCache(dest, (Object)destpg.getTexture());
        if (loadPixels) {
            dest.loadPixels();
        }
        return dest;
    }

    public void stop() {
        this.client.stop();
    }
}

