/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.util.DefaultAnimatorImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.FPSCounterImpl;

public abstract class AnimatorBase
implements GLAnimatorControl {
    protected static final boolean DEBUG = Debug.debug("Animator");
    protected static final long TO_WAIT_FOR_FINISH_LIFECYCLE_ACTION = 1000L;
    protected static final long POLLP_WAIT_FOR_FINISH_LIFECYCLE_ACTION = 32L;
    public static final int MODE_EXPECT_AWT_RENDERING_THREAD = 1;
    protected int modeBits = 1;
    protected AnimatorImpl impl;
    protected String baseName;
    protected ArrayList<GLAutoDrawable> drawables = new ArrayList();
    protected boolean drawablesEmpty = true;
    protected Thread animThread;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;
    protected boolean exclusiveContext;
    protected Thread userExclusiveContextThread;
    protected FPSCounterImpl fpsCounter = new FPSCounterImpl();
    protected RecursiveLock stateSync = LockFactory.createRecursiveLock();
    private static final Class<?> awtAnimatorImplClazz;
    private final Condition waitForNotAnimatingIfEmptyCondition = new Condition(){

        @Override
        public boolean eval() {
            return AnimatorBase.this.isStarted() && AnimatorBase.this.drawablesEmpty && AnimatorBase.this.isAnimating();
        }
    };

    protected void initImpl(boolean bl) {
        if (bl || null == this.impl) {
            if (0 != (1 & this.modeBits) && null != awtAnimatorImplClazz) {
                try {
                    this.impl = (AnimatorImpl)awtAnimatorImplClazz.newInstance();
                    this.baseName = this.getBaseName("AWT");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null == this.impl) {
                this.impl = new DefaultAnimatorImpl();
                this.baseName = this.getBaseName("");
            }
            if (DEBUG) {
                System.err.println("Animator.initImpl: baseName " + this.baseName + ", implClazz " + this.impl.getClass().getName() + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
            }
        }
    }

    protected abstract String getBaseName(String var1);

    public synchronized void setModeBits(boolean bl, int n) throws GLException {
        if (this.isStarted()) {
            throw new GLException("Animator already started");
        }
        int n2 = this.modeBits;
        this.modeBits = bl ? (this.modeBits |= n) : (this.modeBits &= ~n);
        if (n2 != this.modeBits) {
            this.initImpl(true);
        }
    }

    public synchronized int getModeBits() {
        return this.modeBits;
    }

    @Override
    public synchronized void add(final GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator add: 0x" + Integer.toHexString(gLAutoDrawable.hashCode()) + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
        }
        if (this.drawables.contains(gLAutoDrawable)) {
            throw new IllegalArgumentException("Drawable already added to animator: " + this + ", " + gLAutoDrawable);
        }
        this.initImpl(false);
        this.pause();
        if (this.isStarted()) {
            gLAutoDrawable.setExclusiveContextThread(this.exclusiveContext ? this.getExclusiveContextThread() : null);
        }
        this.drawables.add(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(this);
        if (this.isPaused()) {
            this.resume();
        }
        Condition condition = new Condition(){

            @Override
            public boolean eval() {
                Thread thread = gLAutoDrawable.getExclusiveContextThread();
                return AnimatorBase.this.isStarted() && !AnimatorBase.this.isPaused() && !AnimatorBase.this.isAnimating() && (AnimatorBase.this.exclusiveContext && null == thread || !AnimatorBase.this.exclusiveContext && null != thread);
            }
        };
        boolean bl = this.finishLifecycleAction(condition, 0L);
        if (DEBUG) {
            System.err.println("Animator add: Wait for Animating/ECT OK: " + bl + ", " + this.toString() + ", dect " + gLAutoDrawable.getExclusiveContextThread());
        }
        this.notifyAll();
    }

    @Override
    public synchronized void remove(final GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        if (DEBUG) {
            System.err.println("Animator remove: 0x" + Integer.toHexString(gLAutoDrawable.hashCode()) + " - " + this.toString() + " - " + AnimatorBase.getThreadName());
        }
        if (!this.drawables.contains(gLAutoDrawable)) {
            throw new IllegalArgumentException("Drawable not added to animator: " + this + ", " + gLAutoDrawable);
        }
        if (this.exclusiveContext && this.isAnimating()) {
            gLAutoDrawable.setExclusiveContextThread(null);
            Condition condition = new Condition(){

                @Override
                public boolean eval() {
                    return null != gLAutoDrawable.getExclusiveContextThread();
                }
            };
            bl = this.finishLifecycleAction(condition, 32L);
            if (DEBUG) {
                System.err.println("Animator remove: Wait for Null-ECT OK: " + bl + ", " + this.toString() + ", dect " + gLAutoDrawable.getExclusiveContextThread());
            }
        }
        boolean bl2 = this.pause();
        this.drawables.remove(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(null);
        if (bl2) {
            this.resume();
        }
        bl = this.finishLifecycleAction(this.waitForNotAnimatingIfEmptyCondition, 0L);
        if (DEBUG) {
            System.err.println("Animator remove: Wait for !Animating-if-empty OK: " + bl + ", " + this.toString());
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Thread setExclusiveContext(Thread thread) {
        Thread thread2;
        boolean bl = null != thread;
        this.stateSync.lock();
        try {
            thread2 = this.userExclusiveContextThread;
            if (bl && thread != this.animThread) {
                this.userExclusiveContextThread = thread;
            }
        }
        finally {
            this.stateSync.unlock();
        }
        this.setExclusiveContext(bl);
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setExclusiveContext(boolean bl) {
        boolean bl2;
        Thread thread;
        boolean bl3;
        AnimatorBase animatorBase = this;
        synchronized (animatorBase) {
            bl3 = this.isStarted() && !this.drawablesEmpty;
            thread = this.userExclusiveContextThread;
            bl2 = this.exclusiveContext;
            this.exclusiveContext = bl;
            if (DEBUG) {
                System.err.println("AnimatorBase.setExclusiveContextThread: " + bl2 + " -> " + this.exclusiveContext + ", propagateState " + bl3 + ", " + this);
            }
        }
        Object object = bl ? (null != this.userExclusiveContextThread ? this.userExclusiveContextThread : this.animThread) : (animatorBase = null);
        if (bl3) {
            this.setDrawablesExclCtxState(bl);
            if (!bl) {
                if (Thread.currentThread() == this.getThread() || Thread.currentThread() == thread) {
                    this.display();
                } else {
                    boolean bl4 = this.isAnimating() ? false : this.resume();
                    for (int i = 10; 0 < i && this.isAnimating() && !this.validateDrawablesExclCtxState((Thread)((Object)animatorBase)); --i) {
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (bl4) {
                        this.pause();
                    }
                }
                this.stateSync.lock();
                try {
                    this.userExclusiveContextThread = null;
                }
                finally {
                    this.stateSync.unlock();
                }
            }
        }
        if (DEBUG) {
            System.err.println("AnimatorBase.setExclusiveContextThread: all-GLAD Ok: " + this.validateDrawablesExclCtxState((Thread)((Object)animatorBase)) + ", " + this);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExclusiveContextEnabled() {
        this.stateSync.lock();
        try {
            boolean bl = this.exclusiveContext;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Thread getExclusiveContextThread() {
        this.stateSync.lock();
        try {
            Thread thread = this.isStartedImpl() && this.exclusiveContext ? (null != this.userExclusiveContextThread ? this.userExclusiveContextThread : this.animThread) : null;
            return thread;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    protected final synchronized void setDrawablesExclCtxState(boolean bl) {
        if (DEBUG) {
            System.err.println("AnimatorBase.setExclusiveContextImpl exlusive " + this.exclusiveContext + ": Enable " + bl + " for " + this + " - " + Thread.currentThread());
        }
        Thread thread = this.getExclusiveContextThread();
        for (int i = 0; i < this.drawables.size(); ++i) {
            try {
                this.drawables.get(i).setExclusiveContextThread(bl ? thread : null);
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    protected final boolean validateDrawablesExclCtxState(Thread thread) {
        for (int i = 0; i < this.drawables.size(); ++i) {
            if (thread == this.drawables.get(i).getExclusiveContextThread()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getThread() {
        this.stateSync.lock();
        try {
            Thread thread = this.animThread;
            return thread;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    protected void display() {
        this.impl.display(this.drawables, this.ignoreExceptions, this.printExceptions);
        this.fpsCounter.tickFPS();
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean finishLifecycleAction(Condition condition, long l) {
        long l2;
        this.initImpl(false);
        boolean bl = this.impl.blockUntilDone(this.animThread);
        long l3 = l2 = bl ? 1000L : 0L;
        if (0L >= l) {
            l = l2;
        }
        boolean bl2 = condition.eval();
        while (bl2 && l2 > 0L) {
            long l4 = System.currentTimeMillis();
            if (l > l2) {
                l = l2;
            }
            this.notifyAll();
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 -= System.currentTimeMillis() - l4;
            bl2 = condition.eval();
        }
        if (DEBUG || bl && bl2) {
            if (l2 <= 0L && bl2) {
                System.err.println("finishLifecycleAction(" + condition.getClass().getName() + "): ++++++ timeout reached ++++++ " + AnimatorBase.getThreadName());
            }
            this.stateSync.lock();
            try {
                System.err.println("finishLifecycleAction(" + condition.getClass().getName() + "): OK " + !bl2 + "- pollPeriod " + l + ", blocking " + bl + ", waited " + (bl ? 1000L - l2 : 0L) + "/" + 1000L + " - " + AnimatorBase.getThreadName());
                System.err.println(" - " + this.toString());
            }
            finally {
                this.stateSync.unlock();
            }
            if (bl2) {
                Thread.dumpStack();
            }
        }
        return !bl2;
    }

    protected final boolean isStartedImpl() {
        return this.animThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        return this.getClass().getName() + "[started " + this.isStarted() + ", animating " + this.isAnimating() + ", paused " + this.isPaused() + ", drawable " + this.drawables.size() + ", totals[dt " + this.getTotalFPSDuration() + ", frames " + this.getTotalFPSFrames() + ", fps " + this.getTotalFPS() + "], modeBits " + this.modeBits + ", init'ed " + (null != this.impl) + ", animThread " + this.getThread() + ", exclCtxThread " + this.exclusiveContext + "(" + this.getExclusiveContextThread() + ")]";
    }

    static {
        GLProfile.initSingleton();
        if (GLProfile.isAWTAvailable()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.jogamp.opengl.util.AWTAnimatorImpl");
            }
            catch (Exception exception) {
                clazz = null;
            }
            awtAnimatorImplClazz = clazz;
        } else {
            awtAnimatorImplClazz = null;
        }
    }

    protected static interface Condition {
        public boolean eval();
    }

    public static interface AnimatorImpl {
        public void display(ArrayList<GLAutoDrawable> var1, boolean var2, boolean var3);

        public boolean blockUntilDone(Thread var1);
    }
}

