/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.texture.TextureData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.util.jpeg.JPEGDecoder;

public class JPEGImage {
    private static final boolean DEBUG = Debug.debug("JPEGImage");
    private JPEGPixelStorage pixelStorage;
    private final int pixelWidth;
    private final int pixelHeight;
    private final int glFormat;
    private final int bytesPerPixel;
    private boolean reversedChannels;
    private final ByteBuffer data;

    public static JPEGImage read(InputStream inputStream, TextureData.ColorSpace colorSpace) throws IOException {
        return new JPEGImage(inputStream, colorSpace);
    }

    public static JPEGImage read(InputStream inputStream) throws IOException {
        return new JPEGImage(inputStream, TextureData.ColorSpace.RGB);
    }

    private JPEGImage(InputStream inputStream, TextureData.ColorSpace colorSpace) throws IOException {
        this.pixelStorage = new JPEGPixelStorage(colorSpace);
        JPEGDecoder jPEGDecoder = new JPEGDecoder();
        jPEGDecoder.parse(inputStream);
        this.pixelWidth = jPEGDecoder.getWidth();
        this.pixelHeight = jPEGDecoder.getHeight();
        jPEGDecoder.getPixel(this.pixelStorage, this.pixelWidth, this.pixelHeight);
        this.data = this.pixelStorage.data;
        this.bytesPerPixel = 3;
        this.glFormat = 6407;
        this.reversedChannels = false;
        if (DEBUG) {
            System.err.println("JPEGImage: alpha false, bytesPerPixel " + this.bytesPerPixel + ", pixels " + this.pixelWidth + "x" + this.pixelHeight + ", glFormat 0x" + Integer.toHexString(this.glFormat));
            System.err.println("JPEGImage: " + jPEGDecoder);
            System.err.println("JPEGImage: " + this.pixelStorage);
        }
        jPEGDecoder.clear(null);
    }

    public TextureData.ColorSpace getColorSpace() {
        return this.pixelStorage.storageCS;
    }

    public int getComponentCount() {
        return this.pixelStorage.storageComponents;
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public boolean getHasReversedChannels() {
        return this.reversedChannels;
    }

    public int getGLFormat() {
        return this.glFormat;
    }

    public int getGLType() {
        return 5121;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String toString() {
        return "JPEGImage[" + this.pixelWidth + "x" + this.pixelHeight + ", bytesPerPixel " + this.bytesPerPixel + ", reversedChannels " + this.reversedChannels + ", " + this.pixelStorage + ", " + this.data + "]";
    }

    private static class JPEGPixelStorage
    implements JPEGDecoder.PixelStorage {
        int width = 0;
        int height = 0;
        int sourceComponents = 0;
        TextureData.ColorSpace sourceCS = TextureData.ColorSpace.YCbCr;
        int storageComponents;
        final TextureData.ColorSpace storageCS;
        ByteBuffer data = null;

        JPEGPixelStorage(TextureData.ColorSpace colorSpace) {
            this.storageCS = colorSpace;
            switch (this.storageCS) {
                case RGB: 
                case YCbCr: {
                    this.storageComponents = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported storage color-space: " + (Object)((Object)this.storageCS));
                }
            }
        }

        @Override
        public final TextureData.ColorSpace allocate(int n, int n2, TextureData.ColorSpace colorSpace, int n3) throws RuntimeException {
            this.width = n;
            this.height = n2;
            this.sourceComponents = n3;
            this.sourceCS = colorSpace;
            this.data = Buffers.newDirectByteBuffer((int)(n * n2 * this.storageComponents));
            return this.storageCS;
        }

        @Override
        public final void storeRGB(int n, int n2, byte by, byte by2, byte by3) {
            int n3 = ((this.height - n2 - 1) * this.width + n) * this.storageComponents;
            this.data.put(n3++, by);
            this.data.put(n3++, by2);
            this.data.put(n3++, by3);
        }

        @Override
        public final void store2(int n, int n2, byte by, byte by2) {
            throw new RuntimeException("not supported yet");
        }

        @Override
        public final void storeYCbCr(int n, int n2, byte by, byte by2, byte by3) {
            int n3 = ((this.height - n2 - 1) * this.width + n) * this.storageComponents;
            this.data.put(n3++, by);
            this.data.put(n3++, by2);
            this.data.put(n3++, by3);
        }

        public String toString() {
            return "JPEGPixels[" + this.width + "x" + this.height + ", sourceComp " + this.sourceComponents + ", sourceCS " + (Object)((Object)this.sourceCS) + ", storageCS " + (Object)((Object)this.storageCS) + ", storageComp " + this.storageComponents + "]";
        }
    }
}

