/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.util.MonitorMode;
import com.jogamp.newt.util.ScreenModeUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.SurfaceSize;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenModeStatus;

public abstract class ScreenImpl
extends Screen
implements ScreenModeListener {
    protected static final boolean DEBUG_TEST_SCREENMODE_DISABLED = Debug.isPropertyDefined("newt.test.Screen.disableScreenMode", true);
    public static final int default_sm_bpp = 32;
    public static final int default_sm_widthmm = 519;
    public static final int default_sm_heightmm = 324;
    public static final int default_sm_rate = 60;
    public static final int default_sm_rotation = 0;
    protected DisplayImpl display;
    protected int screen_idx;
    protected String fqname;
    protected int hashCode;
    protected AbstractGraphicsScreen aScreen;
    protected int refCount;
    protected Point vOrigin = new Point(0, 0);
    protected Dimension vSize = new Dimension(0, 0);
    protected static Dimension usrSize = null;
    protected static volatile boolean usrSizeQueried = false;
    private ArrayList<ScreenModeListener> referencedScreenModeListener = new ArrayList();
    private long tCreated;

    private static Class<?> getScreenClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "ScreenDriver");
        if (null == clazz) {
            throw new ClassNotFoundException("Failed to find NEWT Screen Class <" + string + ".ScreenDriver>");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Screen create(Display display, int n) {
        try {
            Object object;
            if (!usrSizeQueried) {
                object = Screen.class;
                // MONITORENTER : com.jogamp.newt.Screen.class
                if (!usrSizeQueried) {
                    usrSizeQueried = true;
                    int n2 = Debug.getIntProperty("newt.ws.swidth", true, 0);
                    int n3 = Debug.getIntProperty("newt.ws.sheight", true, 0);
                    if (n2 > 0 && n3 > 0) {
                        usrSize = new Dimension(n2, n3);
                        System.err.println("User screen size " + usrSize);
                    }
                }
                // MONITOREXIT : object
            }
            object = screenList;
            // MONITORENTER : object
            Class<?> clazz = ScreenImpl.getScreenClass(display.getType());
            ScreenImpl screenImpl = (ScreenImpl)clazz.newInstance();
            screenImpl.display = (DisplayImpl)display;
            n = screenImpl.validateScreenIndex(n);
            Screen screen = ScreenImpl.getLastScreenOf(display, n, -1);
            if (null != screen) {
                if (DEBUG) {
                    System.err.println("Screen.create() REUSE: " + screen + " " + Display.getThreadName());
                }
                screenImpl = null;
                // MONITOREXIT : object
                return screen;
            }
            screenImpl.screen_idx = n;
            screenImpl.fqname = display.getFQName() + "-s" + n;
            screenImpl.hashCode = screenImpl.fqname.hashCode();
            screenList.add(screenImpl);
            if (DEBUG) {
                System.err.println("Screen.create() NEW: " + screenImpl + " " + Display.getThreadName());
            }
            // MONITOREXIT : object
            return screenImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScreenImpl screenImpl = (ScreenImpl)object;
        if (!(this.display == screenImpl.display || this.display != null && this.display.equals(screenImpl.display))) {
            return false;
        }
        return this.screen_idx == screenImpl.screen_idx;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        Object object;
        if (null == this.aScreen) {
            if (DEBUG) {
                this.tCreated = System.nanoTime();
                System.err.println("Screen.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            } else {
                this.tCreated = 0L;
            }
            this.display.addReference();
            this.createNativeImpl();
            if (null == this.aScreen) {
                throw new NativeWindowException("Screen.createNative() failed to instanciate an AbstractGraphicsScreen");
            }
            this.initScreenModeStatus();
            this.updateVirtualScreenOriginAndSize();
            if (DEBUG) {
                System.err.println("Screen.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + "), total " + (double)(System.nanoTime() - this.tCreated) / 1000000.0 + "ms");
            }
            object = screenList;
            synchronized (object) {
                ++screensActive;
            }
        }
        object = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        ((ScreenModeStatus)object).addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        this.releaseScreenModeStatus();
        ArrayList arrayList = screenList;
        synchronized (arrayList) {
            screenList.remove(this);
            if (0 < screensActive) {
                --screensActive;
            }
        }
        if (null != this.aScreen) {
            this.closeNativeImpl();
            this.aScreen = null;
        }
        this.refCount = 0;
        this.display.removeReference();
    }

    @Override
    public final synchronized int addReference() throws NativeWindowException {
        if (DEBUG) {
            System.err.println("Screen.addReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aScreen) {
            throw new NativeWindowException("Screen.addReference() (refCount " + this.refCount + ") null AbstractGraphicsScreen");
        }
        return ++this.refCount;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            System.err.println("Screen.removeReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1));
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract int validateScreenIndex(int var1);

    protected abstract void getVirtualScreenOriginAndSize(Point var1, Dimension var2);

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    protected void updateVirtualScreenOriginAndSize() {
        this.getVirtualScreenOriginAndSize(this.vOrigin, this.vSize);
        if (DEBUG) {
            System.err.println("Detected virtual screen origin " + this.vOrigin + ", size " + this.vSize);
        }
    }

    @Override
    public final Display getDisplay() {
        return this.display;
    }

    @Override
    public final int getIndex() {
        return this.screen_idx;
    }

    @Override
    public final AbstractGraphicsScreen getGraphicsScreen() {
        return this.aScreen;
    }

    @Override
    public final synchronized boolean isNativeValid() {
        return null != this.aScreen;
    }

    @Override
    public int getX() {
        return this.vOrigin.getX();
    }

    @Override
    public int getY() {
        return this.vOrigin.getY();
    }

    @Override
    public final int getWidth() {
        return null != usrSize ? usrSize.getWidth() : this.vSize.getWidth();
    }

    @Override
    public final int getHeight() {
        return null != usrSize ? usrSize.getHeight() : this.vSize.getHeight();
    }

    public String toString() {
        return "NEWT-Screen[" + this.getFQName() + ", idx " + this.screen_idx + ", refCount " + this.refCount + ", " + this.getWidth() + "x" + this.getHeight() + ", " + this.aScreen + ", " + this.display + "]";
    }

    @Override
    public final List<ScreenMode> getScreenModes() {
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        if (null != arrayHashSet && 0 < arrayHashSet.size()) {
            return arrayHashSet.toArrayList();
        }
        return null;
    }

    private final ScreenModeStatus getScreenModeStatus(boolean bl) {
        String string = this.getFQName();
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(string);
        if (null == screenModeStatus & bl) {
            throw new InternalError("ScreenModeStatus.getScreenModeStatus(" + string + ") == null");
        }
        return screenModeStatus;
    }

    @Override
    public ScreenMode getOriginalScreenMode() {
        ScreenModeStatus screenModeStatus = this.getScreenModeStatus(false);
        return null != screenModeStatus ? screenModeStatus.getOriginalScreenMode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenMode getCurrentScreenMode() {
        ScreenMode screenMode = null;
        ScreenModeStatus screenModeStatus = this.getScreenModeStatus(true);
        ScreenMode screenMode2 = this.getCurrentScreenModeIntern();
        if (null == screenMode2) {
            throw new InternalError("getCurrentScreenModeImpl() == null");
        }
        screenModeStatus.lock();
        try {
            screenMode = (ScreenMode)screenModeStatus.getScreenModes().getOrAdd((Object)screenMode2);
            if (screenModeStatus.getCurrentScreenMode().hashCode() != screenMode.hashCode()) {
                screenModeStatus.fireScreenModeChanged(screenMode, true);
            }
        }
        finally {
            screenModeStatus.unlock();
        }
        return screenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentScreenMode(ScreenMode screenMode) {
        boolean bl;
        ScreenMode screenMode2 = this.getCurrentScreenMode();
        ScreenMode screenMode3 = (ScreenMode)this.getScreenModesOrig().get((Object)screenMode);
        if (screenMode3.equals(screenMode2)) {
            if (DEBUG) {
                System.err.println("Screen.setCurrentScreenMode (" + (System.nanoTime() - this.tCreated) + "): 0.0 is-current (skip) " + screenMode3 + " == " + screenMode2);
            }
            return true;
        }
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null == screenModeStatus) {
            throw new InternalError("ScreenModeStatus.getScreenModeStatus(" + this.getFQName() + ") == null");
        }
        screenModeStatus.lock();
        try {
            long l = DEBUG ? System.nanoTime() : 0L;
            screenModeStatus.fireScreenModeChangeNotify(screenMode3);
            if (DEBUG) {
                System.err.println("Screen.setCurrentScreenMode (" + (double)(System.nanoTime() - l) / 1000000.0 + "ms): fireScreenModeChangeNotify() " + screenMode3);
            }
            if (bl = this.setCurrentScreenModeImpl(screenMode3)) {
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (double)(System.nanoTime() - l) / 1000000.0 + "ms): setCurrentScreenModeImpl() " + screenMode3 + ", success(1): " + bl);
                }
            } else {
                ScreenMode screenMode4 = this.getCurrentScreenMode();
                ScreenMode screenMode5 = screenModeStatus.getCurrentScreenMode();
                boolean bl2 = bl = screenMode5.hashCode() == screenMode3.hashCode() && screenMode4.hashCode() == screenMode3.hashCode();
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode.2: queried " + screenMode4);
                    System.err.println("Screen.setCurrentScreenMode.2:     SMS " + screenMode5);
                    System.err.println("Screen.setCurrentScreenMode (" + (double)(System.nanoTime() - l) / 1000000.0 + "ms): setCurrentScreenModeImpl() " + screenMode3 + ", success(2): " + bl);
                }
            }
            screenModeStatus.fireScreenModeChanged(screenMode3, bl);
            if (DEBUG) {
                System.err.println("Screen.setCurrentScreenMode (" + (double)(System.nanoTime() - l) / 1000000.0 + "ms): X.X " + screenMode3 + ", success: " + bl);
            }
        }
        finally {
            screenModeStatus.unlock();
        }
        return bl;
    }

    @Override
    public void screenModeChangeNotify(ScreenMode screenMode) {
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            this.referencedScreenModeListener.get(i).screenModeChangeNotify(screenMode);
        }
    }

    @Override
    public void screenModeChanged(ScreenMode screenMode, boolean bl) {
        if (bl) {
            this.updateVirtualScreenOriginAndSize();
        }
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            this.referencedScreenModeListener.get(i).screenModeChanged(screenMode, bl);
        }
    }

    @Override
    public final synchronized void addScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.add(screenModeListener);
    }

    @Override
    public final synchronized void removeScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.remove(screenModeListener);
    }

    protected final ArrayHashSet<ScreenMode> getScreenModesOrig() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModes();
        }
        return null;
    }

    protected final IntIntHashMap getScreenModesIdx2NativeIdx() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModesIdx2NativeIdx();
        }
        return null;
    }

    protected int[] getScreenModeFirstImpl() {
        return null;
    }

    protected int[] getScreenModeNextImpl() {
        return null;
    }

    protected ScreenMode getCurrentScreenModeImpl() {
        return null;
    }

    protected ScreenMode getCurrentScreenModeIntern() {
        ScreenMode screenMode = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
        if (null == screenMode) {
            if (0 >= this.getWidth() || 0 >= this.getHeight()) {
                this.updateVirtualScreenOriginAndSize();
            }
            int[] nArray = new int[8];
            int n = 0;
            nArray[n++] = 0;
            nArray[n++] = this.getWidth();
            nArray[n++] = this.getHeight();
            nArray[n++] = 32;
            nArray[n++] = 519;
            nArray[n++] = 324;
            nArray[n++] = 60;
            nArray[n++] = 0;
            nArray[n - 8] = n;
            screenMode = ScreenModeUtil.streamIn(nArray, 0);
        }
        return screenMode;
    }

    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScreenModeStatus initScreenModeStatus() {
        ScreenModeStatus screenModeStatus;
        long l;
        if (DEBUG) {
            l = System.nanoTime();
            System.err.println("Screen.initScreenModeStatus() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
        } else {
            l = 0L;
        }
        ScreenModeStatus.lockScreenModeStatus();
        try {
            screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
            if (null == screenModeStatus) {
                IntIntHashMap intIntHashMap = new IntIntHashMap();
                ScreenMode screenMode = this.getCurrentScreenModeIntern();
                if (null == screenMode) {
                    throw new InternalError("getCurrentScreenModeImpl() == null");
                }
                ArrayHashSet<ScreenMode> arrayHashSet = this.collectNativeScreenModes(intIntHashMap);
                arrayHashSet.getOrAdd((Object)screenMode);
                if (DEBUG) {
                    int n = 0;
                    Iterator iterator = arrayHashSet.iterator();
                    while (iterator.hasNext()) {
                        System.err.println(n + ": " + iterator.next());
                        ++n;
                    }
                }
                screenModeStatus = new ScreenModeStatus(arrayHashSet, intIntHashMap);
                ScreenMode screenMode2 = (ScreenMode)arrayHashSet.get((Object)screenMode);
                if (null == screenMode2) {
                    throw new RuntimeException(screenMode + " could not be hashed from ScreenMode list");
                }
                screenModeStatus.setOriginalScreenMode(screenMode2);
                ScreenModeStatus.mapScreenModeStatus(this.getFQName(), screenModeStatus);
            }
        }
        finally {
            ScreenModeStatus.unlockScreenModeStatus();
        }
        if (DEBUG) {
            System.err.println("Screen.initScreenModeStatus() END dt " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
        }
        return screenModeStatus;
    }

    private ArrayHashSet<ScreenMode> collectNativeScreenModes(IntIntHashMap intIntHashMap) {
        ArrayHashSet arrayHashSet = new ArrayHashSet();
        ArrayHashSet arrayHashSet2 = new ArrayHashSet();
        ArrayHashSet arrayHashSet3 = new ArrayHashSet();
        ArrayHashSet arrayHashSet4 = new ArrayHashSet();
        ArrayHashSet arrayHashSet5 = new ArrayHashSet();
        int[] nArray = null;
        int n = 0;
        do {
            if (null != (nArray = DEBUG_TEST_SCREENMODE_DISABLED ? null : (0 == n ? this.getScreenModeFirstImpl() : this.getScreenModeNextImpl())) && 0 < nArray.length && nArray[4] >= 15) {
                int n2 = nArray[0];
                int n3 = ScreenModeUtil.streamIn((ArrayHashSet<DimensionImmutable>)arrayHashSet, (ArrayHashSet<SurfaceSize>)arrayHashSet2, (ArrayHashSet<DimensionImmutable>)arrayHashSet3, (ArrayHashSet<MonitorMode>)arrayHashSet4, (ArrayHashSet<ScreenMode>)arrayHashSet5, nArray, 1);
                if (DEBUG) {
                    System.err.println("ScreenImpl.collectNativeScreenModes: #" + n + ": idx: " + n2 + " native -> " + n3 + " newt");
                }
                if (n3 >= 0) {
                    intIntHashMap.put(n3, n2);
                }
            } else if (DEBUG) {
                System.err.println("ScreenImpl.collectNativeScreenModes: #" + n + ": smProps: " + (null != nArray) + ", len: " + (null != nArray ? nArray.length : 0) + ", bpp: " + (null != nArray && 0 < nArray.length ? nArray[4] : 0) + " - DROPPING");
            }
            ++n;
        } while (null != nArray && 0 < nArray.length);
        if (DEBUG) {
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenMode number  : " + arrayHashSet5.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: MonitorMode number : " + arrayHashSet4.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenSizeMM number: " + arrayHashSet3.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: SurfaceSize number : " + arrayHashSet2.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: Resolution number  : " + arrayHashSet.size());
        }
        return arrayHashSet5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseScreenModeStatus() {
        block9: {
            ScreenModeStatus.lockScreenModeStatus();
            try {
                ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
                if (null == screenModeStatus) break block9;
                screenModeStatus.lock();
                try {
                    if (0 != screenModeStatus.removeListener(this)) break block9;
                    if (screenModeStatus.isOriginalModeChangedByOwner()) {
                        System.err.println("Screen.destroy(): " + screenModeStatus.getCurrentScreenMode() + " -> " + screenModeStatus.getOriginalScreenMode());
                        try {
                            this.setCurrentScreenMode(screenModeStatus.getOriginalScreenMode());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    ScreenModeStatus.unmapScreenModeStatus(this.getFQName());
                }
                finally {
                    screenModeStatus.unlock();
                }
            }
            finally {
                ScreenModeStatus.unlockScreenModeStatus();
            }
        }
    }

    private final void shutdown() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatusUnlocked(this.getFQName());
        if (null != screenModeStatus) {
            if (screenModeStatus.isOriginalModeChangedByOwner()) {
                try {
                    System.err.println("Screen.shutdown(): " + screenModeStatus.getCurrentScreenMode() + " -> " + screenModeStatus.getOriginalScreenMode());
                    this.setCurrentScreenModeImpl(screenModeStatus.getOriginalScreenMode());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ScreenModeStatus.unmapScreenModeStatusUnlocked(this.getFQName());
        }
    }

    private static final void shutdownAll() {
        for (int i = 0; i < screenList.size(); ++i) {
            ((ScreenImpl)screenList.get(i)).shutdown();
        }
    }

    private static synchronized void registerShutdownHook() {
        final Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ScreenImpl.shutdownAll();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(thread);
                return null;
            }
        });
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ScreenImpl.registerShutdownHook();
                return null;
            }
        });
    }
}

