/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.syphon;

import codeanticode.syphon.Syphon;
import jsyphon.JSyphonServer;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class SyphonServer {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected JSyphonServer server;
    protected String serverName;

    public SyphonServer(PApplet parent, String name) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        this.serverName = name;
        Syphon.init();
    }

    public boolean hasClients() {
        return this.server.hasClients();
    }

    public void sendImage(PImage source) {
        if (this.parent.frameCount == 0) {
            PGraphics.showWarning((String)"Only can send frames in draw()");
            return;
        }
        Texture tex = this.pg.getTexture(source);
        if (tex != null) {
            if (this.server == null) {
                this.server = new JSyphonServer();
                this.server.initWithName(this.serverName);
            }
            this.server.publishFrameTexture(tex.glName, tex.glTarget, 0, 0, tex.glWidth, tex.glHeight, tex.glWidth, tex.glHeight, false);
        } else {
            PGraphics.showWarning((String)"Texture is null");
        }
    }

    public void stop() {
        this.server.stop();
    }
}

