/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntList;
import processing.data.Sort;

public class FloatList
implements Iterable<Float> {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(int length) {
        this.data = new float[length];
    }

    public FloatList(float[] list) {
        this.count = list.length;
        this.data = new float[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public FloatList(Iterable<Float> iter) {
        this(10);
        for (float v : iter) {
            this.append(v);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            float[] temp = new float[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0.0f);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public float get(int index) {
        return this.data[index];
    }

    public void set(int index, float what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            int i = this.count;
            while (i < index) {
                this.data[i] = 0.0f;
                ++i;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void remove(int index) {
        int i = index;
        while (i < this.count) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.count;
    }

    public boolean removeValue(float value) {
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.remove(index);
                return true;
            }
        }
        return false;
    }

    public boolean removeValues(float value) {
        int ii = 0;
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (!Float.isNaN(this.data[i])) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] != value) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        }
        if (this.count == ii) {
            return false;
        }
        this.count = ii;
        return true;
    }

    public boolean replaceValue(float value, float newValue) {
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    return true;
                }
                ++i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.data[index] = newValue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(float value, float newValue) {
        boolean changed = false;
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    public void append(float value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(float[] values) {
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void append(FloatList list) {
        float[] fArray = list.values();
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void insert(int index, int[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= values.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        float[] temp = new float[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, IntList list) {
        this.insert(index, list.values());
    }

    public int index(float what) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == what) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasValue(float value) {
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void add(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] + amount;
    }

    public void sub(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] - amount;
    }

    public void mult(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] * amount;
    }

    public void div(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] / amount;
    }

    public float min() {
        if (this.count == 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot use min() on IntList of length 0.");
        }
        if (this.data.length == 0) {
            return Float.NaN;
        }
        float m = Float.NaN;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                int j = i + 1;
                while (j < this.data.length) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d < m) {
                        m = this.data[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return m;
    }

    public float max() {
        if (this.count == 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot use max() on IntList of length 0.");
        }
        if (this.data.length == 0) {
            return Float.NaN;
        }
        float m = Float.NaN;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                int j = i + 1;
                while (j < this.data.length) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d > m) {
                        m = this.data[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return m;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return FloatList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                return FloatList.this.data[b] - FloatList.this.data[a];
            }

            @Override
            public void swap(int a, int b) {
                float temp = FloatList.this.data[a];
                FloatList.this.data[a] = FloatList.this.data[b];
                FloatList.this.data[b] = temp;
            }
        }.run();
    }

    public void subset(int start) {
        this.subset(start, this.count - start);
    }

    public void subset(int start, int num) {
        int i = 0;
        while (i < num) {
            this.data[i] = this.data[i + start];
            ++i;
        }
        this.count = num;
    }

    public void reverse() {
        int ii = this.count - 1;
        int i = 0;
        while (i < this.count / 2) {
            float t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
            ++i;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public FloatList copy() {
        FloatList outgoing = new FloatList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatList.this.remove(this.index);
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatList.this.data[++this.index]);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatList.this.count;
            }
        };
    }

    public int[] array() {
        return this.array(null);
    }

    public int[] array(int[] array) {
        if (array == null || array.length != this.count) {
            array = new int[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " [ ");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(i) + ": " + this.data[i]);
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }
}

