/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.io.IOException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class PShader {
    protected static final int COLOR = 0;
    protected static final int LIGHT = 1;
    protected static final int TEXTURE = 2;
    protected static final int TEXLIGHT = 3;
    protected static final int LINE = 4;
    protected static final int POINT = 5;
    protected PApplet parent;
    protected PGraphicsOpenGL pgMain;
    protected PGraphicsOpenGL pgCurrent;
    protected PGL pgl;
    protected int context;
    public int glProgram;
    public int glVertex;
    public int glFragment;
    protected URL vertexURL;
    protected URL fragmentURL;
    protected String vertexFilename;
    protected String fragmentFilename;
    protected String vertexShaderSource;
    protected String fragmentShaderSource;
    protected boolean bound;
    protected HashMap<Integer, UniformValue> uniformValues = null;
    protected HashMap<Integer, Texture> textures;
    protected int firstTexUnit;
    protected int lastTexUnit;
    protected IntBuffer intBuffer;
    protected FloatBuffer floatBuffer;

    public PShader() {
        this.parent = null;
        this.pgMain = null;
        this.pgl = null;
        this.context = -1;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.firstTexUnit = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
        this.bound = false;
    }

    public PShader(PApplet parent) {
        this();
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = PGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    public PShader(PApplet parent, String vertFilename, String fragFilename) {
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = PGraphicsOpenGL.pgl;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = vertFilename;
        this.fragmentFilename = fragFilename;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
    }

    public PShader(PApplet parent, URL vertURL, URL fragURL) {
        this.parent = parent;
        this.pgMain = (PGraphicsOpenGL)parent.g;
        this.pgl = PGraphicsOpenGL.pgl;
        this.vertexURL = vertURL;
        this.fragmentURL = fragURL;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.glVertex != 0) {
                PGraphicsOpenGL.finalizeGLSLVertShaderObject(this.glVertex, this.context);
            }
            if (this.glFragment != 0) {
                PGraphicsOpenGL.finalizeGLSLFragShaderObject(this.glFragment, this.context);
            }
            if (this.glProgram != 0) {
                PGraphicsOpenGL.finalizeGLSLProgramObject(this.glProgram, this.context);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setVertexShader(String vertFilename) {
        this.vertexFilename = vertFilename;
    }

    public void setVertexShader(URL vertURL) {
        this.vertexURL = vertURL;
    }

    public void setFragmentShader(String fragFilename) {
        this.fragmentFilename = fragFilename;
    }

    public void setFragmentShader(URL fragURL) {
        this.fragmentURL = fragURL;
    }

    public void bind() {
        this.init();
        this.pgl.useProgram(this.glProgram);
        this.bound = true;
        this.consumeUniforms();
        this.bindTextures();
    }

    public void unbind() {
        this.unbindTextures();
        this.pgl.useProgram(0);
        this.bound = false;
    }

    public boolean bound() {
        return this.bound;
    }

    public void set(String name, int x) {
        this.setUniformImpl(name, 0, new int[]{x});
    }

    public void set(String name, int x, int y) {
        this.setUniformImpl(name, 1, new int[]{x, y});
    }

    public void set(String name, int x, int y, int z) {
        this.setUniformImpl(name, 2, new int[]{x, y, z});
    }

    public void set(String name, int x, int y, int z, int w) {
        this.setUniformImpl(name, 3, new int[]{x, y, z});
    }

    public void set(String name, float x) {
        this.setUniformImpl(name, 4, new float[]{x});
    }

    public void set(String name, float x, float y) {
        this.setUniformImpl(name, 5, new float[]{x, y});
    }

    public void set(String name, float x, float y, float z) {
        this.setUniformImpl(name, 6, new float[]{x, y, z});
    }

    public void set(String name, float x, float y, float z, float w) {
        this.setUniformImpl(name, 7, new float[]{x, y, z, w});
    }

    public void set(String name, PVector vec) {
        this.setUniformImpl(name, 6, new float[]{vec.x, vec.y, vec.z});
    }

    public void set(String name, int[] vec) {
        this.set(name, vec, 1);
    }

    public void set(String name, int[] vec, int ncoords) {
        if (ncoords == 1) {
            this.setUniformImpl(name, 8, vec);
        } else if (ncoords == 2) {
            this.setUniformImpl(name, 9, vec);
        } else if (ncoords == 3) {
            this.setUniformImpl(name, 10, vec);
        } else if (ncoords == 4) {
            this.setUniformImpl(name, 11, vec);
        } else if (4 < ncoords) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String name, float[] vec) {
        this.set(name, vec, 1);
    }

    public void set(String name, float[] vec, int ncoords) {
        if (ncoords == 1) {
            this.setUniformImpl(name, 12, vec);
        } else if (ncoords == 2) {
            this.setUniformImpl(name, 13, vec);
        } else if (ncoords == 3) {
            this.setUniformImpl(name, 14, vec);
        } else if (ncoords == 4) {
            this.setUniformImpl(name, 15, vec);
        } else if (4 < ncoords) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String name, PMatrix2D mat) {
        float[] matv = new float[]{mat.m00, mat.m01, mat.m10, mat.m11};
        this.setUniformImpl(name, 16, matv);
    }

    public void set(String name, PMatrix3D mat) {
        this.set(name, mat, false);
    }

    public void set(String name, PMatrix3D mat, boolean use3x3) {
        if (use3x3) {
            float[] matv = new float[]{mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22};
            this.setUniformImpl(name, 17, matv);
        } else {
            float[] matv = new float[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
            this.setUniformImpl(name, 18, matv);
        }
    }

    public void set(String name, PImage tex) {
        this.setUniformImpl(name, 19, tex);
    }

    protected int getAttributeLoc(String name) {
        this.init();
        return this.pgl.getAttribLocation(this.glProgram, name);
    }

    protected int getUniformLoc(String name) {
        this.init();
        return this.pgl.getUniformLocation(this.glProgram, name);
    }

    protected void setAttributeVBO(int loc, int vboId, int size, int type, boolean normalized, int stride, int offset) {
        if (-1 < loc) {
            this.pgl.bindBuffer(34962, vboId);
            this.pgl.vertexAttribPointer(loc, size, type, normalized, stride, offset);
        }
    }

    protected void setUniformValue(int loc, int x) {
        if (-1 < loc) {
            this.pgl.uniform1i(loc, x);
        }
    }

    protected void setUniformValue(int loc, int x, int y) {
        if (-1 < loc) {
            this.pgl.uniform2i(loc, x, y);
        }
    }

    protected void setUniformValue(int loc, int x, int y, int z) {
        if (-1 < loc) {
            this.pgl.uniform3i(loc, x, y, z);
        }
    }

    protected void setUniformValue(int loc, int x, int y, int z, int w) {
        if (-1 < loc) {
            this.pgl.uniform4i(loc, x, y, z, w);
        }
    }

    protected void setUniformValue(int loc, float x) {
        if (-1 < loc) {
            this.pgl.uniform1f(loc, x);
        }
    }

    protected void setUniformValue(int loc, float x, float y) {
        if (-1 < loc) {
            this.pgl.uniform2f(loc, x, y);
        }
    }

    protected void setUniformValue(int loc, float x, float y, float z) {
        if (-1 < loc) {
            this.pgl.uniform3f(loc, x, y, z);
        }
    }

    protected void setUniformValue(int loc, float x, float y, float z, float w) {
        if (-1 < loc) {
            this.pgl.uniform4f(loc, x, y, z, w);
        }
    }

    protected void setUniformVector(int loc, int[] vec, int ncoords, int length) {
        if (-1 < loc) {
            this.updateIntBuffer(vec);
            if (ncoords == 1) {
                this.pgl.uniform1iv(loc, length, this.intBuffer);
            } else if (ncoords == 2) {
                this.pgl.uniform2iv(loc, length, this.intBuffer);
            } else if (ncoords == 3) {
                this.pgl.uniform3iv(loc, length, this.intBuffer);
            } else if (ncoords == 4) {
                this.pgl.uniform3iv(loc, length, this.intBuffer);
            }
        }
    }

    protected void setUniformVector(int loc, float[] vec, int ncoords, int length) {
        if (-1 < loc) {
            this.updateFloatBuffer(vec);
            if (ncoords == 1) {
                this.pgl.uniform1fv(loc, length, this.floatBuffer);
            } else if (ncoords == 2) {
                this.pgl.uniform2fv(loc, length, this.floatBuffer);
            } else if (ncoords == 3) {
                this.pgl.uniform3fv(loc, length, this.floatBuffer);
            } else if (ncoords == 4) {
                this.pgl.uniform4fv(loc, length, this.floatBuffer);
            }
        }
    }

    protected void setUniformMatrix(int loc, float[] mat) {
        if (-1 < loc) {
            this.updateFloatBuffer(mat);
            if (mat.length == 4) {
                this.pgl.uniformMatrix2fv(loc, 1, false, this.floatBuffer);
            } else if (mat.length == 9) {
                this.pgl.uniformMatrix3fv(loc, 1, false, this.floatBuffer);
            } else if (mat.length == 16) {
                this.pgl.uniformMatrix4fv(loc, 1, false, this.floatBuffer);
            }
        }
    }

    protected void setUniformTex(int loc, Texture tex) {
        tex.bind();
    }

    protected void setUniformImpl(String name, int type, Object value) {
        int loc = this.getUniformLoc(name);
        if (-1 < loc) {
            if (this.uniformValues == null) {
                this.uniformValues = new HashMap();
            }
            this.uniformValues.put(loc, new UniformValue(type, value));
        } else {
            PGraphics.showWarning("The shader doesn't have a uniform called \"" + name + "\"");
        }
    }

    protected void consumeUniforms() {
        if (this.uniformValues != null && this.uniformValues.size() > 0) {
            this.lastTexUnit = this.firstTexUnit;
            for (Integer loc : this.uniformValues.keySet()) {
                Object[] v;
                UniformValue val = this.uniformValues.get(loc);
                if (val.type == 0) {
                    v = (int[])val.value;
                    this.pgl.uniform1i(loc, v[0]);
                    continue;
                }
                if (val.type == 1) {
                    v = (int[])val.value;
                    this.pgl.uniform2i(loc, v[0], v[1]);
                    continue;
                }
                if (val.type == 2) {
                    v = (int[])val.value;
                    this.pgl.uniform3i(loc, v[0], v[1], v[2]);
                    continue;
                }
                if (val.type == 3) {
                    v = (int[])val.value;
                    this.pgl.uniform4i(loc, v[0], v[1], v[2], v[4]);
                    continue;
                }
                if (val.type == 4) {
                    v = (float[])val.value;
                    this.pgl.uniform1f(loc, v[0]);
                    continue;
                }
                if (val.type == 5) {
                    v = (float[])val.value;
                    this.pgl.uniform2f(loc, v[0], v[1]);
                    continue;
                }
                if (val.type == 6) {
                    v = (float[])val.value;
                    this.pgl.uniform3f(loc, v[0], v[1], v[2]);
                    continue;
                }
                if (val.type == 7) {
                    v = (float[])val.value;
                    this.pgl.uniform4f(loc, v[0], v[1], v[2], v[3]);
                    continue;
                }
                if (val.type == 8) {
                    v = (int[])val.value;
                    this.updateIntBuffer((int[])v);
                    this.pgl.uniform1iv(loc, v.length, this.intBuffer);
                    continue;
                }
                if (val.type == 9) {
                    v = (int[])val.value;
                    this.updateIntBuffer((int[])v);
                    this.pgl.uniform2iv(loc, v.length / 2, this.intBuffer);
                    continue;
                }
                if (val.type == 10) {
                    v = (int[])val.value;
                    this.updateIntBuffer((int[])v);
                    this.pgl.uniform3iv(loc, v.length / 3, this.intBuffer);
                    continue;
                }
                if (val.type == 11) {
                    v = (int[])val.value;
                    this.updateIntBuffer((int[])v);
                    this.pgl.uniform4iv(loc, v.length / 4, this.intBuffer);
                    continue;
                }
                if (val.type == 12) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniform1fv(loc, v.length, this.floatBuffer);
                    continue;
                }
                if (val.type == 13) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniform2fv(loc, v.length / 2, this.floatBuffer);
                    continue;
                }
                if (val.type == 14) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniform3fv(loc, v.length / 3, this.floatBuffer);
                    continue;
                }
                if (val.type == 15) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniform4fv(loc, v.length / 4, this.floatBuffer);
                    continue;
                }
                if (val.type == 16) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniformMatrix2fv(loc, 1, false, this.floatBuffer);
                    continue;
                }
                if (val.type == 17) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniformMatrix3fv(loc, 1, false, this.floatBuffer);
                    continue;
                }
                if (val.type == 18) {
                    v = (float[])val.value;
                    this.updateFloatBuffer((float[])v);
                    this.pgl.uniformMatrix4fv(loc, 1, false, this.floatBuffer);
                    continue;
                }
                if (val.type != 19) continue;
                PImage img = (PImage)val.value;
                Texture tex = this.pgMain.getTexture(img);
                this.pgl.uniform1i(loc, this.lastTexUnit);
                if (this.textures == null) {
                    this.textures = new HashMap();
                }
                this.textures.put(this.lastTexUnit, tex);
                ++this.lastTexUnit;
            }
            this.uniformValues.clear();
        }
    }

    protected void updateIntBuffer(int[] vec) {
        this.intBuffer = PGL.updateIntBuffer(this.intBuffer, vec, false);
    }

    protected void updateFloatBuffer(float[] vec) {
        this.floatBuffer = PGL.updateFloatBuffer(this.floatBuffer, vec, false);
    }

    protected void bindTextures() {
        if (this.textures != null) {
            for (int unit : this.textures.keySet()) {
                Texture tex = this.textures.get(unit);
                this.pgl.activeTexture(33984 + unit);
                tex.bind();
            }
        }
    }

    protected void unbindTextures() {
        if (this.textures != null) {
            for (int unit : this.textures.keySet()) {
                Texture tex = this.textures.get(unit);
                this.pgl.activeTexture(33984 + unit);
                tex.unbind();
            }
            this.pgl.activeTexture(33984);
        }
    }

    protected void init() {
        if (this.glProgram == 0 || this.contextIsOutdated()) {
            this.context = this.pgl.getCurrentContext();
            this.glProgram = PGraphicsOpenGL.createGLSLProgramObject(this.context);
            boolean hasVert = false;
            if (this.vertexFilename != null) {
                hasVert = this.loadVertexShader(this.vertexFilename);
            } else if (this.vertexURL != null) {
                hasVert = this.loadVertexShader(this.vertexURL);
            } else {
                PGraphics.showException("Vertex shader filenames and URLs are both null!");
            }
            boolean hasFrag = false;
            if (this.fragmentFilename != null) {
                hasFrag = this.loadFragmentShader(this.fragmentFilename);
            } else if (this.fragmentURL != null) {
                hasFrag = this.loadFragmentShader(this.fragmentURL);
            } else {
                PGraphics.showException("Fragment shader filenames and URLs are both null!");
            }
            boolean vertRes = true;
            if (hasVert) {
                vertRes = this.compileVertexShader();
            }
            boolean fragRes = true;
            if (hasFrag) {
                fragRes = this.compileFragmentShader();
            }
            if (vertRes && fragRes) {
                boolean validated;
                boolean linked;
                if (hasVert) {
                    this.pgl.attachShader(this.glProgram, this.glVertex);
                }
                if (hasFrag) {
                    this.pgl.attachShader(this.glProgram, this.glFragment);
                }
                this.pgl.linkProgram(this.glProgram);
                this.pgl.getProgramiv(this.glProgram, 35714, this.intBuffer);
                boolean bl = linked = this.intBuffer.get(0) != 0;
                if (!linked) {
                    PGraphics.showException("Cannot link shader program:\n" + this.pgl.getProgramInfoLog(this.glProgram));
                }
                this.pgl.validateProgram(this.glProgram);
                this.pgl.getProgramiv(this.glProgram, 35715, this.intBuffer);
                boolean bl2 = validated = this.intBuffer.get(0) != 0;
                if (!validated) {
                    PGraphics.showException("Cannot validate shader program:\n" + this.pgl.getProgramInfoLog(this.glProgram));
                }
            }
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            PGraphicsOpenGL.removeGLSLProgramObject(this.glProgram, this.context);
            PGraphicsOpenGL.removeGLSLVertShaderObject(this.glVertex, this.context);
            PGraphicsOpenGL.removeGLSLFragShaderObject(this.glFragment, this.context);
            this.glProgram = 0;
            this.glVertex = 0;
            this.glFragment = 0;
        }
        return outdated;
    }

    protected boolean loadVertexShader(String filename) {
        this.vertexShaderSource = PApplet.join(this.parent.loadStrings(filename), "\n");
        return this.vertexShaderSource != null;
    }

    protected boolean loadVertexShader(URL url) {
        try {
            this.vertexShaderSource = PApplet.join(PApplet.loadStrings(url.openStream()), "\n");
            return this.vertexShaderSource != null;
        }
        catch (IOException e) {
            PGraphics.showException("Cannot load vertex shader " + url.getFile());
            return false;
        }
    }

    protected boolean loadFragmentShader(String filename) {
        this.fragmentShaderSource = PApplet.join(this.parent.loadStrings(filename), "\n");
        return this.fragmentShaderSource != null;
    }

    protected boolean loadFragmentShader(URL url) {
        try {
            this.fragmentShaderSource = PApplet.join(PApplet.loadStrings(url.openStream()), "\n");
            return this.fragmentShaderSource != null;
        }
        catch (IOException e) {
            PGraphics.showException("Cannot load fragment shader " + url.getFile());
            return false;
        }
    }

    protected boolean compileVertexShader() {
        boolean compiled;
        this.glVertex = PGraphicsOpenGL.createGLSLVertShaderObject(this.context);
        this.pgl.shaderSource(this.glVertex, this.vertexShaderSource);
        this.pgl.compileShader(this.glVertex);
        this.pgl.getShaderiv(this.glVertex, 35713, this.intBuffer);
        boolean bl = compiled = this.intBuffer.get(0) != 0;
        if (!compiled) {
            PGraphics.showException("Cannot compile vertex shader:\n" + this.pgl.getShaderInfoLog(this.glVertex));
            return false;
        }
        return true;
    }

    protected boolean compileFragmentShader() {
        boolean compiled;
        this.glFragment = PGraphicsOpenGL.createGLSLFragShaderObject(this.context);
        this.pgl.shaderSource(this.glFragment, this.fragmentShaderSource);
        this.pgl.compileShader(this.glFragment);
        this.pgl.getShaderiv(this.glFragment, 35713, this.intBuffer);
        boolean bl = compiled = this.intBuffer.get(0) != 0;
        if (!compiled) {
            PGraphics.showException("Cannot compile fragment shader:\n" + this.pgl.getShaderInfoLog(this.glFragment));
            return false;
        }
        return true;
    }

    protected void setRenderer(PGraphicsOpenGL pg) {
        this.pgCurrent = pg;
    }

    protected void loadAttributes() {
    }

    protected void loadUniforms() {
    }

    protected void dispose() {
        if (this.glVertex != 0) {
            PGraphicsOpenGL.deleteGLSLVertShaderObject(this.glVertex, this.context);
            this.glVertex = 0;
        }
        if (this.glFragment != 0) {
            PGraphicsOpenGL.deleteGLSLFragShaderObject(this.glFragment, this.context);
            this.glFragment = 0;
        }
        if (this.glProgram != 0) {
            PGraphicsOpenGL.deleteGLSLProgramObject(this.glProgram, this.context);
            this.glProgram = 0;
        }
    }

    protected class UniformValue {
        static final int INT1 = 0;
        static final int INT2 = 1;
        static final int INT3 = 2;
        static final int INT4 = 3;
        static final int FLOAT1 = 4;
        static final int FLOAT2 = 5;
        static final int FLOAT3 = 6;
        static final int FLOAT4 = 7;
        static final int INT1VEC = 8;
        static final int INT2VEC = 9;
        static final int INT3VEC = 10;
        static final int INT4VEC = 11;
        static final int FLOAT1VEC = 12;
        static final int FLOAT2VEC = 13;
        static final int FLOAT3VEC = 14;
        static final int FLOAT4VEC = 15;
        static final int MAT2 = 16;
        static final int MAT3 = 17;
        static final int MAT4 = 18;
        static final int SAMPLER2D = 19;
        int type;
        Object value;

        UniformValue(int type, Object value) {
            this.type = type;
            this.value = value;
        }
    }
}

