/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.ImageLineHelper;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngWriter;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;

public class PNGImage {
    private static final boolean DEBUG = Debug.debug("PNGImage");
    private final int pixelWidth;
    private final int pixelHeight;
    private final int glFormat;
    private final int bytesPerPixel;
    private final boolean reversedChannels;
    private final boolean isGLOriented;
    private final double[] dpi;
    private final ByteBuffer data;

    public static PNGImage createFromData(int n, int n2, double d, double d2, int n3, boolean bl, boolean bl2, ByteBuffer byteBuffer) {
        return new PNGImage(n, n2, d, d2, n3, bl, bl2, byteBuffer);
    }

    public static PNGImage read(InputStream inputStream) throws IOException {
        return new PNGImage(inputStream);
    }

    private static final int getPixelRGBA8(ByteBuffer byteBuffer, int n, int[] nArray, int n2, boolean bl) {
        if (bl) {
            byteBuffer.put(n--, (byte)nArray[n2 + 3]);
        }
        byteBuffer.put(n--, (byte)nArray[n2 + 2]);
        byteBuffer.put(n--, (byte)nArray[n2 + 1]);
        byteBuffer.put(n--, (byte)nArray[n2]);
        return n;
    }

    private int setPixelRGBA8(ImageLine imageLine, int n, ByteBuffer byteBuffer, int n2, boolean bl) {
        if (this.reversedChannels) {
            if (bl) {
                imageLine.scanline[n + 3] = byteBuffer.get(n2++);
            }
            imageLine.scanline[n + 2] = byteBuffer.get(n2++);
            imageLine.scanline[n + 1] = byteBuffer.get(n2++);
            imageLine.scanline[n] = byteBuffer.get(n2++);
        } else {
            imageLine.scanline[n] = byteBuffer.get(n2++);
            imageLine.scanline[n + 1] = byteBuffer.get(n2++);
            imageLine.scanline[n + 2] = byteBuffer.get(n2++);
            if (bl) {
                imageLine.scanline[n + 3] = byteBuffer.get(n2++);
            }
        }
        return this.isGLOriented ? n2 - this.bytesPerPixel - this.bytesPerPixel : n2;
    }

    private PNGImage(int n, int n2, double d, double d2, int n3, boolean bl, boolean bl2, ByteBuffer byteBuffer) {
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.dpi = new double[]{d, d2};
        if (4 == n3) {
            this.glFormat = 6408;
        } else if (3 == n3) {
            this.glFormat = 6407;
        } else {
            throw new InternalError("XXX: bytesPerPixel " + n3);
        }
        this.bytesPerPixel = n3;
        this.reversedChannels = bl;
        this.isGLOriented = bl2;
        this.data = byteBuffer;
    }

    private PNGImage(InputStream inputStream) {
        int n;
        boolean bl;
        PngReader pngReader = new PngReader(new BufferedInputStream(inputStream), null);
        ImageInfo imageInfo = pngReader.imgInfo;
        PngChunkPLTE pngChunkPLTE = pngReader.getMetadata().getPLTE();
        PngChunkTRNS pngChunkTRNS = pngReader.getMetadata().getTRNS();
        boolean bl2 = imageInfo.indexed;
        boolean bl3 = bl2 ? pngChunkTRNS != null : (bl = imageInfo.alpha);
        int n2 = bl2 ? (bl ? 4 : 3) : (n = imageInfo.channels);
        if (1 != n && 3 != n && 4 != n) {
            throw new RuntimeException("PNGImage can only handle Lum/RGB/RGBA [1/3/4 channels] images for now. Channels " + n + " Paletted: " + bl2);
        }
        int n3 = this.bytesPerPixel = bl2 ? n : imageInfo.bytesPixel;
        if (1 != this.bytesPerPixel && 3 != this.bytesPerPixel && 4 != this.bytesPerPixel) {
            throw new RuntimeException("PNGImage can only handle Lum/RGB/RGBA [1/3/4 bpp] images for now. BytesPerPixel " + this.bytesPerPixel);
        }
        if (n != this.bytesPerPixel) {
            throw new RuntimeException("PNGImage currently only handles Channels [1/3/4] == BytePerPixel [1/3/4], channels: " + n + ", bytesPerPixel " + this.bytesPerPixel);
        }
        this.pixelWidth = imageInfo.cols;
        this.pixelHeight = imageInfo.rows;
        this.dpi = new double[2];
        double[] dArray = pngReader.getMetadata().getDpi();
        this.dpi[0] = dArray[0];
        this.dpi[1] = dArray[1];
        if (bl2) {
            this.glFormat = bl ? 6408 : 6407;
        } else {
            switch (n) {
                case 1: {
                    this.glFormat = 6409;
                    break;
                }
                case 3: {
                    this.glFormat = 6407;
                    break;
                }
                case 4: {
                    this.glFormat = 6408;
                    break;
                }
                default: {
                    throw new InternalError("XXX: channels: " + n + ", bytesPerPixel " + this.bytesPerPixel);
                }
            }
        }
        if (DEBUG) {
            System.err.println("PNGImage: " + imageInfo);
            System.err.println("PNGImage: indexed " + bl2 + ", alpha " + bl + ", channels " + n + ", bytesPerPixel " + this.bytesPerPixel + ", pixels " + this.pixelWidth + "x" + this.pixelHeight + ", dpi " + this.dpi[0] + "x" + this.dpi[1] + ", glFormat 0x" + Integer.toHexString(this.glFormat));
        }
        this.data = Buffers.newDirectByteBuffer((int)(this.bytesPerPixel * this.pixelWidth * this.pixelHeight));
        this.reversedChannels = false;
        this.isGLOriented = true;
        int n4 = this.bytesPerPixel * this.pixelWidth * this.pixelHeight - 1;
        int[] nArray = bl2 ? new int[imageInfo.cols * n] : null;
        for (int i = 0; i < this.pixelHeight; ++i) {
            int n5;
            ImageLine imageLine = pngReader.readRow(i);
            int n6 = (this.pixelWidth - 1) * this.bytesPerPixel;
            if (bl2) {
                for (n5 = this.pixelWidth - 1; n5 >= 0; --n5) {
                    nArray = ImageLineHelper.palette2rgb(imageLine, pngChunkPLTE, pngChunkTRNS, nArray);
                    n4 = PNGImage.getPixelRGBA8(this.data, n4, nArray, n6, bl);
                    n6 -= this.bytesPerPixel;
                }
                continue;
            }
            if (1 == n) {
                for (n5 = this.pixelWidth - 1; n5 >= 0; --n5) {
                    this.data.put(n4--, (byte)imageLine.scanline[n6--]);
                }
                continue;
            }
            for (n5 = this.pixelWidth - 1; n5 >= 0; --n5) {
                n4 = PNGImage.getPixelRGBA8(this.data, n4, imageLine.scanline, n6, bl);
                n6 -= this.bytesPerPixel;
            }
        }
        pngReader.end();
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public boolean getHasReversedChannels() {
        return this.reversedChannels;
    }

    public boolean isGLOriented() {
        return this.isGLOriented;
    }

    public double[] getDpi() {
        return this.dpi;
    }

    public int getGLFormat() {
        return this.glFormat;
    }

    public int getGLType() {
        return 5121;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, boolean bl) throws IOException {
        ImageInfo imageInfo = new ImageInfo(this.pixelWidth, this.pixelHeight, 8, 4 == this.bytesPerPixel);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file, (boolean)bl));
        try {
            PngWriter pngWriter = new PngWriter(bufferedOutputStream, imageInfo);
            pngWriter.getMetadata().setDpi(this.dpi[0], this.dpi[1]);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGImage");
            boolean bl2 = 4 == this.bytesPerPixel;
            ImageLine imageLine = new ImageLine(imageInfo);
            if (this.isGLOriented) {
                int n = this.pixelWidth * this.bytesPerPixel * (this.pixelHeight - 1) + (this.pixelWidth - 1) * this.bytesPerPixel;
                for (int i = 0; i < this.pixelHeight; ++i) {
                    int n2;
                    int n3 = (this.pixelWidth - 1) * this.bytesPerPixel;
                    if (1 == this.bytesPerPixel) {
                        for (n2 = this.pixelWidth - 1; n2 >= 0; --n2) {
                            imageLine.scanline[n3--] = this.data.get(n--);
                        }
                    } else {
                        for (n2 = this.pixelWidth - 1; n2 >= 0; --n2) {
                            n = this.setPixelRGBA8(imageLine, n3, this.data, n, bl2);
                            n3 -= this.bytesPerPixel;
                        }
                    }
                    pngWriter.writeRow(imageLine, i);
                }
            } else {
                int n = 0;
                for (int i = 0; i < this.pixelHeight; ++i) {
                    int n4;
                    int n5 = 0;
                    if (1 == this.bytesPerPixel) {
                        for (n4 = this.pixelWidth - 1; n4 >= 0; --n4) {
                            imageLine.scanline[n5++] = this.data.get(n++);
                        }
                    } else {
                        for (n4 = this.pixelWidth - 1; n4 >= 0; --n4) {
                            n = this.setPixelRGBA8(imageLine, n5, this.data, n, bl2);
                            n5 += this.bytesPerPixel;
                        }
                    }
                    pngWriter.writeRow(imageLine, i);
                }
            }
            pngWriter.end();
        }
        finally {
            IOUtil.close((Closeable)bufferedOutputStream, (boolean)false);
        }
    }

    public String toString() {
        return "PNGImage[" + this.pixelWidth + "x" + this.pixelHeight + ", dpi " + this.dpi[0] + " x " + this.dpi[1] + ", bytesPerPixel " + this.bytesPerPixel + ", reversedChannels " + this.reversedChannels + ", " + this.data + "]";
    }
}

