/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferSizeTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;

public abstract class GLContextImpl
extends GLContext {
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private String glVendor;
    private String glRenderer;
    private String glRendererLowerCase;
    private String glVersion;
    private GLBufferSizeTracker bufferSizeTracker;
    private final GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private final GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    private final int[] boundFBOTarget = new int[]{0, 0};
    private int defaultVAO = 0;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();
    private Throwable lastCtxReleaseStack = null;
    private volatile boolean pixelDataTypeEvaluated = false;
    int pixelDataFormat;
    int pixelDataType;

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.synchronizeBufferObjectSharing(gLContext, this);
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    @Override
    protected void resetStates() {
        if (this.bufferSizeTracker != null) {
            this.bufferSizeTracker.clearCachedBufferSizes();
        }
        if (this.bufferStateTracker != null) {
            this.bufferStateTracker.clearBufferObjectState();
        }
        if (this.glStateTracker != null) {
            this.glStateTracker.clearStates(false);
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        this.glRendererLowerCase = this.glRenderer = (this.glVendor = "");
        this.glVersion = this.glVendor;
        if (this.boundFBOTarget != null) {
            this.boundFBOTarget[0] = 0;
            this.boundFBOTarget[1] = 0;
        }
        super.resetStates();
    }

    @Override
    public final GLDrawable setGLReadDrawable(GLDrawable gLDrawable) {
        if (!this.isGLReadDrawableAvailable()) {
            throw new GLException("Setting read drawable feature not available");
        }
        boolean bl = this.lock.isOwner(Thread.currentThread());
        if (bl) {
            this.release();
        } else if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread (" + this.lock.getOwner() + "), operation not allowed.");
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead;
        GLDrawableImpl gLDrawableImpl2 = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    @Override
    public final GLDrawable setGLDrawable(GLDrawable gLDrawable, boolean bl) {
        if (this.drawable == gLDrawable && (bl || this.drawableRead == gLDrawable)) {
            return this.drawable;
        }
        Thread thread = Thread.currentThread();
        if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread " + this.lock.getOwner().getName() + ", operation not allowed on this thread " + thread.getName());
        }
        boolean bl2 = this.lock.isOwner(thread);
        if (bl2 && this.lock.getHoldCount() > 1) {
            throw new GLException("GLContext is recursively locked - unsupported for setGLDrawable(..)");
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (this.isCreated() && null != gLDrawableImpl && gLDrawableImpl.isRealized()) {
            if (!bl2) {
                this.makeCurrent();
            }
            this.associateDrawable(false);
            if (!bl2) {
                this.release();
            }
        }
        if (bl2) {
            this.release();
        }
        if (!bl || this.drawableRead == this.drawable) {
            this.drawableRead = (GLDrawableImpl)gLDrawable;
        }
        this.drawableRetargeted |= null != this.drawable && gLDrawable != this.drawable;
        this.drawable = (GLDrawableImpl)gLDrawable;
        if (this.isCreated() && null != this.drawable && this.drawable.isRealized()) {
            this.makeCurrent(true);
            if (!bl2) {
                this.release();
            }
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            Exception exception = new Exception("Info: setGL (OpenGL " + this.getGLVersion() + "): " + GLContextImpl.getThreadName() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    public abstract Object getPlatformGLExtensions();

    @Override
    public void release() throws GLException {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) throws GLException {
        boolean bl2;
        Throwable throwable;
        block17: {
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.0]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + ", inDestruction: " + bl + ", " + this.lock);
            }
            if (!this.lock.isOwner(Thread.currentThread())) {
                String string = GLContextImpl.getThreadName() + ": Context not current on current thread, obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + ", inDestruction: " + bl + ", " + this.lock;
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(string);
                    if (null != this.lastCtxReleaseStack) {
                        System.err.print("Last release call: ");
                        this.lastCtxReleaseStack.printStackTrace();
                    } else {
                        System.err.println("Last release call: NONE");
                    }
                }
                throw new GLException(string);
            }
            throwable = null;
            bl2 = (bl || this.lock.getHoldCount() == 1) && 0L != this.contextHandle;
            try {
                if (bl2) {
                    if (!bl) {
                        try {
                            this.contextMadeCurrent(false);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    this.releaseImpl();
                }
                if (!bl2) break block17;
            }
            catch (Throwable throwable3) {
                if (bl2) {
                    GLContextImpl.setCurrent(null);
                }
                this.drawable.unlockSurface();
                this.lock.unlock();
                if (DEBUG_TRACE_SWITCH) {
                    String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - " + (bl2 ? "switch" : "keep  ") + " - " + this.lock;
                    this.lastCtxReleaseStack = new Throwable(string);
                    if (TRACE_SWITCH) {
                        System.err.println(string);
                    }
                }
                throw throwable3;
            }
            GLContextImpl.setCurrent(null);
        }
        this.drawable.unlockSurface();
        this.lock.unlock();
        if (DEBUG_TRACE_SWITCH) {
            String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - " + (bl2 ? "switch" : "keep  ") + " - " + this.lock;
            this.lastCtxReleaseStack = new Throwable(string);
            if (TRACE_SWITCH) {
                System.err.println(string);
            }
        }
        if (null != throwable) {
            throw new GLException("GLContext.release(false) during GLDrawableImpl.contextMadeCurrent(this, false)", throwable);
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        if (DEBUG_TRACE_SWITCH) {
            long l = null != this.drawable ? this.drawable.getHandle() : 0L;
            System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.0: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(l) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
        }
        if (0L != this.contextHandle) {
            if (null == this.drawable) {
                throw new GLException("GLContext created but drawable is null: " + this.toString());
            }
            int n = this.drawable.lockSurface();
            if (1 >= n) {
                throw new GLException("Surface not ready to lock: " + this.drawable);
            }
            Throwable throwable = null;
            try {
                Object object;
                if (!this.drawable.isRealized()) {
                    throw new GLException("GLContext created but drawable not realized: " + this.toString());
                }
                this.lock.lock();
                if (this.lock.getHoldCount() > 2) {
                    object = GLContextImpl.getThreadName() + ": GLContextImpl.destroy: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle);
                    if (DEBUG_TRACE_SWITCH) {
                        System.err.println((String)object + " - Lock was hold more than once - makeCurrent/release imbalance: " + this.lock);
                        Thread.dumpStack();
                    }
                }
                try {
                    if (this.lock.getHoldCount() == 1 && 0 == this.makeCurrent()) {
                        throw new GLException("GLContext.makeCurrent() failed: " + this.toString());
                    }
                    try {
                        this.associateDrawable(false);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (0 != this.defaultVAO) {
                        object = new int[]{this.defaultVAO};
                        this.gl.getGL2GL3().glBindVertexArray(0);
                        this.gl.getGL2GL3().glDeleteVertexArrays(1, (int[])object, 0);
                        this.defaultVAO = 0;
                    }
                    this.glDebugHandler.enable(false);
                    if (this.lock.getHoldCount() > 1) {
                        this.release(true);
                    }
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharedLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                }
                finally {
                    this.lock.unlock();
                    if (DEBUG_TRACE_SWITCH) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.X: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
                    }
                }
            }
            finally {
                this.drawable.unlockSurface();
            }
            if (null != throwable) {
                throw new GLException("GLContext.destroy() during associateDrawable(false)", throwable);
            }
        }
        this.resetStates();
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 >= n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    @Override
    public final int makeCurrent() throws GLException {
        return this.makeCurrent(false);
    }

    protected final int makeCurrent(boolean bl) throws GLException {
        int n;
        block29: {
            int n2;
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.0]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - " + this.lock);
            }
            if (1 >= (n2 = this.drawable.lockSurface())) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X1]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - Surface Not Ready - CONTEXT_NOT_CURRENT - " + this.lock);
                }
                return 0;
            }
            boolean bl2 = true;
            n = 0;
            try {
                if (!this.drawable.isRealized()) break block29;
                if (0L == this.drawable.getHandle()) {
                    throw new GLException("drawable has invalid handle: " + this.drawable);
                }
                this.lock.lock();
                try {
                    GLContext gLContext = GLContextImpl.getCurrent();
                    if (gLContext != null) {
                        if (gLContext == this) {
                            this.drawableUpdatedNotify();
                            bl2 = false;
                            if (TRACE_SWITCH) {
                                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X2]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - keep   - CONTEXT_CURRENT - " + this.lock);
                            }
                            int n3 = 1;
                            return n3;
                        }
                        gLContext.release();
                    }
                    bl2 = 0 == (n = this.makeCurrentWithinLock(n2));
                }
                catch (RuntimeException runtimeException) {
                    bl2 = true;
                    throw runtimeException;
                }
                finally {
                    if (bl2) {
                        if (DEBUG_TRACE_SWITCH) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.1]: Context lock.unlock() due to error, res " + GLContextImpl.makeCurrentResultToString(n) + ", " + this.lock);
                        }
                        this.lock.unlock();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                bl2 = true;
                throw runtimeException;
            }
            finally {
                if (bl2) {
                    this.drawable.unlockSurface();
                }
            }
        }
        if (n != 0) {
            GLContextImpl.setCurrent(this);
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
                this.glDebugHandler.init(this.isGL2GL3() && this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
                bl = true;
            }
            if (bl) {
                this.associateDrawable(true);
            }
            this.contextMadeCurrent(true);
        }
        if (TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X3]: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - switch - " + GLContextImpl.makeCurrentResultToString(n) + " - " + this.lock);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int makeCurrentWithinLock(int n) throws GLException {
        if (!this.isCreated()) {
            Object object;
            boolean bl;
            GLContextImpl gLContextImpl;
            if (0 >= this.drawable.getWidth() || 0 >= this.drawable.getHeight()) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context REJECTED (zero surface size) obj " + GLContextImpl.toHexString(this.hashCode()) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " for " + this.getClass().getName());
                    System.err.println(this.drawable.toString());
                }
                return 0;
            }
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x20;
            }
            if (null != (gLContextImpl = (GLContextImpl)GLContextShareSet.getShareContext(this))) {
                gLContextImpl.getDrawableImpl().lockSurface();
            }
            try {
                bl = this.createImpl(gLContextImpl);
                if (bl && this.isGL3core()) {
                    object = new int[1];
                    this.gl.getGL2GL3().glGenVertexArrays(1, (int[])object, 0);
                    this.defaultVAO = (int)object[0];
                    this.gl.getGL2GL3().glBindVertexArray(this.defaultVAO);
                }
            }
            finally {
                if (null != gLContextImpl) {
                    gLContextImpl.getDrawableImpl().unlockSurface();
                }
            }
            if (DEBUG_TRACE_SWITCH) {
                if (bl) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context OK: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " for " + this.getClass().getName() + " - " + this.getGLVersion());
                } else {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context FAILED obj " + GLContextImpl.toHexString(this.hashCode()) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " for " + this.getClass().getName());
                }
            }
            if (!bl) {
                return 0;
            }
            object = this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = object.getScreen().getDevice();
            if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && 0 == (this.ctxOptions & 8)) {
                int n2 = this.ctxVersion.compareTo(Version30) <= 0 ? 2 : this.ctxVersion.getMajor();
                int n3 = 0 != (this.ctxOptions & 4) ? 4 : 2;
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n2, n3, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextOLD-MapVersionsAvailable HAVE: " + abstractGraphicsDevice + " -> " + n2 + "." + n3 + " -> " + this.getGLVersion());
                }
            }
            GLContextShareSet.contextCreated(this);
            return 2;
        }
        this.makeCurrentImpl();
        return 1;
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected void associateDrawable(boolean bl) {
        this.drawable.associateContext(this, bl);
    }

    protected void contextMadeCurrent(boolean bl) {
        this.drawable.contextMadeCurrent(this, bl);
    }

    protected abstract boolean createImpl(GLContextImpl var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && !this.mapGLVersions(abstractGraphicsDevice)) {
            return 0L;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        int[] nArray = new int[]{0, 0};
        GLContextImpl.getRequestMajorAndCompat(gLCapabilitiesImmutable.getGLProfile(), nArray);
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, nArray[0], nArray[1], nArray2, nArray3, nArray4)) {
            nArray4[0] = nArray4[0] | this.additionalCtxCreationFlags;
            l2 = this.createContextARBImpl(l, bl, nArray4[0], nArray2[0], nArray3[0]);
            if (0L != l2) {
                this.setGLFunctionAvailability(true, nArray2[0], nArray3[0], nArray4[0], false);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashMap<String, Integer> hashMap = GLContext.deviceVersionAvailable;
        synchronized (hashMap) {
            long l = DEBUG ? System.nanoTime() : 0L;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl5) {
                bl5 = this.createContextARBMapVersionsAvailable(4, 4);
                bl |= bl5;
                if (bl5) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    if (PROFILE_ALIASING) {
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl6) {
                bl6 = this.createContextARBMapVersionsAvailable(3, 4);
                bl |= bl6;
                if (bl6) {
                    this.resetStates();
                }
            }
            if (!bl2) {
                bl2 = this.createContextARBMapVersionsAvailable(4, 2);
                bl |= bl2;
                if (bl2) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    if (!bl5) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    }
                    if (!bl6) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    }
                    if (PROFILE_ALIASING) {
                        bl3 = true;
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl3) {
                bl3 = this.createContextARBMapVersionsAvailable(3, 2);
                bl |= bl3;
                if (bl3) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    if (!bl6) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    }
                    if (PROFILE_ALIASING) {
                        bl4 = true;
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl4) {
                bl4 = this.createContextARBMapVersionsAvailable(2, 2);
                bl |= bl4;
                if (bl4) {
                    this.resetStates();
                }
            }
            if (bl) {
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    long l2 = System.nanoTime();
                    System.err.println("GLContextImpl.mapGLVersions: " + abstractGraphicsDevice + ", profileAliasing: " + PROFILE_ALIASING + ", total " + (double)(l2 - l) / 1000000.0 + "ms");
                    System.err.println(GLContext.dumpAvailableGLVersions(null).toString());
                }
            } else if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersions NONE for :" + abstractGraphicsDevice);
            }
            return bl;
        }
    }

    private final boolean createContextARBMapVersionsAvailable(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        n7 = 2 == n2 ? (n7 |= 2) : (n7 |= 4);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n6 = 4;
            n5 = GLContext.getMaxMinor(n6);
            n4 = 4;
            n3 = 0;
        } else if (3 == n) {
            n6 = 3;
            n5 = GLContext.getMaxMinor(n6);
            n4 = 3;
            n3 = 1;
        } else {
            n6 = 3;
            n5 = 0;
            n4 = 2;
            n3 = 0;
        }
        long l = this.createContextARBVersions(0L, true, n7, n6, n5, n4, n3, nArray, nArray2);
        if (0L == l && 4 == n2 && !PROFILE_ALIASING) {
            n7 &= 0xFFFFFFFB;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n6, n5, n4, n3, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 2, n6, n5, n4, n3, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
            this.destroyContextARBImpl(l);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable HAVE: " + n + "." + n2 + " -> " + this.getGLVersion());
            }
            bl = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable NOPE: " + n + "." + n2);
            }
            bl = false;
        }
        return bl;
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        while (GLContext.isValidGLVersion(nArray[0], nArray2[0]) && (nArray[0] > n4 || nArray[0] == n4 && nArray2[0] >= n5)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0]);
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0]))) {
                if (this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n, true)) break;
                this.destroyContextARBImpl(l2);
                l2 = 0L;
            }
            if (GLContext.decrementGLVersion(nArray, nArray2)) continue;
            break;
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3, VersionNumberString versionNumberString, boolean bl) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        if (!GLContext.isValidGLVersion(n, n2)) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        this.ctxVersion = new VersionNumber(n, n2, 0);
        this.ctxVersionString = GLContextImpl.getGLVersion(n, n2, this.ctxOptions, this.glVersion);
        this.ctxVendorVersion = versionNumberString;
        this.ctxOptions = n3;
        if (bl) {
            Object object;
            this.ctxGLSLVersion = null;
            if (n >= 2 && null != (object = this.gl.glGetString(35724))) {
                this.ctxGLSLVersion = new VersionNumber((String)object, ".");
                if (this.ctxGLSLVersion.getMajor() < 1) {
                    this.ctxGLSLVersion = null;
                }
            }
            if (null == this.ctxGLSLVersion) {
                object = new int[2];
                GLContextImpl.getStaticGLSLVersionNumber(n, n2, this.ctxOptions, (int[])object);
                this.ctxGLSLVersion = new VersionNumber((int)object[0], (int)object[1], 0);
            }
        }
    }

    private Object createInstance(GLProfile gLProfile, String string, Class<?>[] classArray, Object[] objectArray) {
        return ReflectionUtil.createInstance((String)(gLProfile.getGLImplBaseClassName() + string), (Class[])classArray, (Object[])objectArray, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public void bindPbufferToTexture() {
        throw new GLException("not implemented");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("not implemented");
    }

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    protected final void resetProcAddressTable(ProcAddressTable procAddressTable) {
        procAddressTable.reset((DynamicLookupHelper)this.getDrawableImpl().getGLDynamicLookupHelper());
    }

    private final boolean initGLRendererAndGLVersionStrings() {
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetString");
        if (0L == l) {
            System.err.println("Error: Entry point to 'glGetString' is NULL.");
            if (DEBUG) {
                Thread.dumpStack();
            }
            return false;
        }
        String string = GLContextImpl.glGetStringInt(7936, l);
        if (null == string) {
            if (DEBUG) {
                System.err.println("Warning: GL_VENDOR is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glVendor = string;
        String string2 = GLContextImpl.glGetStringInt(7937, l);
        if (null == string2) {
            if (DEBUG) {
                System.err.println("Warning: GL_RENDERER is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glRenderer = string2;
        this.glRendererLowerCase = this.glRenderer.toLowerCase();
        String string3 = GLContextImpl.glGetStringInt(7938, l);
        if (null == string3) {
            if (DEBUG) {
                System.err.println("Warning: GL_VERSION is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glVersion = string3;
        return true;
    }

    private static void limitNonARBContextVersion(int[] nArray, int[] nArray2, int n) {
        if (0 == (n & 1) && (nArray[0] > 3 || nArray[0] == 3 && nArray2[0] >= 1)) {
            nArray[0] = 3;
            nArray2[0] = 0;
        }
    }

    private static final VersionNumber getGLVersionNumber(int n, String string) {
        GLVersionNumber gLVersionNumber;
        if (null != string && (gLVersionNumber = GLVersionNumber.create(string)).isValid()) {
            int[] nArray = new int[]{gLVersionNumber.getMajor()};
            int[] nArray2 = new int[]{gLVersionNumber.getMinor()};
            GLContextImpl.limitNonARBContextVersion(nArray, nArray2, n);
            if (GLContext.isValidGLVersion(nArray[0], nArray2[0])) {
                return new VersionNumber(nArray[0], nArray2[0], 0);
            }
        }
        return null;
    }

    private final boolean getGLIntVersion(int[] nArray, int[] nArray2, int n) {
        nArray[0] = 0;
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetIntegerv");
        if (0L == l) {
            System.err.println("Error: Entry point to 'glGetIntegerv' is NULL.");
            if (DEBUG) {
                Thread.dumpStack();
            }
            return false;
        }
        GLContextImpl.glGetIntegervInt(33307, nArray, 0, l);
        GLContextImpl.glGetIntegervInt(33308, nArray2, 0, l);
        GLContextImpl.limitNonARBContextVersion(nArray, nArray2, n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setGLFunctionAvailability(boolean bl, int n, int n2, int n3, boolean bl2) {
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return true;
        }
        if (0 < n && !GLContext.isValidGLVersion(n, n2)) {
            throw new GLException("Invalid GL Version Request " + GLContext.getGLVersion(n, n2, n3, null));
        }
        if (null == this.gl || !this.verifyInstance(this.gl.getGLProfile(), "Impl", this.gl)) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        boolean bl3 = this.initGLRendererAndGLVersionStrings();
        if (!bl3) {
            String string = "Intialization of GL renderer strings failed. " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, null);
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Warning: setGLFunctionAvailability: " + string);
                }
                return false;
            }
            throw new GLException(string);
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Given " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion));
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Pre version verification - expected " + GLContext.getGLVersion(n, n2, n3, null) + ", strictMatch " + bl2);
        }
        bl3 = false;
        boolean bl4 = false;
        Object object = new int[]{0};
        Object object2 = new int[]{0};
        boolean bl5 = this.getGLIntVersion((int[])object, (int[])object2, n3);
        if (!bl5) {
            String string = "Fetching GL Integer Version failed. " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, null);
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Warning: setGLFunctionAvailability: " + string);
                }
                return false;
            }
            throw new GLException(string);
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: version verification (Int): " + this.glVersion + ", " + object[0] + "." + object2[0]);
        }
        if (GLContext.isValidGLVersion(object[0], object2[0])) {
            if (object[0] < n || object[0] == n && object2[0] < n2 || 0 == n) {
                if (bl2 && 2 < n) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (Int): " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + object[0] + "." + object2[0]);
                    }
                    return false;
                }
                n = object[0];
                n2 = object2[0];
            }
            bl3 = true;
        } else {
            bl4 = true;
        }
        if (!bl3) {
            object = new VersionNumber(n, n2, 0);
            object2 = GLContextImpl.getGLVersionNumber(n3, this.glVersion);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: version verification (String): " + this.glVersion + ", " + object2);
            }
            if (null != object2) {
                if (object2.compareTo((VersionNumber)object) < 0 || 0 == n) {
                    if (bl2 && 2 < n) {
                        if (DEBUG) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (String): " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + object2);
                        }
                        return false;
                    }
                    n = object2.getMajor();
                    n2 = object2.getMinor();
                }
                if (bl2 && bl4 && n >= 3) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL3 version Int failed, String: " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + object2);
                    }
                    return false;
                }
                bl3 = true;
            }
        }
        if (bl2 && !bl3 && 0 < n) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, No GL version validation possible: " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion);
            }
            return false;
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: post version verification " + GLContext.getGLVersion(n, n2, n3, null) + ", strictMatch " + bl2 + ", versionValidated " + bl3 + ", versionGL3IntFailed " + bl4);
        }
        if (2 > n) {
            n3 &= 0xFFFFFEFF;
        }
        object = GLVersionNumber.createVendorVersion(this.glVersion);
        this.setRendererQuirks(abstractGraphicsDevice, n, n2, n3, (VersionNumberString)object);
        if (bl2 && this.glRendererQuirks.exist(6)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL is not compliant: " + GLContext.getGLVersion(n, n2, n3, this.glVersion) + ", " + this.glRenderer);
            }
            return false;
        }
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.0 validated FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion));
        }
        object2 = null;
        Object object3 = mappedContextTypeObjectLock;
        synchronized (object3) {
            object2 = mappedGLProcAddress.get(this.contextFQN);
            if (null != object2 && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", object2)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null) + ") -> " + object2.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != object2) {
            this.glProcAddressTable = (ProcAddressTable)object2;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object2.hashCode()));
            }
        } else {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[]{FunctionAddressResolver.class}, new Object[]{new GLProcAddressResolver()});
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object3 = mappedContextTypeObjectLock;
            synchronized (object3) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.getGLProcAddressTable().hashCode()));
                }
            }
        }
        Object object4 = mappedContextTypeObjectLock;
        synchronized (object4) {
            object3 = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object3) {
            this.extensionAvailability = object3;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object3.hashCode()) + " - entries: " + ((ExtensionAvailabilityCache)object3).getTotalExtensionCount());
            }
        } else {
            this.extensionAvailability = new ExtensionAvailabilityCache();
            this.setContextVersion(n, n2, n3, (VersionNumberString)object, false);
            this.extensionAvailability.reset(this);
            object4 = mappedContextTypeObjectLock;
            synchronized (object4) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.extensionAvailability.hashCode()) + " - entries: " + this.extensionAvailability.getTotalExtensionCount());
                }
            }
        }
        if (0 != (8 & n3) && n >= 2 || this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
            n3 |= 0x100;
            n3 |= 0x200;
        } else if (GLContextImpl.hasFBOImpl(n, n3, this.extensionAvailability)) {
            n3 |= 0x200;
        }
        if (FORCE_NO_FBO_SUPPORT) {
            n3 &= 0xFFFFFDFF;
        }
        this.setContextVersion(n, n2, n3, (VersionNumberString)object, true);
        this.setDefaultSwapInterval();
        int n4 = this.gl.glGetError();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: OK " + this.contextFQN + " - " + GLContext.getGLVersion(this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions, null) + " - glErr " + GLContextImpl.toHexString(n4));
        }
        return true;
    }

    private final void setRendererQuirks(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3, VersionNumberString versionNumberString) {
        boolean bl;
        int[] nArray = new int[11];
        int n4 = 0;
        boolean bl2 = 0 == (n3 & 0x8000);
        boolean bl3 = 0 != (n3 & 2);
        boolean bl4 = this.glRenderer.contains("Mesa ") || this.glRenderer.contains("Gallium ");
        boolean bl5 = !bl4 && (this.glVendor.contains("ATI Technologies") || this.glRenderer.startsWith("ATI "));
        boolean bl6 = bl = !bl4 && (this.glVendor.contains("NVIDIA Corporation") || this.glRenderer.contains("NVIDIA "));
        if (Platform.getOSType() == Platform.OSType.MACOS) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(3) + ": cause: OS " + Platform.getOSType());
            }
            nArray[n4++] = 3;
            VersionNumber versionNumber = new VersionNumber(1, 7, 3);
            if (Platform.getOSVersionNumber().compareTo(versionNumber) < 0 && bl) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(7) + ": cause: OS " + Platform.getOSType() + ", OS Version " + Platform.getOSVersionNumber() + ", Renderer " + this.glRenderer);
                }
                nArray[n4++] = 7;
            }
        } else if (Platform.getOSType() == Platform.OSType.WINDOWS) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(1) + ": cause: OS " + Platform.getOSType());
            }
            nArray[n4++] = 1;
            if (bl5) {
                VersionNumber versionNumber = new VersionNumber(5, 1, 0);
                VersionNumber versionNumber2 = new VersionNumber(12, 102, 3);
                if (versionNumberString.compareTo(versionNumber2) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(10) + ": cause: OS " + Platform.getOSType() + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "], driverVersion " + versionNumberString);
                    }
                    nArray[n4++] = 10;
                }
                if (Platform.getOSVersionNumber().compareTo(versionNumber) <= 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(9) + ": cause: OS-Version " + Platform.getOSType() + " " + Platform.getOSVersionNumber() + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "]");
                    }
                    nArray[n4++] = 9;
                }
            }
        } else if (Platform.OSType.ANDROID == Platform.getOSType() && this.glRenderer.contains("PowerVR")) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(2) + ": cause: OS " + Platform.getOSType() + " / Renderer " + this.glRenderer);
            }
            nArray[n4++] = 2;
        }
        if (bl4) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(4) + ": cause: Renderer " + this.glRenderer);
            }
            nArray[n4++] = 4;
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(0) + ": cause: Renderer " + this.glRenderer);
                }
                nArray[n4++] = 0;
            }
            if (this.glRenderer.contains("Intel(R)") && bl3 && (n > 3 || n == 3 && n2 >= 1)) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(6) + ": cause: Renderer " + this.glRenderer);
                }
                nArray[n4++] = 6;
            }
        }
        if (NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
            if (this.glRenderer.contains("Mesa ")) {
                if (this.glRenderer.contains("X11") && versionNumberString.compareTo(Version80) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer + ", Version=[vendor " + versionNumberString + ", GL " + this.glVersion + "]");
                    }
                    nArray[n4++] = 8;
                }
            } else if (bl5) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer);
                }
                nArray[n4++] = 8;
            } else if (X11Util.getMarkAllDisplaysUnclosable()) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11Util Downstream");
                }
                nArray[n4++] = 8;
            }
        }
        this.glRendererQuirks = new GLRendererQuirks(nArray, 0, n4);
    }

    private static final boolean hasFBOImpl(int n, int n2, ExtensionAvailabilityCache extensionAvailabilityCache) {
        return 0 != (n2 & 8) && n >= 2 || n >= 3 || null != extensionAvailabilityCache && extensionAvailabilityCache.isExtensionAvailable("GL_ARB_ES2_compatibility") || extensionAvailabilityCache.isExtensionAvailable("GL_ARB_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_EXT_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_OES_framebuffer_object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeCachedVersion(int n, int n2, int n3) {
        int n4;
        Object object;
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": RM Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null));
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                n4 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n4));
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.remove(this.contextFQN);
            if (DEBUG) {
                n4 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n4));
            }
        }
    }

    private final boolean isCurrentContextHardwareRasterizer() {
        boolean bl = true;
        bl = !this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? false : !this.glRendererLowerCase.contains("software") && !this.glRendererLowerCase.contains("mesa x11") && !this.glRendererLowerCase.contains("softpipe") && !this.glRendererLowerCase.contains("llvmpipe");
        return bl;
    }

    protected abstract void updateGLXProcAddressTable();

    protected abstract StringBuilder getPlatformExtensionsStringImpl();

    @Override
    public final boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable;
        if (null != this.glProcAddressTable) {
            try {
                if (0L != this.glProcAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLNameResolver.normalizeVEN(GLNameResolver.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLNameResolver.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLNameResolver.getFuncNamePermutation(string2, i);
            try {
                l = gLDynamicLookupHelper.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final int getPlatformExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getPlatformExtensionCount() : 0;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final int getGLExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getGLExtensionCount() : 0;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.composeBits(n, n2, n3 &= 0xFFFFFCFF));
    }

    protected final String getContextFQN() {
        return this.contextFQN;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultPixelDataType() {
        if (!this.pixelDataTypeEvaluated) {
            GLContextImpl gLContextImpl = this;
            synchronized (gLContextImpl) {
                if (!this.pixelDataTypeEvaluated) {
                    this.evalPixelDataType();
                    this.pixelDataTypeEvaluated = true;
                }
            }
        }
        return this.pixelDataType;
    }

    private final void evalPixelDataType() {
        if (this.isGLES2Compatible() || this.isExtensionAvailable("GL_OES_read_format")) {
            int[] nArray = new int[]{0, 0};
            this.gl.glGetIntegerv(35739, nArray, 0);
            this.gl.glGetIntegerv(35738, nArray, 1);
            this.pixelDataFormat = nArray[0];
            this.pixelDataType = nArray[1];
        } else {
            this.pixelDataFormat = 6408;
            this.pixelDataType = 5121;
        }
    }

    public final void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public final GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public final GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public final GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public final boolean isDefaultVAO(int n) {
        return this.defaultVAO == n;
    }

    public final boolean isOwner(Thread thread) {
        return this.lock.isOwner(thread);
    }

    public final boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    public final int getLockCount() {
        return this.lock.getHoldCount();
    }

    public final void setBoundFramebuffer(int n, int n2) {
        if (0 > n2) {
            return;
        }
        switch (n) {
            case 36160: {
                this.boundFBOTarget[0] = n2;
                this.boundFBOTarget[1] = n2;
                break;
            }
            case 36009: {
                this.boundFBOTarget[0] = n2;
                break;
            }
            case 36008: {
                this.boundFBOTarget[1] = n2;
                break;
            }
        }
    }

    @Override
    public final int getBoundFramebuffer(int n) {
        switch (n) {
            case 36009: 
            case 36160: {
                return this.boundFBOTarget[0];
            }
            case 36008: {
                return this.boundFBOTarget[1];
            }
        }
        throw new InternalError("Invalid FBO target name: " + GLContextImpl.toHexString(n));
    }

    @Override
    public final int getDefaultDrawFramebuffer() {
        return this.drawable.getDefaultDrawFramebuffer();
    }

    @Override
    public final int getDefaultReadFramebuffer() {
        return this.drawable.getDefaultReadFramebuffer();
    }

    @Override
    public final int getDefaultReadBuffer() {
        return this.drawable.getDefaultReadBuffer(this.gl);
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n & 0x20;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x20) : (this.additionalCtxCreationFlags &= 0xFFFFFFDF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x20) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, nArray, n5, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, nArray, n5, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6 = n5 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageInsertARB(n, n2, n3, n4, n5, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n4, n3, n5, string);
        }
    }

    protected static native String glGetStringInt(int var0, long var1);

    protected static native void glGetIntegervInt(int var0, int[] var1, int var2, long var3);
}

