/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLExtImpl;
import jogamp.opengl.windows.wgl.WGLExtProcAddressTable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;

public class WindowsWGLContext
extends GLContextImpl {
    static final Map<String, String> functionNameMap = new HashMap<String, String>();
    static final Map<String, String> extensionNameMap;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private boolean wglGLReadDrawableAvailableSet;
    private boolean wglGLReadDrawableAvailable;
    private WGLExt _wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;
    private int hasSwapIntervalSGI = 0;
    private int hasSwapGroupNV = 0;

    WindowsWGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates() {
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglGLReadDrawableAvailableSet = false;
        this.wglGLReadDrawableAvailable = false;
        this.wglExtProcAddressTable = null;
        this.hasSwapIntervalSGI = 0;
        this.hasSwapGroupNV = 0;
        super.resetStates();
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    final WGLExt getWGLExt() {
        if (null == this.getWGLExtProcAddressTable()) {
            throw new InternalError("Null WGLExtProcAddressTable");
        }
        if (this._wglExt == null) {
            this._wglExt = new WGLExtImpl(this);
        }
        return this._wglExt;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        if (!this.wglGLReadDrawableAvailableSet && null != this.getWGLExtProcAddressTable()) {
            WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            switch (windowsWGLDrawableFactory.isReadDrawableAvailable(abstractGraphicsDevice)) {
                case 1: {
                    this.wglGLReadDrawableAvailable = true;
                    this.wglGLReadDrawableAvailableSet = true;
                    break;
                }
                case 0: {
                    this.wglGLReadDrawableAvailable = false;
                    this.wglGLReadDrawableAvailableSet = true;
                }
            }
        }
        return this.wglGLReadDrawableAvailable;
    }

    private final boolean wglMakeContextCurrent(long l, long l2, long l3) {
        int n;
        boolean bl = false;
        if (this.wglGLReadDrawableAvailable) {
            bl = this.getWGLExt().wglMakeContextCurrent(l, l2, l3);
        } else if (l == l2) {
            bl = WGL.wglMakeCurrent(l, l3);
        } else {
            throw new InternalError("Given readDrawable but no driver support");
        }
        int n2 = n = !bl ? GDI.GetLastError() : 0;
        if (DEBUG && !bl) {
            Throwable throwable = new Throwable("Info: wglMakeContextCurrent draw " + GLContext.toHexString(l) + ", read " + GLContext.toHexString(l2) + ", ctx " + GLContext.toHexString(l3) + ", werr " + n);
            throwable.printStackTrace();
        }
        if (!bl && 0L == l && 0L == l2) {
            return n == 0;
        }
        return bl;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getWGLExtProcAddressTable();
    }

    public final WGLExtProcAddressTable getWGLExtProcAddressTable() {
        return this.wglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return functionNameMap;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return extensionNameMap;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        WGL.wglMakeCurrent(0L, 0L);
        WGL.wglDeleteContext(l);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        block15: {
            if (null == this.getWGLExtProcAddressTable()) {
                this.updateGLXProcAddressTable();
            }
            WGLExt wGLExt = this.getWGLExt();
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + " - WindowWGLContext.createContextARBImpl: " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", share " + WindowsWGLContext.toHexString(l) + ", direct " + bl + ", wglCreateContextAttribsARB: " + WindowsWGLContext.toHexString(this.wglExtProcAddressTable._addressof_wglCreateContextAttribsARB));
            }
            boolean bl2 = 0 != (2 & n);
            boolean bl3 = 0 != (0x10 & n);
            boolean bl4 = 0 != (0x20 & n);
            l2 = 0L;
            int[] nArray = new int[]{8337, n2, 8338, n3, 8340, 0, 0, 0, 0};
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                nArray[6] = 37158;
                nArray[7] = bl2 ? 2 : 1;
            }
            if (n2 >= 3) {
                if (!bl2 && bl3) {
                    nArray[5] = nArray[5] | 2;
                }
                if (bl4) {
                    nArray[5] = nArray[5] | 1;
                }
            }
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])nArray);
                l2 = wGLExt.wglCreateContextAttribsARB(this.drawable.getHandle(), l, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block15;
                Throwable throwable = new Throwable("Info: WindowWGLContext.createContextARBImpl wglCreateContextAttribsARB failed with " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"), runtimeException);
                throwable.printStackTrace();
            }
        }
        if (0L != l2) {
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                if (DEBUG) {
                    System.err.println("WindowsWGLContext.createContextARB couldn't make current " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: OK " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: NO " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l2;
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) {
        long l;
        long l2;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
        WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsWGLDrawableFactory.getOrCreateSharedContext(abstractGraphicsDevice);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = this.drawable.getChosenGLCapabilities();
        this.isGLReadDrawableAvailable();
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: START " + gLCapabilitiesImmutable + ", share " + gLContextImpl);
        }
        if (null != gLContextImpl) {
            l2 = gLContextImpl.getHandle();
            if (l2 == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
        } else {
            l2 = 0L;
        }
        boolean bl = false;
        if (null != windowsWGLContext && windowsWGLContext.isCreatedWithARBMethod() && !gLCapabilitiesImmutable.isBitmap()) {
            if (windowsWGLContext.getRendererQuirks().exist(10)) {
                if (0 == windowsWGLContext.makeCurrent()) {
                    throw new GLException("Could not make Shared Context current: " + windowsWGLContext);
                }
                this.contextHandle = this.createContextARB(l2, true);
                windowsWGLContext.release();
                if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
                }
            } else {
                this.contextHandle = this.createContextARB(l2, true);
            }
            bl = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (ARB, using sharedContext) share " + l2);
            }
        }
        if (0L == this.contextHandle) {
            l = WGL.wglCreateContext(this.drawable.getHandle());
            if (0L == l) {
                throw new GLException("Unable to create temp OpenGL context for device context " + WindowsWGLContext.toHexString(this.drawable.getHandle()));
            }
            if (!WGL.wglMakeCurrent(this.drawable.getHandle(), l)) {
                throw new GLException("Error making temp context current: 0x" + WindowsWGLContext.toHexString(l) + ", werr: " + GDI.GetLastError());
            }
            this.setGLFunctionAvailability(true, 0, 0, 2, false);
            WGL.wglMakeCurrent(0L, 0L);
            if (!bl) {
                boolean bl2;
                boolean bl3;
                if (!gLCapabilitiesImmutable.isBitmap()) {
                    bl3 = this.isFunctionAvailable("wglCreateContextAttribsARB");
                    bl2 = this.isExtensionAvailable("WGL_ARB_create_context");
                } else {
                    bl3 = false;
                    bl2 = false;
                }
                if (bl3 && bl2) {
                    this.contextHandle = this.createContextARB(l2, true);
                    bl = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: OK (ARB, initial) share " + l2);
                        } else {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - creation failed - share " + l2);
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - extension not available - share " + l2 + ", isProcCreateContextAttribsARBAvailable " + bl3 + ", isExtGLXARBCreateContextAvailable " + bl2);
                }
            }
        } else {
            l = 0L;
        }
        if (0L != this.contextHandle) {
            l2 = 0L;
            if (0L != l) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l);
                if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
                }
            }
        } else {
            if (gLCapabilitiesImmutable.getGLProfile().isGL3()) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l);
                throw new GLException(WindowsWGLContext.getThreadName() + ": WindowsWGLContex.createContextImpl ctx !ARB, profile > GL2 requested (OpenGL >= 3.0.1). Requested: " + gLCapabilitiesImmutable.getGLProfile() + ", current: " + this.getGLVersion());
            }
            if (DEBUG) {
                System.err.println("WindowsWGLContext.createContext failed, fall back to !ARB context " + this.getGLVersion());
            }
            this.contextHandle = l;
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(this.contextHandle);
                throw new GLException("Error making old context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
            }
            if (0L != l2 && !WGL.wglShareLists(l2, this.contextHandle)) {
                throw new GLException("wglShareLists(" + WindowsWGLContext.toHexString(l2) + ", " + WindowsWGLContext.toHexString(this.contextHandle) + ") failed: werr " + GDI.GetLastError());
            }
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (old) share " + l2);
            }
        }
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (WGL.wglGetCurrentContext() != this.contextHandle && !this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + WindowsWGLContext.toHexString(this.contextHandle) + " current on Thread " + WindowsWGLContext.getThreadName() + ", drawableWrite " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + WindowsWGLContext.toHexString(this.drawableRead.getHandle()) + ", werr: " + GDI.GetLastError() + ", " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.wglMakeContextCurrent(0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context, werr: " + GDI.GetLastError());
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        WGL.wglMakeCurrent(0L, 0L);
        if (!WGL.wglDeleteContext(this.contextHandle)) {
            throw new GLException("Unable to delete OpenGL context");
        }
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (!WGL.wglCopyContext(gLContext.getHandle(), this.getHandle(), n)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "WGL-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": Initializing WGL extension address table: " + string);
        }
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglGLReadDrawableAvailableSet = false;
        this.wglGLReadDrawableAvailable = false;
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.wglExtProcAddressTable = (WGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": GLContext WGL ProcAddressTable reusing key(" + string + ") -> " + WindowsWGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.wglExtProcAddressTable = new WGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.wglExtProcAddressTable);
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getWGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": GLContext WGL ProcAddressTable mapping key(" + string + ") -> " + WindowsWGLContext.toHexString(((Object)((Object)this.getWGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            stringBuilder.append(this.getWGLExt().wglGetExtensionsStringEXT());
        }
        return stringBuilder;
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        WGLExt wGLExt = this.getWGLExt();
        if (0 == this.hasSwapIntervalSGI) {
            try {
                this.hasSwapIntervalSGI = wGLExt.isExtensionAvailable("WGL_EXT_swap_control") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapIntervalSGI = 1;
            }
        }
        if (this.hasSwapIntervalSGI > 0) {
            try {
                return wGLExt.wglSwapIntervalEXT(n);
            }
            catch (Throwable throwable) {
                this.hasSwapIntervalSGI = -1;
            }
        }
        return false;
    }

    private final int initSwapGroupImpl(WGLExt wGLExt) {
        if (0 == this.hasSwapGroupNV) {
            try {
                this.hasSwapGroupNV = wGLExt.isExtensionAvailable("WGL_NV_swap_group") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = 1;
            }
            if (DEBUG) {
                System.err.println("initSwapGroupImpl: hasSwapGroupNV: " + this.hasSwapGroupNV);
            }
        }
        return this.hasSwapGroupNV;
    }

    @Override
    protected final boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)(nArray.length - n));
                IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)(nArray2.length - n2));
                if (wGLExt.wglQueryMaxSwapGroupsNV(nativeSurface.getDisplayHandle(), intBuffer, intBuffer2)) {
                    intBuffer.get(nArray, n, intBuffer.remaining());
                    intBuffer2.get(nArray, n, intBuffer2.remaining());
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean joinSwapGroupImpl(int n) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            try {
                if (wGLExt.wglJoinSwapGroupNV(this.drawable.getHandle(), n)) {
                    this.currentSwapGroup = n;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean bindSwapBarrierImpl(int n, int n2) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            try {
                if (wGLExt.wglBindSwapBarrierNV(n, n2)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getWGLExt().wglAllocateMemoryNV(n, f, f2, f3);
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap<String, String>();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

