/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.Sort;

public class IntDict {
    protected int count;
    protected String[] keys;
    protected int[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public IntDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new int[10];
    }

    public IntDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new int[length];
    }

    public IntDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = PApplet.parseInt(pieces[1]);
                ++this.count;
            }
            ++i;
        }
    }

    public IntDict(String[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        int i = 0;
        while (i < this.count) {
            this.indices.put(keys[i], i);
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public String key(int index) {
        return this.keys[index];
    }

    private void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public String[] keys() {
        this.crop();
        return this.keys;
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
            }

            @Override
            public String next() {
                return IntDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public int value(int index) {
        return this.values[index];
    }

    public Iterable<Integer> values() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        IntDict.this.removeIndex(this.index);
                    }

                    @Override
                    public Integer next() {
                        return IntDict.this.value(++this.index);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < IntDict.this.size();
                    }
                };
            }
        };
    }

    public int[] valueArray() {
        return this.valueArray(null);
    }

    public int[] valueArray(int[] array) {
        if (array == null || array.length != this.size()) {
            array = new int[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public int get(String key) {
        int index = this.index(key);
        if (index == -1) {
            return 0;
        }
        return this.values[index];
    }

    public void set(String key, int amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    public void increment(String key) {
        this.add(key, 1);
    }

    public void add(String key, int amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + amount;
        }
    }

    public void sub(String key, int amount) {
        this.add(key, -amount);
    }

    public void mult(String key, int amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] * amount;
        }
    }

    public void div(String key, int amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] / amount;
        }
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, int much) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(what, new Integer(this.count));
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public void remove(String key) {
        this.removeIndex(this.index(key));
    }

    public void removeIndex(int index) {
        this.indices.remove(this.keys[index]);
        int i = index;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0;
    }

    protected void swap(int a, int b) {
        String tkey = this.keys[a];
        int tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return IntDict.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int diff = 0;
                if (useKeys) {
                    diff = IntDict.this.keys[a].compareToIgnoreCase(IntDict.this.keys[b]);
                    if (diff == 0) {
                        return IntDict.this.values[a] - IntDict.this.values[b];
                    }
                } else {
                    diff = IntDict.this.values[a] - IntDict.this.values[b];
                    if (diff == 0) {
                        diff = IntDict.this.keys[a].compareToIgnoreCase(IntDict.this.keys[b]);
                    }
                }
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                IntDict.this.swap(a, b);
            }
        };
        s.run();
    }

    public IntDict copy() {
        IntDict outgoing = new IntDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        int i = 0;
        while (i < this.count) {
            outgoing.indices.put(this.keys[i], i);
            ++i;
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " { ");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"" + this.keys[i] + "\": " + this.values[i]);
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }
}

