/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.nio.IntBuffer;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class FrameBuffer
implements PConstants {
    protected PGL pgl = PGraphicsOpenGL.pgl;
    protected int context = this.pgl.createEmptyContext();
    public int glFbo;
    public int glDepth;
    public int glStencil;
    public int glDepthStencil;
    public int glMultisample;
    public int width;
    public int height;
    protected int depthBits;
    protected int stencilBits;
    protected boolean packedDepthStencil;
    protected boolean multisample;
    protected int nsamples;
    protected int numColorBuffers;
    protected Texture[] colorBufferTex;
    protected boolean screenFb;
    protected boolean noDepth;
    protected IntBuffer pixelBuffer;

    FrameBuffer() {
    }

    FrameBuffer(int w, int h, int samples, int colorBuffers, int depthBits, int stencilBits, boolean packedDepthStencil, boolean screen) {
        this();
        this.glFbo = 0;
        this.glDepth = 0;
        this.glStencil = 0;
        this.glDepthStencil = 0;
        this.glMultisample = 0;
        if (screen) {
            colorBuffers = 0;
            samples = 0;
            stencilBits = 0;
            depthBits = 0;
        }
        this.width = w;
        this.height = h;
        if (1 < samples) {
            this.multisample = true;
            this.nsamples = samples;
        } else {
            this.multisample = false;
            this.nsamples = 1;
        }
        this.numColorBuffers = colorBuffers;
        this.colorBufferTex = new Texture[this.numColorBuffers];
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = null;
            ++i;
        }
        if (depthBits < 1 && stencilBits < 1) {
            this.depthBits = 0;
            this.stencilBits = 0;
            this.packedDepthStencil = false;
        } else if (packedDepthStencil) {
            this.depthBits = 24;
            this.stencilBits = 8;
            this.packedDepthStencil = true;
        } else {
            this.depthBits = depthBits;
            this.stencilBits = stencilBits;
            this.packedDepthStencil = false;
        }
        this.screenFb = screen;
        this.allocate();
        this.noDepth = false;
        this.pixelBuffer = null;
    }

    FrameBuffer(int w, int h) {
        this(w, h, 1, 1, 0, 0, false, false);
    }

    FrameBuffer(int w, int h, boolean screen) {
        this(w, h, 1, 1, 0, 0, false, screen);
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.screenFb) {
                if (this.glFbo != 0) {
                    PGraphicsOpenGL.finalizeFrameBufferObject(this.glFbo, this.context);
                }
                if (this.glDepth != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepth, this.context);
                }
                if (this.glStencil != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glStencil, this.context);
                }
                if (this.glMultisample != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glMultisample, this.context);
                }
                if (this.glDepthStencil != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepthStencil, this.context);
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.pgl.clear(17664);
        PGraphicsOpenGL.popFramebuffer();
    }

    public void copy(FrameBuffer dest, FrameBuffer current) {
        this.pgl.bindFramebuffer(36008, this.glFbo);
        this.pgl.bindFramebuffer(36009, dest.glFbo);
        this.pgl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, dest.width, dest.height, 16384, 9728);
        this.pgl.bindFramebuffer(36008, current.glFbo);
        this.pgl.bindFramebuffer(36009, current.glFbo);
    }

    public void bind() {
        this.pgl.bindFramebuffer(36160, this.glFbo);
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish(PGraphicsOpenGL pg) {
        if (this.noDepth) {
            if (pg.getHint(-2)) {
                this.pgl.enable(2929);
            } else {
                this.pgl.disable(2929);
            }
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.pixelBuffer.rewind();
        this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
    }

    public void getPixels(int[] pixels) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(pixels, 0, pixels.length);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public boolean hasDepthBuffer() {
        return this.depthBits > 0;
    }

    public boolean hasStencilBuffer() {
        return this.stencilBits > 0;
    }

    public void setFBO(int id) {
        if (this.screenFb) {
            this.glFbo = id;
        }
    }

    public void setColorBuffer(Texture tex) {
        this.setColorBuffers(new Texture[]{tex}, 1);
    }

    public void setColorBuffers(Texture[] textures) {
        this.setColorBuffers(textures, textures.length);
    }

    public void setColorBuffers(Texture[] textures, int n) {
        if (this.screenFb) {
            return;
        }
        if (this.numColorBuffers != PApplet.min(n, textures.length)) {
            throw new RuntimeException("Wrong number of textures to set the color buffers.");
        }
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = textures[i];
            ++i;
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, 3553, 0, 0);
            ++i;
        }
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        PGraphicsOpenGL.popFramebuffer();
    }

    public void swapColorBuffers() {
        int i = 0;
        while (i < this.numColorBuffers - 1) {
            int i1 = i + 1;
            Texture tmp = this.colorBufferTex[i];
            this.colorBufferTex[i] = this.colorBufferTex[i1];
            this.colorBufferTex[i1] = tmp;
            ++i;
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        PGraphicsOpenGL.popFramebuffer();
    }

    public int getDefaultReadBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultReadBuffer();
        }
        return 36064;
    }

    public int getDefaultDrawBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultDrawBuffer();
        }
        return 36064;
    }

    protected void allocate() {
        this.dispose();
        this.context = this.pgl.getCurrentContext();
        if (this.screenFb) {
            this.glFbo = 0;
        } else {
            this.glFbo = PGraphicsOpenGL.createFrameBufferObject(this.context);
            if (this.multisample) {
                this.createColorBufferMultisample();
            }
            if (this.packedDepthStencil) {
                this.createPackedDepthStencilBuffer();
            } else {
                if (this.depthBits > 0) {
                    this.createDepthBuffer();
                }
                if (this.stencilBits > 0) {
                    this.createStencilBuffer();
                }
            }
        }
    }

    protected void dispose() {
        if (this.screenFb) {
            return;
        }
        if (this.glFbo != 0) {
            PGraphicsOpenGL.finalizeFrameBufferObject(this.glFbo, this.context);
            this.glFbo = 0;
        }
        if (this.glDepth != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepth, this.context);
            this.glDepth = 0;
        }
        if (this.glStencil != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glStencil, this.context);
            this.glStencil = 0;
        }
        if (this.glMultisample != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glMultisample, this.context);
            this.glMultisample = 0;
        }
        if (this.glDepthStencil != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepthStencil, this.context);
            this.glDepthStencil = 0;
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        if (this.screenFb) {
            return false;
        }
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            PGraphicsOpenGL.removeFrameBufferObject(this.glFbo, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glDepth, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glStencil, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glDepthStencil, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glMultisample, this.context);
            this.glFbo = 0;
            this.glDepth = 0;
            this.glStencil = 0;
            this.glDepthStencil = 0;
            this.glMultisample = 0;
            int i = 0;
            while (i < this.numColorBuffers) {
                this.colorBufferTex[i] = null;
                ++i;
            }
        }
        return outdated;
    }

    protected void createColorBufferMultisample() {
        if (this.screenFb) {
            return;
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        this.glMultisample = PGraphicsOpenGL.createRenderBufferObject(this.context);
        this.pgl.bindRenderbuffer(36161, this.glMultisample);
        this.pgl.renderbufferStorageMultisample(36161, this.nsamples, 32856, this.width, this.height);
        this.pgl.framebufferRenderbuffer(36160, 36064, 36161, this.glMultisample);
        PGraphicsOpenGL.popFramebuffer();
    }

    protected void createPackedDepthStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        this.glDepthStencil = PGraphicsOpenGL.createRenderBufferObject(this.context);
        this.pgl.bindRenderbuffer(36161, this.glDepthStencil);
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, 35056, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, 35056, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36096, 36161, this.glDepthStencil);
        this.pgl.framebufferRenderbuffer(36160, 36128, 36161, this.glDepthStencil);
        PGraphicsOpenGL.popFramebuffer();
    }

    protected void createDepthBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        this.glDepth = PGraphicsOpenGL.createRenderBufferObject(this.context);
        this.pgl.bindRenderbuffer(36161, this.glDepth);
        int glConst = 33189;
        if (this.depthBits == 16) {
            glConst = 33189;
        } else if (this.depthBits == 24) {
            glConst = 33190;
        } else if (this.depthBits == 32) {
            glConst = 33191;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36096, 36161, this.glDepth);
        PGraphicsOpenGL.popFramebuffer();
    }

    protected void createStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        PGraphicsOpenGL.pushFramebuffer();
        PGraphicsOpenGL.setFramebuffer(this);
        this.glStencil = PGraphicsOpenGL.createRenderBufferObject(this.context);
        this.pgl.bindRenderbuffer(36161, this.glStencil);
        int glConst = 36166;
        if (this.stencilBits == 1) {
            glConst = 36166;
        } else if (this.stencilBits == 4) {
            glConst = 36167;
        } else if (this.stencilBits == 8) {
            glConst = 36168;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36128, 36161, this.glStencil);
        PGraphicsOpenGL.popFramebuffer();
    }

    protected void createPixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }
}

