/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FBObject;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class PGL {
    public static final boolean USE_JOGL_FBOLAYER = false;
    public static boolean FORCE_SCREEN_FBO = false;
    public static final boolean USE_DIRECT_BUFFERS = true;
    public static final int MIN_DIRECT_BUFFER_SIZE = 1;
    public static final boolean SAVE_SURFACE_TO_PIXELS = true;
    protected static final boolean MIPMAPS_ENABLED = true;
    protected static final int DEFAULT_IN_VERTICES = 64;
    protected static final int DEFAULT_IN_EDGES = 128;
    protected static final int DEFAULT_IN_TEXTURES = 64;
    protected static final int DEFAULT_TESS_VERTICES = 64;
    protected static final int DEFAULT_TESS_INDICES = 128;
    protected static final int MAX_LIGHTS = 8;
    protected static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static final int MAX_VERTEX_INDEX1 = 32768;
    protected static final int FLUSH_VERTEX_COUNT = 32768;
    protected static final int MAX_FONT_TEX_SIZE = 1024;
    protected static final float MIN_CAPS_JOINS_WEIGHT = 2.0f;
    protected static final int MAX_CAPS_JOINS_LENGTH = 5000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final int AWT = 0;
    protected static final int NEWT = 1;
    protected static int toolkit;
    protected static int events;
    protected static int request_depth_bits;
    protected static int request_stencil_bits;
    protected static int request_alpha_bits;
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;
    protected static final int SIZEOF_BYTE = 1;
    protected static final int SIZEOF_INDEX = 2;
    protected static final int INDEX_TYPE = 5123;
    protected static final String FRAMEBUFFER_ERROR_MESSAGE = "Framebuffer error (%1$s), rendering will probably not work as expected";
    protected static float FLOAT_EPS;
    protected static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int LESS = 513;
    public static final int LEQUAL = 515;
    public static final int CCW = 2305;
    public static final int CW = 2304;
    public static final int CULL_FACE = 2884;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    public static final int FRONT_AND_BACK = 1032;
    public static final int VIEWPORT = 2978;
    public static final int SCISSOR_TEST = 3089;
    public static final int DEPTH_TEST = 2929;
    public static final int DEPTH_WRITEMASK = 2930;
    public static final int COLOR_BUFFER_BIT = 16384;
    public static final int DEPTH_BUFFER_BIT = 256;
    public static final int STENCIL_BUFFER_BIT = 1024;
    public static final int FUNC_ADD = 32774;
    public static final int FUNC_MIN = 32775;
    public static final int FUNC_MAX = 32776;
    public static final int FUNC_REVERSE_SUBTRACT = 32779;
    public static final int TEXTURE_2D = 3553;
    public static final int TEXTURE_RECTANGLE = 34037;
    public static final int TEXTURE_BINDING_2D = 32873;
    public static final int TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int RGB = 6407;
    public static final int RGBA = 6408;
    public static final int ALPHA = 6406;
    public static final int UNSIGNED_INT = 5125;
    public static final int UNSIGNED_BYTE = 5121;
    public static final int UNSIGNED_SHORT = 5123;
    public static final int FLOAT = 5126;
    public static final int NEAREST = 9728;
    public static final int LINEAR = 9729;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int TEXTURE_MAX_ANISOTROPY = 34046;
    public static final int MAX_TEXTURE_MAX_ANISOTROPY = 34047;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int RGBA8 = 32856;
    public static final int DEPTH24_STENCIL8 = 35056;
    public static final int DEPTH_COMPONENT = 6402;
    public static final int DEPTH_COMPONENT16 = 33189;
    public static final int DEPTH_COMPONENT24 = 33190;
    public static final int DEPTH_COMPONENT32 = 33191;
    public static final int STENCIL_INDEX = 6401;
    public static final int STENCIL_INDEX1 = 36166;
    public static final int STENCIL_INDEX4 = 36167;
    public static final int STENCIL_INDEX8 = 36168;
    public static final int ARRAY_BUFFER = 34962;
    public static final int ELEMENT_ARRAY_BUFFER = 34963;
    public static final int SAMPLES = 32937;
    public static final int FRAMEBUFFER_COMPLETE = 36053;
    public static final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int STATIC_DRAW = 35044;
    public static final int DYNAMIC_DRAW = 35048;
    public static final int STREAM_DRAW = 35040;
    public static final int READ_ONLY = 35000;
    public static final int WRITE_ONLY = 35001;
    public static final int READ_WRITE = 35002;
    public static final int TRIANGLE_FAN = 6;
    public static final int TRIANGLE_STRIP = 5;
    public static final int TRIANGLES = 4;
    public static final int VENDOR = 7936;
    public static final int RENDERER = 7937;
    public static final int VERSION = 7938;
    public static final int EXTENSIONS = 7939;
    public static final int SHADING_LANGUAGE_VERSION = 35724;
    public static final int MAX_TEXTURE_SIZE = 3379;
    public static final int MAX_SAMPLES = 36183;
    public static final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int DEPTH_BITS = 3414;
    public static final int STENCIL_BITS = 3415;
    public static final int TESS_WINDING_NONZERO = 100131;
    public static final int TESS_WINDING_ODD = 100130;
    public static final int TEXTURE0 = 33984;
    public static final int TEXTURE1 = 33985;
    public static final int TEXTURE2 = 33986;
    public static final int TEXTURE3 = 33987;
    public static final int TEXTURE_MIN_FILTER = 10241;
    public static final int TEXTURE_MAG_FILTER = 10240;
    public static final int TEXTURE_WRAP_S = 10242;
    public static final int TEXTURE_WRAP_T = 10243;
    public static final int BLEND = 3042;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int SRC_ALPHA = 770;
    public static final int DST_ALPHA = 772;
    public static final int ONE_MINUS_SRC_ALPHA = 771;
    public static final int ONE_MINUS_DST_COLOR = 775;
    public static final int ONE_MINUS_SRC_COLOR = 769;
    public static final int DST_COLOR = 774;
    public static final int SRC_COLOR = 768;
    public static final int FRAMEBUFFER = 36160;
    public static final int COLOR_ATTACHMENT0 = 36064;
    public static final int COLOR_ATTACHMENT1 = 36065;
    public static final int COLOR_ATTACHMENT2 = 36066;
    public static final int COLOR_ATTACHMENT3 = 36067;
    public static final int RENDERBUFFER = 36161;
    public static final int DEPTH_ATTACHMENT = 36096;
    public static final int STENCIL_ATTACHMENT = 36128;
    public static final int READ_FRAMEBUFFER = 36008;
    public static final int DRAW_FRAMEBUFFER = 36009;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    public static final int INFO_LOG_LENGTH = 35716;
    public static final int SHADER_SOURCE_LENGTH = 35720;
    public static final int COMPILE_STATUS = 35713;
    public static final int LINK_STATUS = 35714;
    public static final int VALIDATE_STATUS = 35715;
    public static final int MULTISAMPLE = 32925;
    public static final int POINT_SMOOTH = 2832;
    public static final int LINE_SMOOTH = 2848;
    public static final int POLYGON_SMOOTH = 2881;
    public static GL gl;
    public static GLU glu;
    public static GLContext context;
    public static Canvas canvas;
    public static GLProfile profile;
    protected static Thread glThread;
    protected PGraphicsOpenGL pg;
    protected static GLCapabilitiesImmutable capabilities;
    protected static GLDrawable drawable;
    protected static GL2ES2 gl2;
    protected static GL2 gl2x;
    protected static GLCanvas canvasAWT;
    protected static NewtCanvasAWT canvasNEWT;
    protected static GLWindow window;
    protected static PGLListener listener;
    protected float targetFps = 60.0f;
    protected float currentFps = 60.0f;
    protected boolean setFps = false;
    protected int fcount;
    protected int lastm;
    protected int fint = 3;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    protected static boolean fboLayerByDefault;
    protected static boolean fboLayerCreated;
    protected static boolean fboLayerInUse;
    protected static boolean firstFrame;
    protected static int reqNumSamples;
    protected static int numSamples;
    protected static IntBuffer glColorFbo;
    protected static IntBuffer glMultiFbo;
    protected static IntBuffer glColorBuf;
    protected static IntBuffer glColorTex;
    protected static IntBuffer glDepthStencil;
    protected static IntBuffer glDepth;
    protected static IntBuffer glStencil;
    protected static int fboWidth;
    protected static int fboHeight;
    protected static int backTex;
    protected static int frontTex;
    protected static FBObject backFBO;
    protected static FBObject sinkFBO;
    protected static FBObject frontFBO;
    protected static FBObject.TextureAttachment backTexAttach;
    protected static FBObject.TextureAttachment frontTexAttach;
    protected static boolean loadedTex2DShader;
    protected static int tex2DShaderProgram;
    protected static int tex2DVertShader;
    protected static int tex2DFragShader;
    protected static GLContext tex2DShaderContext;
    protected static int tex2DVertLoc;
    protected static int tex2DTCoordLoc;
    protected static boolean loadedTexRectShader;
    protected static int texRectShaderProgram;
    protected static int texRectVertShader;
    protected static int texRectFragShader;
    protected static GLContext texRectShaderContext;
    protected static int texRectVertLoc;
    protected static int texRectTCoordLoc;
    protected static float[] texCoords;
    protected static FloatBuffer texData;
    protected static String texVertShaderSource;
    protected static String tex2DFragShaderSource;
    protected static String texRectFragShaderSource;
    protected ByteBuffer byteBuffer;
    protected IntBuffer intBuffer;
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;
    protected float[] projMatrix;
    protected float[] mvMatrix;

    public PGL() {
    }

    public PGL(PGraphicsOpenGL pg) {
        this.pg = pg;
        if (glu == null) {
            glu = new GLU();
        }
        if (glColorTex == null) {
            glColorTex = PGL.allocateIntBuffer(2);
            glColorFbo = PGL.allocateIntBuffer(1);
            glMultiFbo = PGL.allocateIntBuffer(1);
            glColorBuf = PGL.allocateIntBuffer(1);
            glDepthStencil = PGL.allocateIntBuffer(1);
            glDepth = PGL.allocateIntBuffer(1);
            glStencil = PGL.allocateIntBuffer(1);
            fboLayerCreated = false;
            fboLayerInUse = false;
            firstFrame = false;
        }
        this.byteBuffer = PGL.allocateByteBuffer(1);
        this.intBuffer = PGL.allocateIntBuffer(1);
    }

    protected void setFps(float fps) {
        if (!this.setFps || this.targetFps != fps) {
            if (60.0f < fps) {
                gl.setSwapInterval(0);
            } else if (30.0f < fps) {
                gl.setSwapInterval(1);
            } else {
                gl.setSwapInterval(2);
            }
            this.targetFps = this.currentFps = fps;
            this.setFps = true;
        }
    }

    protected void initSurface(int antialias) {
        if (profile == null) {
            profile = GLProfile.getDefault();
        } else {
            if (canvasAWT != null) {
                canvasAWT.removeGLEventListener((GLEventListener)listener);
                this.pg.parent.removeListeners((Component)canvasAWT);
                this.pg.parent.remove((Component)canvasAWT);
            } else if (canvasNEWT != null) {
                window.removeGLEventListener((GLEventListener)listener);
                this.pg.parent.remove((Component)canvasNEWT);
            }
            frontFBO = null;
            backFBO = null;
            sinkFBO = null;
        }
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        caps.setSampleBuffers(false);
        reqNumSamples = this.qualityToSamples(antialias);
        caps.setDepthBits(request_depth_bits);
        caps.setStencilBits(request_stencil_bits);
        caps.setAlphaBits(request_alpha_bits);
        if (toolkit == 0) {
            canvasAWT = new GLCanvas((GLCapabilitiesImmutable)caps);
            canvasAWT.setBounds(0, 0, this.pg.width, this.pg.height);
            canvasAWT.setBackground(new Color(this.pg.backgroundColor, true));
            canvasAWT.setFocusable(true);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)canvasAWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners((Component)canvasAWT);
            canvas = canvasAWT;
            canvasNEWT = null;
            listener = new PGLListener();
            canvasAWT.addGLEventListener((GLEventListener)listener);
        } else if (toolkit == 1) {
            window = GLWindow.create((GLCapabilitiesImmutable)caps);
            canvasNEWT = new NewtCanvasAWT((Window)window);
            canvasNEWT.setBounds(0, 0, this.pg.width, this.pg.height);
            canvasNEWT.setBackground(new Color(this.pg.backgroundColor, true));
            canvasNEWT.setFocusable(true);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)canvasNEWT, "Center");
            if (events == 1) {
                NEWTMouseListener mouseListener = new NEWTMouseListener();
                window.addMouseListener((MouseListener)mouseListener);
                NEWTKeyListener keyListener = new NEWTKeyListener();
                window.addKeyListener((KeyListener)keyListener);
                NEWTWindowListener winListener = new NEWTWindowListener();
                window.addWindowListener((WindowListener)winListener);
                canvasNEWT.addFocusListener((FocusListener)this.pg.parent);
            } else if (events == 0) {
                this.pg.parent.removeListeners((Component)canvasNEWT);
                this.pg.parent.addListeners((Component)canvasNEWT);
            }
            canvas = canvasNEWT;
            canvasAWT = null;
            listener = new PGLListener();
            window.addGLEventListener((GLEventListener)listener);
        }
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = true;
        this.setFps = false;
    }

    protected void deleteSurface() {
        if (this.threadIsCurrent() && fboLayerCreated) {
            this.deleteTextures(2, glColorTex);
            this.deleteFramebuffers(1, glColorFbo);
            this.deleteFramebuffers(1, glMultiFbo);
            this.deleteRenderbuffers(1, glColorBuf);
            this.deleteRenderbuffers(1, glDepthStencil);
            this.deleteRenderbuffers(1, glDepth);
            this.deleteRenderbuffers(1, glStencil);
        }
        if (canvasAWT != null) {
            canvasAWT.removeGLEventListener((GLEventListener)listener);
            this.pg.parent.removeListeners((Component)canvasAWT);
        } else if (canvasNEWT != null) {
            window.removeGLEventListener((GLEventListener)listener);
        }
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = false;
        GLProfile.shutdown();
    }

    protected void update() {
        if (!this.setFps) {
            this.setFps(this.targetFps);
        }
        if (!fboLayerCreated) {
            String ext = this.getString(7939);
            if (-1 < ext.indexOf("texture_non_power_of_two")) {
                fboWidth = this.pg.width;
                fboHeight = this.pg.height;
            } else {
                fboWidth = PGL.nextPowerOfTwo(this.pg.width);
                fboHeight = PGL.nextPowerOfTwo(this.pg.height);
            }
            this.getIntegerv(36183, this.intBuffer);
            numSamples = -1 < ext.indexOf("_framebuffer_multisample") && 1 < this.intBuffer.get(0) ? reqNumSamples : 1;
            boolean multisample = 1 < numSamples;
            boolean packed = ext.indexOf("packed_depth_stencil") != -1;
            int depthBits = this.getDepthBits();
            int stencilBits = this.getStencilBits();
            this.genTextures(2, glColorTex);
            for (int i = 0; i < 2; ++i) {
                this.bindTexture(3553, glColorTex.get(i));
                this.texParameteri(3553, 10241, 9728);
                this.texParameteri(3553, 10240, 9728);
                this.texParameteri(3553, 10242, 33071);
                this.texParameteri(3553, 10243, 33071);
                this.texImage2D(3553, 0, 6408, fboWidth, fboHeight, 0, 6408, 5121, null);
                this.initTexture(3553, 6408, fboWidth, fboHeight, this.pg.backgroundColor);
            }
            this.bindTexture(3553, 0);
            backTex = 0;
            frontTex = 1;
            this.genFramebuffers(1, glColorFbo);
            this.bindFramebuffer(36160, glColorFbo.get(0));
            this.framebufferTexture2D(36160, 36064, 3553, glColorTex.get(backTex), 0);
            if (multisample) {
                this.genFramebuffers(1, glMultiFbo);
                this.bindFramebuffer(36160, glMultiFbo.get(0));
                this.genRenderbuffers(1, glColorBuf);
                this.bindRenderbuffer(36161, glColorBuf.get(0));
                this.renderbufferStorageMultisample(36161, numSamples, 32856, fboWidth, fboHeight);
                this.framebufferRenderbuffer(36160, 36064, 36161, glColorBuf.get(0));
            }
            if (packed && depthBits == 24 && stencilBits == 8) {
                this.genRenderbuffers(1, glDepthStencil);
                this.bindRenderbuffer(36161, glDepthStencil.get(0));
                if (multisample) {
                    this.renderbufferStorageMultisample(36161, numSamples, 35056, fboWidth, fboHeight);
                } else {
                    this.renderbufferStorage(36161, 35056, fboWidth, fboHeight);
                }
                this.framebufferRenderbuffer(36160, 36096, 36161, glDepthStencil.get(0));
                this.framebufferRenderbuffer(36160, 36128, 36161, glDepthStencil.get(0));
            } else {
                if (0 < depthBits) {
                    int depthComponent = 33189;
                    if (depthBits == 32) {
                        depthComponent = 33191;
                    } else if (depthBits == 24) {
                        depthComponent = 33190;
                    } else if (depthBits == 16) {
                        depthComponent = 33189;
                    }
                    this.genRenderbuffers(1, glDepth);
                    this.bindRenderbuffer(36161, glDepth.get(0));
                    if (multisample) {
                        this.renderbufferStorageMultisample(36161, numSamples, depthComponent, fboWidth, fboHeight);
                    } else {
                        this.renderbufferStorage(36161, depthComponent, fboWidth, fboHeight);
                    }
                    this.framebufferRenderbuffer(36160, 36096, 36161, glDepth.get(0));
                }
                if (0 < stencilBits) {
                    int stencilIndex = 36166;
                    if (stencilBits == 8) {
                        stencilIndex = 36168;
                    } else if (stencilBits == 4) {
                        stencilIndex = 36167;
                    } else if (stencilBits == 1) {
                        stencilIndex = 36166;
                    }
                    this.genRenderbuffers(1, glStencil);
                    this.bindRenderbuffer(36161, glStencil.get(0));
                    if (multisample) {
                        this.renderbufferStorageMultisample(36161, numSamples, stencilIndex, fboWidth, fboHeight);
                    } else {
                        this.renderbufferStorage(36161, stencilIndex, fboWidth, fboHeight);
                    }
                    this.framebufferRenderbuffer(36160, 36128, 36161, glStencil.get(0));
                }
            }
            this.validateFramebuffer();
            this.clearDepth(1.0f);
            this.clearStencil(0);
            int argb = this.pg.backgroundColor;
            float a = (float)(argb >> 24 & 0xFF) / 255.0f;
            float r = (float)(argb >> 16 & 0xFF) / 255.0f;
            float g = (float)(argb >> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            this.clearColor(r, g, b, a);
            this.clear(17664);
            this.bindFramebuffer(36160, 0);
            fboLayerCreated = true;
        }
    }

    protected int getReadFramebuffer() {
        if (fboLayerInUse) {
            return glColorFbo.get(0);
        }
        if (capabilities.isFBO()) {
            return context.getDefaultReadFramebuffer();
        }
        return 0;
    }

    protected int getDrawFramebuffer() {
        if (fboLayerInUse) {
            if (1 < numSamples) {
                return glMultiFbo.get(0);
            }
            return glColorFbo.get(0);
        }
        if (capabilities.isFBO()) {
            return context.getDefaultDrawFramebuffer();
        }
        return 0;
    }

    protected int getDefaultDrawBuffer() {
        if (fboLayerInUse) {
            return 36064;
        }
        if (capabilities.isFBO()) {
            return 36064;
        }
        if (capabilities.getDoubleBuffered()) {
            return 1029;
        }
        return 1028;
    }

    protected int getDefaultReadBuffer() {
        if (fboLayerInUse) {
            return 36064;
        }
        if (capabilities.isFBO()) {
            return 36064;
        }
        if (capabilities.getDoubleBuffered()) {
            return 1029;
        }
        return 1028;
    }

    protected boolean isFBOBacked() {
        return fboLayerInUse || capabilities.isFBO();
    }

    protected void needFBOLayer() {
        FORCE_SCREEN_FBO = true;
    }

    protected boolean isMultisampled() {
        return 1 < numSamples || 0 < capabilities.getNumSamples();
    }

    protected int getDepthBits() {
        this.intBuffer.rewind();
        this.getIntegerv(3414, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected int getStencilBits() {
        this.intBuffer.rewind();
        this.getIntegerv(3415, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected boolean getDepthTest() {
        this.intBuffer.rewind();
        this.getBooleanv(2929, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean getDepthWriteMask() {
        this.intBuffer.rewind();
        this.getBooleanv(2930, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected Texture wrapBackTexture() {
        Texture tex = new Texture();
        tex.init(this.pg.width, this.pg.height, glColorTex.get(backTex), 3553, 6408, fboWidth, fboHeight, 9728, 9728, 33071, 33071);
        tex.invertedY(true);
        tex.colorBuffer(true);
        this.pg.setCache(this.pg, tex);
        return tex;
    }

    protected Texture wrapFrontTexture() {
        Texture tex = new Texture();
        tex.init(this.pg.width, this.pg.height, glColorTex.get(frontTex), 3553, 6408, fboWidth, fboHeight, 9728, 9728, 33071, 33071);
        tex.invertedY(true);
        tex.colorBuffer(true);
        return tex;
    }

    protected int getBackTextureName() {
        return glColorTex.get(backTex);
    }

    protected int getFrontTextureName() {
        return glColorTex.get(frontTex);
    }

    protected void bindFrontTexture() {
        if (!this.texturingIsEnabled(3553)) {
            this.enableTexturing(3553);
        }
        this.bindTexture(3553, glColorTex.get(frontTex));
    }

    protected void unbindFrontTexture() {
        if (this.textureIsBound(3553, glColorTex.get(frontTex))) {
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                this.bindTexture(3553, 0);
                this.disableTexturing(3553);
            } else {
                this.bindTexture(3553, 0);
            }
        }
    }

    protected void syncBackTexture() {
        if (1 < numSamples) {
            this.bindFramebuffer(36008, glMultiFbo.get(0));
            this.bindFramebuffer(36009, glColorFbo.get(0));
            this.blitFramebuffer(0, 0, fboWidth, fboHeight, 0, 0, fboWidth, fboHeight, 16384, 9728);
        }
    }

    protected int qualityToSamples(int quality) {
        if (quality <= 1) {
            return 1;
        }
        int n = 2 * (quality / 2);
        return n;
    }

    protected void beginDraw(boolean clear0) {
        if (this.fboLayerInUse(clear0)) {
            this.bindFramebuffer(36160, glColorFbo.get(0));
            this.framebufferTexture2D(36160, 36064, 3553, glColorTex.get(backTex), 0);
            if (1 < numSamples) {
                this.bindFramebuffer(36160, glMultiFbo.get(0));
            }
            if (firstFrame) {
                int argb = this.pg.backgroundColor;
                float a = (float)(argb >> 24 & 0xFF) / 255.0f;
                float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                float b = (float)(argb & 0xFF) / 255.0f;
                this.clearColor(r, g, b, a);
                this.clear(16384);
            } else if (!clear0) {
                this.drawTexture(3553, glColorTex.get(frontTex), fboWidth, fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            }
            fboLayerInUse = true;
        } else {
            fboLayerInUse = false;
        }
        if (firstFrame) {
            firstFrame = false;
        }
        if (!fboLayerByDefault) {
            FORCE_SCREEN_FBO = false;
        }
    }

    protected void endDraw(boolean clear0) {
        if (fboLayerInUse) {
            this.syncBackTexture();
            this.bindFramebuffer(36160, 0);
            this.clearDepth(1.0f);
            this.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.clear(16640);
            this.disable(3042);
            this.drawTexture(3553, glColorTex.get(backTex), fboWidth, fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            int temp = frontTex;
            frontTex = backTex;
            backTex = temp;
        }
        ++this.fcount;
        int m = this.pg.parent.millis();
        if (m - this.lastm > 1000 * this.fint) {
            this.currentFps = (float)this.fcount / (float)this.fint;
            this.fcount = 0;
            this.lastm = m;
        }
        if (this.currentFps < 0.5f * this.targetFps) {
            this.finish();
        }
    }

    protected boolean canDraw() {
        return this.pg.initialized && this.pg.parent.isDisplayable();
    }

    protected void requestDraw() {
        if (this.pg.initialized && this.pg.parent.canDraw()) {
            try {
                if (toolkit == 0) {
                    canvasAWT.display();
                } else if (toolkit == 1) {
                    window.display();
                }
            }
            catch (GLException e) {
                Throwable tr = e.getCause();
                if (tr instanceof RuntimeException) {
                    throw (RuntimeException)tr;
                }
                throw new RuntimeException(tr);
            }
        }
    }

    protected boolean threadIsCurrent() {
        return Thread.currentThread() == glThread;
    }

    protected boolean fboLayerInUse(boolean clear0) {
        boolean cond = !clear0 || FORCE_SCREEN_FBO || 1 < numSamples;
        return cond && glColorFbo.get(0) != 0;
    }

    protected void beginGL() {
        if (this.projMatrix == null) {
            this.projMatrix = new float[16];
        }
        gl2x.glMatrixMode(5889);
        this.projMatrix[0] = this.pg.projection.m00;
        this.projMatrix[1] = this.pg.projection.m10;
        this.projMatrix[2] = this.pg.projection.m20;
        this.projMatrix[3] = this.pg.projection.m30;
        this.projMatrix[4] = this.pg.projection.m01;
        this.projMatrix[5] = this.pg.projection.m11;
        this.projMatrix[6] = this.pg.projection.m21;
        this.projMatrix[7] = this.pg.projection.m31;
        this.projMatrix[8] = this.pg.projection.m02;
        this.projMatrix[9] = this.pg.projection.m12;
        this.projMatrix[10] = this.pg.projection.m22;
        this.projMatrix[11] = this.pg.projection.m32;
        this.projMatrix[12] = this.pg.projection.m03;
        this.projMatrix[13] = this.pg.projection.m13;
        this.projMatrix[14] = this.pg.projection.m23;
        this.projMatrix[15] = this.pg.projection.m33;
        gl2x.glLoadMatrixf(this.projMatrix, 0);
        if (this.mvMatrix == null) {
            this.mvMatrix = new float[16];
        }
        gl2x.glMatrixMode(5888);
        this.mvMatrix[0] = this.pg.modelview.m00;
        this.mvMatrix[1] = this.pg.modelview.m10;
        this.mvMatrix[2] = this.pg.modelview.m20;
        this.mvMatrix[3] = this.pg.modelview.m30;
        this.mvMatrix[4] = this.pg.modelview.m01;
        this.mvMatrix[5] = this.pg.modelview.m11;
        this.mvMatrix[6] = this.pg.modelview.m21;
        this.mvMatrix[7] = this.pg.modelview.m31;
        this.mvMatrix[8] = this.pg.modelview.m02;
        this.mvMatrix[9] = this.pg.modelview.m12;
        this.mvMatrix[10] = this.pg.modelview.m22;
        this.mvMatrix[11] = this.pg.modelview.m32;
        this.mvMatrix[12] = this.pg.modelview.m03;
        this.mvMatrix[13] = this.pg.modelview.m13;
        this.mvMatrix[14] = this.pg.modelview.m23;
        this.mvMatrix[15] = this.pg.modelview.m33;
        gl2x.glLoadMatrixf(this.mvMatrix, 0);
    }

    protected void endGL() {
    }

    public String getString(int name) {
        return gl.glGetString(name);
    }

    public void getIntegerv(int name, IntBuffer values) {
        if (-1 < name) {
            gl.glGetIntegerv(name, values);
        } else {
            PGL.fillIntBuffer(values, 0, values.capacity() - 1, 0);
        }
    }

    public void getFloatv(int name, FloatBuffer values) {
        if (-1 < name) {
            gl.glGetFloatv(name, values);
        } else {
            PGL.fillFloatBuffer(values, 0, values.capacity() - 1, 0.0f);
        }
    }

    public void getBooleanv(int name, IntBuffer values) {
        if (-1 < name) {
            if (this.byteBuffer.capacity() < values.capacity()) {
                this.byteBuffer = PGL.allocateDirectByteBuffer(values.capacity());
            }
            gl.glGetBooleanv(name, this.byteBuffer);
            for (int i = 0; i < values.capacity(); ++i) {
                values.put(i, this.byteBuffer.get(i));
            }
        } else {
            PGL.fillIntBuffer(values, 0, values.capacity() - 1, 0);
        }
    }

    public void enable(int cap) {
        if (-1 < cap) {
            gl.glEnable(cap);
        }
    }

    public void disable(int cap) {
        if (-1 < cap) {
            gl.glDisable(cap);
        }
    }

    public void flush() {
        gl.glFlush();
    }

    public void finish() {
        gl.glFinish();
    }

    public int getError() {
        return gl.glGetError();
    }

    public String errorString(int err) {
        return glu.gluErrorString(err);
    }

    public void frontFace(int mode) {
        gl.glFrontFace(mode);
    }

    public void cullFace(int mode) {
        gl.glCullFace(mode);
    }

    public void depthMask(boolean flag) {
        gl.glDepthMask(flag);
    }

    public void depthFunc(int func) {
        gl.glDepthFunc(func);
    }

    public void genTextures(int n, IntBuffer ids) {
        gl.glGenTextures(n, ids);
    }

    public void deleteTextures(int n, IntBuffer ids) {
        gl.glDeleteTextures(n, ids);
    }

    public void activeTexture(int unit) {
        gl.glActiveTexture(unit);
    }

    public void bindTexture(int target, int id) {
        gl.glBindTexture(target, id);
        if (target == 3553) {
            PGL.boundTextures[0] = id;
        } else if (target == 34037) {
            PGL.boundTextures[1] = id;
        }
    }

    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        gl.glTexImage2D(target, level, internalFormat, width, height, border, format, type, data);
    }

    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        gl.glTexSubImage2D(target, level, xOffset, yOffset, width, height, format, type, data);
    }

    public void texParameteri(int target, int param, int value) {
        gl.glTexParameteri(target, param, value);
    }

    public void texParameterf(int target, int param, float value) {
        gl.glTexParameterf(target, param, value);
    }

    public void getTexParameteriv(int target, int param, IntBuffer values) {
        gl.glGetTexParameteriv(target, param, values);
    }

    public void generateMipmap(int target) {
        gl.glGenerateMipmap(target);
    }

    public void genBuffers(int n, IntBuffer ids) {
        gl.glGenBuffers(n, ids);
    }

    public void deleteBuffers(int n, IntBuffer ids) {
        gl.glDeleteBuffers(n, ids);
    }

    public void bindBuffer(int target, int id) {
        gl.glBindBuffer(target, id);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        gl.glBufferData(target, (long)size, data, usage);
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        gl.glBufferSubData(target, (long)offset, (long)size, data);
    }

    public void drawArrays(int mode, int first, int count) {
        gl.glDrawArrays(mode, first, count);
    }

    public void drawElements(int mode, int count, int type, int offset) {
        gl.glDrawElements(mode, count, type, (long)offset);
    }

    public void enableVertexAttribArray(int loc) {
        gl2.glEnableVertexAttribArray(loc);
    }

    public void disableVertexAttribArray(int loc) {
        gl2.glDisableVertexAttribArray(loc);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, int offset) {
        gl2.glVertexAttribPointer(loc, size, type, normalized, stride, (long)offset);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, Buffer data) {
        gl2.glVertexAttribPointer(loc, size, type, normalized, stride, data);
    }

    public ByteBuffer mapBuffer(int target, int access) {
        return gl2.glMapBuffer(target, access);
    }

    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        if (gl2x != null) {
            return gl2x.glMapBufferRange(target, (long)offset, (long)length, access);
        }
        return null;
    }

    public void unmapBuffer(int target) {
        gl2.glUnmapBuffer(target);
    }

    public void genFramebuffers(int n, IntBuffer ids) {
        gl.glGenFramebuffers(n, ids);
    }

    public void deleteFramebuffers(int n, IntBuffer ids) {
        gl.glDeleteFramebuffers(n, ids);
    }

    public void genRenderbuffers(int n, IntBuffer ids) {
        gl.glGenRenderbuffers(n, ids);
    }

    public void deleteRenderbuffers(int n, IntBuffer ids) {
        gl.glDeleteRenderbuffers(n, ids);
    }

    public void bindFramebuffer(int target, int id) {
        gl.glBindFramebuffer(target, id);
    }

    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        if (gl2x != null) {
            gl2x.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
    }

    public void framebufferTexture2D(int target, int attachment, int texTarget, int texId, int level) {
        gl.glFramebufferTexture2D(target, attachment, texTarget, texId, level);
    }

    public void bindRenderbuffer(int target, int id) {
        gl.glBindRenderbuffer(target, id);
    }

    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        if (gl2x != null) {
            gl2x.glRenderbufferStorageMultisample(target, samples, format, width, height);
        }
    }

    public void renderbufferStorage(int target, int format, int width, int height) {
        gl.glRenderbufferStorage(target, format, width, height);
    }

    public void framebufferRenderbuffer(int target, int attachment, int rendbufTarget, int rendbufId) {
        gl.glFramebufferRenderbuffer(target, attachment, rendbufTarget, rendbufId);
    }

    public int checkFramebufferStatus(int target) {
        return gl.glCheckFramebufferStatus(target);
    }

    public int createProgram() {
        return gl2.glCreateProgram();
    }

    public void deleteProgram(int id) {
        gl2.glDeleteProgram(id);
    }

    public int createShader(int type) {
        return gl2.glCreateShader(type);
    }

    public void deleteShader(int id) {
        gl2.glDeleteShader(id);
    }

    public void linkProgram(int prog) {
        gl2.glLinkProgram(prog);
    }

    public void validateProgram(int prog) {
        gl2.glValidateProgram(prog);
    }

    public void useProgram(int prog) {
        gl2.glUseProgram(prog);
    }

    public int getAttribLocation(int prog, String name) {
        return gl2.glGetAttribLocation(prog, name);
    }

    public int getUniformLocation(int prog, String name) {
        return gl2.glGetUniformLocation(prog, name);
    }

    public void uniform1i(int loc, int value) {
        gl2.glUniform1i(loc, value);
    }

    public void uniform2i(int loc, int value0, int value1) {
        gl2.glUniform2i(loc, value0, value1);
    }

    public void uniform3i(int loc, int value0, int value1, int value2) {
        gl2.glUniform3i(loc, value0, value1, value2);
    }

    public void uniform4i(int loc, int value0, int value1, int value2, int value3) {
        gl2.glUniform4i(loc, value0, value1, value2, value3);
    }

    public void uniform1f(int loc, float value) {
        gl2.glUniform1f(loc, value);
    }

    public void uniform2f(int loc, float value0, float value1) {
        gl2.glUniform2f(loc, value0, value1);
    }

    public void uniform3f(int loc, float value0, float value1, float value2) {
        gl2.glUniform3f(loc, value0, value1, value2);
    }

    public void uniform4f(int loc, float value0, float value1, float value2, float value3) {
        gl2.glUniform4f(loc, value0, value1, value2, value3);
    }

    public void uniform1iv(int loc, int count, IntBuffer v) {
        gl2.glUniform1iv(loc, count, v);
    }

    public void uniform2iv(int loc, int count, IntBuffer v) {
        gl2.glUniform2iv(loc, count, v);
    }

    public void uniform3iv(int loc, int count, IntBuffer v) {
        gl2.glUniform3iv(loc, count, v);
    }

    public void uniform4iv(int loc, int count, IntBuffer v) {
        gl2.glUniform4iv(loc, count, v);
    }

    public void uniform1fv(int loc, int count, FloatBuffer v) {
        gl2.glUniform1fv(loc, count, v);
    }

    public void uniform2fv(int loc, int count, FloatBuffer v) {
        gl2.glUniform2fv(loc, count, v);
    }

    public void uniform3fv(int loc, int count, FloatBuffer v) {
        gl2.glUniform3fv(loc, count, v);
    }

    public void uniform4fv(int loc, int count, FloatBuffer v) {
        gl2.glUniform4fv(loc, count, v);
    }

    public void uniformMatrix2fv(int loc, int count, boolean transpose, FloatBuffer mat) {
        gl2.glUniformMatrix2fv(loc, count, transpose, mat);
    }

    public void uniformMatrix3fv(int loc, int count, boolean transpose, FloatBuffer mat) {
        gl2.glUniformMatrix3fv(loc, count, transpose, mat);
    }

    public void uniformMatrix4fv(int loc, int count, boolean transpose, FloatBuffer mat) {
        gl2.glUniformMatrix4fv(loc, count, transpose, mat);
    }

    public void vertexAttrib1f(int loc, float value) {
        gl2.glVertexAttrib1f(loc, value);
    }

    public void vertexAttrib2f(int loc, float value0, float value1) {
        gl2.glVertexAttrib2f(loc, value0, value1);
    }

    public void vertexAttrib3f(int loc, float value0, float value1, float value2) {
        gl2.glVertexAttrib3f(loc, value0, value1, value2);
    }

    public void vertexAttrib4f(int loc, float value0, float value1, float value2, float value3) {
        gl2.glVertexAttrib4f(loc, value0, value1, value2, value3);
    }

    public void vertexAttrib1fv(int loc, FloatBuffer v) {
        gl2.glVertexAttrib1fv(loc, v);
    }

    public void vertexAttrib2fv(int loc, FloatBuffer v) {
        gl2.glVertexAttrib2fv(loc, v);
    }

    public void vertexAttrib3fv(int loc, FloatBuffer v) {
        gl2.glVertexAttrib3fv(loc, v);
    }

    public void vertexAttri4fv(int loc, FloatBuffer v) {
        gl2.glVertexAttrib4fv(loc, v);
    }

    public void shaderSource(int id, String source) {
        gl2.glShaderSource(id, 1, new String[]{source}, (int[])null, 0);
    }

    public void compileShader(int id) {
        gl2.glCompileShader(id);
    }

    public void attachShader(int prog, int shader) {
        gl2.glAttachShader(prog, shader);
    }

    public void getShaderiv(int shader, int pname, IntBuffer params) {
        gl2.glGetShaderiv(shader, pname, params);
    }

    public String getShaderInfoLog(int shader) {
        int[] val = new int[]{0};
        gl2.glGetShaderiv(shader, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        gl2.glGetShaderInfoLog(shader, length, val, 0, log, 0);
        return new String(log);
    }

    public void getProgramiv(int prog, int pname, IntBuffer params) {
        gl2.glGetProgramiv(prog, pname, params);
    }

    public String getProgramInfoLog(int prog) {
        int[] val = new int[]{0};
        gl2.glGetShaderiv(prog, 35716, val, 0);
        int length = val[0];
        if (0 < length) {
            byte[] log = new byte[length];
            gl2.glGetProgramInfoLog(prog, length, val, 0, log, 0);
            return new String(log);
        }
        return "Unknow error";
    }

    public void viewport(int x, int y, int width, int height) {
        gl.glViewport(x, y, width, height);
    }

    public void scissor(int x, int y, int w, int h) {
        gl.glScissor(x, y, w, h);
    }

    public void blendEquation(int eq) {
        gl.glBlendEquation(eq);
    }

    public void blendFunc(int srcFactor, int dstFactor) {
        gl.glBlendFunc(srcFactor, dstFactor);
    }

    public void readBuffer(int buf) {
        if (gl2x != null) {
            gl2x.glReadBuffer(buf);
        }
    }

    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        gl.glReadPixels(x, y, width, height, format, type, buffer);
    }

    public void drawBuffer(int buf) {
        if (gl2x != null) {
            gl2x.glDrawBuffer(buf);
        }
    }

    public void clearDepth(float d) {
        gl.glClearDepthf(d);
    }

    public void clearStencil(int s) {
        gl.glClearStencil(s);
    }

    public void colorMask(boolean wr, boolean wg, boolean wb, boolean wa) {
        gl.glColorMask(wr, wg, wb, wa);
    }

    public void clearColor(float r, float g, float b, float a) {
        gl.glClearColor(r, g, b, a);
    }

    public void clear(int mask) {
        gl.glClear(mask);
    }

    protected int createEmptyContext() {
        return -1;
    }

    protected int getCurrentContext() {
        return context.hashCode();
    }

    protected Tessellator createTessellator(TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    protected String tessError(int err) {
        return glu.gluErrorString(err);
    }

    protected boolean contextIsCurrent(int other) {
        return other == -1 || other == context.hashCode();
    }

    protected void enableTexturing(int target) {
        this.enable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = true;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = true;
        }
    }

    protected void disableTexturing(int target) {
        this.disable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = false;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = false;
        }
    }

    protected boolean texturingIsEnabled(int target) {
        if (target == 3553) {
            return texturingTargets[0];
        }
        if (target == 34037) {
            return texturingTargets[1];
        }
        return false;
    }

    protected boolean textureIsBound(int target, int id) {
        if (target == 3553) {
            return boundTextures[0] == id;
        }
        if (target == 34037) {
            return boundTextures[1] == id;
        }
        return false;
    }

    protected void initTexture(int target, int format, int width, int height) {
        this.initTexture(target, format, width, height, 0);
    }

    protected void initTexture(int target, int format, int width, int height, int initColor) {
        int[] glcolor = new int[256];
        Arrays.fill(glcolor, PGL.javaToNativeARGB(initColor));
        IntBuffer texels = PGL.allocateDirectIntBuffer(256);
        texels.put(glcolor);
        texels.rewind();
        for (int y = 0; y < height; y += 16) {
            int h = PApplet.min(16, height - y);
            for (int x = 0; x < width; x += 16) {
                int w = PApplet.min(16, width - x);
                this.texSubImage2D(target, 0, x, y, w, h, format, 5121, texels);
            }
        }
    }

    protected void copyToTexture(int target, int format, int id, int x, int y, int w, int h, IntBuffer buffer) {
        this.activeTexture(33984);
        boolean enabledTex = false;
        if (!this.texturingIsEnabled(target)) {
            this.enableTexturing(target);
            enabledTex = true;
        }
        this.bindTexture(target, id);
        this.texSubImage2D(target, 0, x, y, w, h, format, 5121, buffer);
        this.bindTexture(target, 0);
        if (enabledTex) {
            this.disableTexturing(target);
        }
    }

    protected void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.drawTexture(target, id, width, height, X0, Y0, X1, Y1, X0, Y0, X1, Y1);
    }

    protected void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (target == 3553) {
            this.drawTexture2D(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        } else if (target == 34037) {
            this.drawTextureRect(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        }
    }

    protected void drawTexture2D(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!loadedTex2DShader || tex2DShaderContext.hashCode() != context.hashCode()) {
            tex2DVertShader = this.createShader(35633, texVertShaderSource);
            tex2DFragShader = this.createShader(35632, tex2DFragShaderSource);
            if (0 < tex2DVertShader && 0 < tex2DFragShader) {
                tex2DShaderProgram = this.createProgram(tex2DVertShader, tex2DFragShader);
            }
            if (0 < tex2DShaderProgram) {
                tex2DVertLoc = this.getAttribLocation(tex2DShaderProgram, "inVertex");
                tex2DTCoordLoc = this.getAttribLocation(tex2DShaderProgram, "inTexcoord");
            }
            loadedTex2DShader = true;
            tex2DShaderContext = context;
        }
        if (texData == null) {
            texData = PGL.allocateDirectFloatBuffer(texCoords.length);
        }
        if (0 < tex2DShaderProgram) {
            boolean depthTest = this.getDepthTest();
            this.disable(2929);
            boolean depthMask = this.getDepthWriteMask();
            this.depthMask(false);
            this.useProgram(tex2DShaderProgram);
            this.enableVertexAttribArray(tex2DVertLoc);
            this.enableVertexAttribArray(tex2DTCoordLoc);
            PGL.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[2] = (float)texX0 / (float)width;
            PGL.texCoords[3] = (float)texY0 / (float)height;
            PGL.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[6] = (float)texX1 / (float)width;
            PGL.texCoords[7] = (float)texY0 / (float)height;
            PGL.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[10] = (float)texX0 / (float)width;
            PGL.texCoords[11] = (float)texY1 / (float)height;
            PGL.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[14] = (float)texX1 / (float)width;
            PGL.texCoords[15] = (float)texY1 / (float)height;
            texData.rewind();
            texData.put(texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                enabledTex = true;
            }
            this.bindTexture(3553, id);
            this.bindBuffer(34962, 0);
            texData.position(0);
            this.vertexAttribPointer(tex2DVertLoc, 2, 5126, false, 16, texData);
            texData.position(2);
            this.vertexAttribPointer(tex2DTCoordLoc, 2, 5126, false, 16, texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(3553, 0);
            if (enabledTex) {
                this.disableTexturing(3553);
            }
            this.disableVertexAttribArray(tex2DVertLoc);
            this.disableVertexAttribArray(tex2DTCoordLoc);
            this.useProgram(0);
            if (depthTest) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask);
        }
    }

    protected void drawTextureRect(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!loadedTexRectShader || texRectShaderContext.hashCode() != context.hashCode()) {
            texRectVertShader = this.createShader(35633, texVertShaderSource);
            texRectFragShader = this.createShader(35632, texRectFragShaderSource);
            if (0 < texRectVertShader && 0 < texRectFragShader) {
                texRectShaderProgram = this.createProgram(texRectVertShader, texRectFragShader);
            }
            if (0 < texRectShaderProgram) {
                texRectVertLoc = this.getAttribLocation(texRectShaderProgram, "inVertex");
                texRectTCoordLoc = this.getAttribLocation(texRectShaderProgram, "inTexcoord");
            }
            loadedTexRectShader = true;
            texRectShaderContext = context;
        }
        if (texData == null) {
            texData = PGL.allocateDirectFloatBuffer(texCoords.length);
        }
        if (0 < texRectShaderProgram) {
            boolean depthTest = this.getDepthTest();
            this.disable(2929);
            boolean depthMask = this.getDepthWriteMask();
            this.depthMask(false);
            this.useProgram(texRectShaderProgram);
            this.enableVertexAttribArray(texRectVertLoc);
            this.enableVertexAttribArray(texRectTCoordLoc);
            PGL.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[2] = texX0;
            PGL.texCoords[3] = texY0;
            PGL.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            PGL.texCoords[6] = texX1;
            PGL.texCoords[7] = texY0;
            PGL.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            PGL.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[10] = texX0;
            PGL.texCoords[11] = texY1;
            PGL.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            PGL.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            PGL.texCoords[14] = texX1;
            PGL.texCoords[15] = texY1;
            texData.rewind();
            texData.put(texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(34037)) {
                this.enableTexturing(34037);
                enabledTex = true;
            }
            this.bindTexture(34037, id);
            this.bindBuffer(34962, 0);
            texData.position(0);
            this.vertexAttribPointer(texRectVertLoc, 2, 5126, false, 16, texData);
            texData.position(2);
            this.vertexAttribPointer(texRectTCoordLoc, 2, 5126, false, 16, texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(34037, 0);
            if (enabledTex) {
                this.disableTexturing(34037);
            }
            this.disableVertexAttribArray(texRectVertLoc);
            this.disableVertexAttribArray(texRectTCoordLoc);
            this.useProgram(0);
            if (depthTest) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask);
        }
    }

    protected int getColorValue(int scrX, int scrY) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int scrX, int scrY) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6402, 5126, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    protected byte getStencilValue(int scrX, int scrY) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6401, 5121, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    protected static int nextPowerOfTwo(int val) {
        int ret;
        for (ret = 1; ret < val; ret <<= 1) {
        }
        return ret;
    }

    protected static int nativeToJavaARGB(int color) {
        if (BIG_ENDIAN) {
            return color & 0xFF000000 | color >> 8 & 0xFFFFFF;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int nativeToJavaRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeARGB(int color) {
        if (BIG_ENDIAN) {
            return color >> 24 & 0xFF | color << 8 & 0xFFFFFF00;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                        pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] >> 24 & 0xFF | pixels[index] << 8 & 0xFFFFFF00;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                        pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected int createShader(int shaderType, String source) {
        int shader = this.createShader(shaderType);
        if (shader != 0) {
            this.shaderSource(shader, source);
            this.compileShader(shader);
            if (!this.compiled(shader)) {
                System.err.println("Could not compile shader " + shaderType + ":");
                System.err.println(this.getShaderInfoLog(shader));
                this.deleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    protected int createProgram(int vertexShader, int fragmentShader) {
        int program = this.createProgram();
        if (program != 0) {
            this.attachShader(program, vertexShader);
            this.attachShader(program, fragmentShader);
            this.linkProgram(program);
            if (!this.linked(program)) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(program));
                this.deleteProgram(program);
                program = 0;
            }
        }
        return program;
    }

    protected boolean compiled(int shader) {
        this.intBuffer.rewind();
        this.getShaderiv(shader, 35713, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean linked(int program) {
        this.intBuffer.rewind();
        this.getProgramiv(program, 35714, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean validateFramebuffer() {
        int status = this.checkFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete attachment"));
        } else if (status == 36055) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete missing attachment"));
        } else if (status == 36057) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete dimensions"));
        } else if (status == 36058) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete formats"));
        } else if (status == 36061) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "framebuffer unsupported"));
        } else {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "unknown error"));
        }
        return false;
    }

    protected int[] getGLVersion() {
        String version = this.getString(7938).trim();
        int[] res = new int[]{0, 0, 0};
        String[] parts = version.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            if (0 >= parts[i].indexOf(".")) continue;
            String[] nums = parts[i].split("\\.");
            try {
                res[0] = Integer.parseInt(nums[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (1 < nums.length) {
                try {
                    res[1] = Integer.parseInt(nums[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (2 >= nums.length) break;
            try {
                res[2] = Integer.parseInt(nums[2]);
            }
            catch (NumberFormatException e) {}
            break;
        }
        return res;
    }

    protected boolean hasFBOs() {
        return context.hasBasicFBOSupport();
    }

    protected boolean hasShaders() {
        if (context.hasGLSL()) {
            return true;
        }
        int major = this.getGLVersion()[0];
        if (major < 2) {
            String ext = this.getString(7939);
            return ext.indexOf("_fragment_shader") != -1 && ext.indexOf("_vertex_shader") != -1 && ext.indexOf("_shader_objects") != -1 && ext.indexOf("_shading_language") != -1;
        }
        return false;
    }

    protected static ByteBuffer allocateDirectByteBuffer(int size) {
        int bytes = PApplet.max(1, size) * 1;
        return ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder());
    }

    protected static ByteBuffer allocateByteBuffer(int size) {
        return PGL.allocateDirectByteBuffer(size);
    }

    protected static ByteBuffer allocateByteBuffer(byte[] arr) {
        return PGL.allocateDirectByteBuffer(arr.length);
    }

    protected static ByteBuffer updateByteBuffer(ByteBuffer buf, byte[] arr, boolean wrap) {
        if (buf == null || buf.capacity() < arr.length) {
            buf = PGL.allocateDirectByteBuffer(arr.length);
        }
        buf.position(0);
        buf.put(arr);
        buf.rewind();
        return buf;
    }

    protected static void updateByteBuffer(ByteBuffer buf, byte[] arr, int offset, int size) {
        buf.position(offset);
        buf.put(arr, offset, size);
        buf.rewind();
    }

    protected static void getByteArray(ByteBuffer buf, byte[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.get(arr);
            buf.rewind();
        }
    }

    protected static void putByteArray(ByteBuffer buf, byte[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.put(arr);
            buf.rewind();
        }
    }

    protected static void fillByteBuffer(ByteBuffer buf, int i0, int i1, byte val) {
        int n = i1 - i0;
        byte[] temp = new byte[n];
        Arrays.fill(temp, 0, n, val);
        buf.position(i0);
        buf.put(temp, 0, n);
        buf.rewind();
    }

    protected static ShortBuffer allocateDirectShortBuffer(int size) {
        int bytes = PApplet.max(1, size) * 2;
        return ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    protected static ShortBuffer allocateShortBuffer(int size) {
        return PGL.allocateDirectShortBuffer(size);
    }

    protected static ShortBuffer allocateShortBuffer(short[] arr) {
        return PGL.allocateDirectShortBuffer(arr.length);
    }

    protected static ShortBuffer updateShortBuffer(ShortBuffer buf, short[] arr, boolean wrap) {
        if (buf == null || buf.capacity() < arr.length) {
            buf = PGL.allocateDirectShortBuffer(arr.length);
        }
        buf.position(0);
        buf.put(arr);
        buf.rewind();
        return buf;
    }

    protected static void updateShortBuffer(ShortBuffer buf, short[] arr, int offset, int size) {
        buf.position(offset);
        buf.put(arr, offset, size);
        buf.rewind();
    }

    protected static void getShortArray(ShortBuffer buf, short[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.get(arr);
            buf.rewind();
        }
    }

    protected static void putShortArray(ShortBuffer buf, short[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.put(arr);
            buf.rewind();
        }
    }

    protected static void fillShortBuffer(ShortBuffer buf, int i0, int i1, short val) {
        int n = i1 - i0;
        short[] temp = new short[n];
        Arrays.fill(temp, 0, n, val);
        buf.position(i0);
        buf.put(temp, 0, n);
        buf.rewind();
    }

    protected static IntBuffer allocateDirectIntBuffer(int size) {
        int bytes = PApplet.max(1, size) * 4;
        return ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static IntBuffer allocateIntBuffer(int size) {
        return PGL.allocateDirectIntBuffer(size);
    }

    protected static IntBuffer allocateIntBuffer(int[] arr) {
        return PGL.allocateDirectIntBuffer(arr.length);
    }

    protected static IntBuffer updateIntBuffer(IntBuffer buf, int[] arr, boolean wrap) {
        if (buf == null || buf.capacity() < arr.length) {
            buf = PGL.allocateDirectIntBuffer(arr.length);
        }
        buf.position(0);
        buf.put(arr);
        buf.rewind();
        return buf;
    }

    protected static void updateIntBuffer(IntBuffer buf, int[] arr, int offset, int size) {
        buf.position(offset);
        buf.put(arr, offset, size);
        buf.rewind();
    }

    protected static void getIntArray(IntBuffer buf, int[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.get(arr);
            buf.rewind();
        }
    }

    protected static void putIntArray(IntBuffer buf, int[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.put(arr);
            buf.rewind();
        }
    }

    protected static void fillIntBuffer(IntBuffer buf, int i0, int i1, int val) {
        int n = i1 - i0;
        int[] temp = new int[n];
        Arrays.fill(temp, 0, n, val);
        buf.position(i0);
        buf.put(temp, 0, n);
        buf.rewind();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int size) {
        int bytes = PApplet.max(1, size) * 4;
        return ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected static FloatBuffer allocateFloatBuffer(int size) {
        return PGL.allocateDirectFloatBuffer(size);
    }

    protected static FloatBuffer allocateFloatBuffer(float[] arr) {
        return PGL.allocateDirectFloatBuffer(arr.length);
    }

    protected static FloatBuffer updateFloatBuffer(FloatBuffer buf, float[] arr, boolean wrap) {
        if (buf == null || buf.capacity() < arr.length) {
            buf = PGL.allocateDirectFloatBuffer(arr.length);
        }
        buf.position(0);
        buf.put(arr);
        buf.rewind();
        return buf;
    }

    protected static void updateFloatBuffer(FloatBuffer buf, float[] arr, int offset, int size) {
        buf.position(offset);
        buf.put(arr, offset, size);
        buf.rewind();
    }

    protected static void getFloatArray(FloatBuffer buf, float[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.get(arr);
            buf.rewind();
        }
    }

    protected static void putFloatArray(FloatBuffer buf, float[] arr) {
        if (!buf.hasArray() || buf.array() != arr) {
            buf.position(0);
            buf.put(arr);
            buf.rewind();
        }
    }

    protected static void fillFloatBuffer(FloatBuffer buf, int i0, int i1, float val) {
        int n = i1 - i0;
        float[] temp = new float[n];
        Arrays.fill(temp, 0, n, val);
        buf.position(i0);
        buf.put(temp, 0, n);
        buf.rewind();
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent, int peAction) {
        int modifiers = nativeEvent.getModifiers();
        int peModifiers = modifiers & 0xF;
        int peButton = 0;
        if ((modifiers & 0x20) != 0) {
            peButton = 37;
        } else if ((modifiers & 0x40) != 0) {
            peButton = 3;
        } else if ((modifiers & 0x80) != 0) {
            peButton = 39;
        }
        if (PApplet.platform == 2 && (modifiers & 2) != 0) {
            peButton = 39;
        }
        int peCount = peAction == 8 ? (int)nativeEvent.getWheelRotation() : nativeEvent.getClickCount();
        processing.event.MouseEvent me = new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, nativeEvent.getX(), nativeEvent.getY(), peButton, peCount);
        this.pg.parent.postEvent(me);
    }

    protected void nativeKeyEvent(KeyEvent nativeEvent, int peAction) {
        int peModifiers = nativeEvent.getModifiers() & 0xF;
        char keyChar = nativeEvent.getKeyChar() == '\u0000' ? (char)'\uffff' : (char)nativeEvent.getKeyChar();
        processing.event.KeyEvent ke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, keyChar, nativeEvent.getKeyCode());
        this.pg.parent.postEvent(ke);
    }

    static {
        if (PApplet.platform == 1) {
            toolkit = 0;
            events = 0;
        } else if (PApplet.platform == 2) {
            toolkit = 0;
            events = 0;
        } else if (PApplet.platform == 3) {
            toolkit = 1;
            events = 1;
        } else if (PApplet.platform == 0) {
            toolkit = 1;
            events = 1;
        }
        request_depth_bits = 24;
        request_stencil_bits = 8;
        request_alpha_bits = 8;
        FLOAT_EPS = Float.MIN_VALUE;
        float eps = 1.0f;
        while ((double)((float)(1.0 + (double)(eps /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = eps;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        texturingTargets = new boolean[]{false, false};
        boundTextures = new int[]{0, 0};
        fboLayerByDefault = FORCE_SCREEN_FBO;
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = true;
        loadedTex2DShader = false;
        loadedTexRectShader = false;
        texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
        tex2DFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
        texRectFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2DRect textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2DRect(textureSampler, vertTexcoord.st);}";
    }

    class NEWTKeyListener
    extends KeyAdapter {
        NEWTKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 1);
        }

        public void keyReleased(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 2);
        }

        public void keyTyped(KeyEvent e) {
            PGL.this.nativeKeyEvent(e, 3);
        }
    }

    class NEWTMouseListener
    extends MouseAdapter {
        NEWTMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 1);
        }

        public void mouseReleased(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 2);
        }

        public void mouseClicked(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 3);
        }

        public void mouseDragged(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 4);
        }

        public void mouseMoved(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 5);
        }

        public void mouseWheelMoved(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 8);
        }

        public void mouseEntered(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 6);
        }

        public void mouseExited(MouseEvent e) {
            PGL.this.nativeMouseEvent(e, 7);
        }
    }

    class NEWTWindowListener
    implements WindowListener {
        NEWTWindowListener() {
        }

        public void windowGainedFocus(WindowEvent arg0) {
            PGL.this.pg.parent.focusGained(null);
        }

        public void windowLostFocus(WindowEvent arg0) {
            PGL.this.pg.parent.focusLost(null);
        }

        public void windowDestroyNotify(WindowEvent arg0) {
        }

        public void windowDestroyed(WindowEvent arg0) {
        }

        public void windowMoved(WindowEvent arg0) {
        }

        public void windowRepaint(WindowUpdateEvent arg0) {
        }

        public void windowResized(WindowEvent arg0) {
        }
    }

    protected class PGLListener
    implements GLEventListener {
        public void display(GLAutoDrawable glDrawable) {
            drawable = glDrawable;
            context = glDrawable.getContext();
            glThread = Thread.currentThread();
            gl = context.getGL();
            gl2 = gl.getGL2ES2();
            try {
                gl2x = gl.getGL2();
            }
            catch (GLException e) {
                gl2x = null;
            }
            PGL.this.pg.parent.handleDraw();
        }

        public void dispose(GLAutoDrawable adrawable) {
        }

        public void init(GLAutoDrawable adrawable) {
            drawable = adrawable;
            context = adrawable.getContext();
            capabilities = adrawable.getChosenGLCapabilities();
            gl = context.getGL();
            if (!PGL.this.hasFBOs()) {
                throw new RuntimeException("Framebuffer objects are not supported by this hardware (or driver)");
            }
            if (!PGL.this.hasShaders()) {
                throw new RuntimeException("GLSL shaders are not supported by this hardware (or driver)");
            }
        }

        public void reshape(GLAutoDrawable adrawable, int x, int y, int w, int h) {
            drawable = adrawable;
            context = adrawable.getContext();
        }
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected class Tessellator {
        protected GLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback callback) {
            this.callback = callback;
            this.tess = GLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100102, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, (GLUtessellatorCallback)this.gluCallback);
            GLU.gluTessCallback((GLUtessellator)this.tess, (int)100103, (GLUtessellatorCallback)this.gluCallback);
        }

        public void beginPolygon() {
            GLU.gluTessBeginPolygon((GLUtessellator)this.tess, null);
        }

        public void endPolygon() {
            GLU.gluTessEndPolygon((GLUtessellator)this.tess);
        }

        public void setWindingRule(int rule) {
            GLU.gluTessProperty((GLUtessellator)this.tess, (int)100140, (double)rule);
        }

        public void beginContour() {
            GLU.gluTessBeginContour((GLUtessellator)this.tess);
        }

        public void endContour() {
            GLU.gluTessEndContour((GLUtessellator)this.tess);
        }

        public void addVertex(double[] v) {
            GLU.gluTessVertex((GLUtessellator)this.tess, (double[])v, (int)0, (Object)v);
        }

        protected class GLUCallback
        extends GLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            public void end() {
                Tessellator.this.callback.end();
            }

            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }
}

