/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final short BUTTON1 = 1;
    public static final short BUTTON2 = 2;
    public static final short BUTTON3 = 3;
    public static final short BUTTON4 = 4;
    public static final short BUTTON5 = 5;
    public static final short BUTTON6 = 6;
    public static final short BUTTON7 = 7;
    public static final short BUTTON8 = 8;
    public static final short BUTTON9 = 9;
    public static final short BUTTON_NUMBER = 16;
    private final int[] x;
    private final int[] y;
    private final short clickCount;
    private final short button;
    private final float[] rotationXYZ;
    private final float rotationScale;
    private final float[] pressure;
    private final float maxPressure;
    private final short[] pointerIDs;
    private final PointerType[] pointerTypes;
    private static final float[] constMousePressure = new float[]{0.0f};
    private static final short[] constMousePointerIDs = new short[]{0};
    private static final PointerType[] constMousePointerTypes = new PointerType[]{PointerType.Mouse};
    public static final short EVENT_MOUSE_CLICKED = 200;
    public static final short EVENT_MOUSE_ENTERED = 201;
    public static final short EVENT_MOUSE_EXITED = 202;
    public static final short EVENT_MOUSE_PRESSED = 203;
    public static final short EVENT_MOUSE_RELEASED = 204;
    public static final short EVENT_MOUSE_MOVED = 205;
    public static final short EVENT_MOUSE_DRAGGED = 206;
    public static final short EVENT_MOUSE_WHEEL_MOVED = 207;

    public static final short getClickTimeout() {
        return 300;
    }

    public MouseEvent(short s, Object object, long l, int n, int n2, int n3, short s2, short s3, float f) {
        super(s, object, l, n);
        this.x = new int[]{n2};
        this.y = new int[]{n3};
        this.pressure = constMousePressure;
        this.maxPressure = 1.0f;
        this.pointerIDs = constMousePointerIDs;
        this.clickCount = s2;
        this.button = s3;
        this.rotationXYZ = new float[]{0.0f, 0.0f, 0.0f};
        if (this.isShiftDown()) {
            this.rotationXYZ[0] = f;
        } else {
            this.rotationXYZ[1] = f;
        }
        this.rotationScale = 1.0f;
        this.pointerTypes = constMousePointerTypes;
    }

    public MouseEvent(short s, Object object, long l, int n, int[] nArray, int[] nArray2, float[] fArray, float f, PointerType[] pointerTypeArray, short[] sArray, short s2, short s3, float[] fArray2, float f2) {
        super(s, object, l, n);
        this.x = nArray;
        this.y = nArray2;
        if (sArray.length != fArray.length || sArray.length != nArray.length || sArray.length != nArray2.length) {
            throw new IllegalArgumentException("All multiple pointer arrays must be of same size");
        }
        if (0.0f >= f) {
            throw new IllegalArgumentException("maxPressure must be > 0.0f");
        }
        this.pressure = fArray;
        this.maxPressure = f;
        this.pointerIDs = sArray;
        this.clickCount = s2;
        this.button = s3;
        this.rotationXYZ = fArray2;
        this.rotationScale = f2;
        this.pointerTypes = pointerTypeArray;
    }

    public int getPointerCount() {
        return this.x.length;
    }

    public PointerType getPointerType(int n) {
        if (n >= this.pointerIDs.length) {
            return null;
        }
        return this.pointerTypes[n];
    }

    public short getPointerId(int n) {
        if (n >= this.pointerIDs.length) {
            return -1;
        }
        return this.pointerIDs[n];
    }

    public short getButton() {
        return this.button;
    }

    public short getClickCount() {
        return this.clickCount;
    }

    public int getX() {
        return this.x[0];
    }

    public int getY() {
        return this.y[0];
    }

    public int getX(int n) {
        return this.x[n];
    }

    public int getY(int n) {
        return this.y[n];
    }

    public float getPressure(boolean bl) {
        return bl ? this.pressure[0] / this.maxPressure : this.pressure[0];
    }

    public float getMaxPressure() {
        return this.maxPressure;
    }

    public float getPressure(int n, boolean bl) {
        return bl ? this.pressure[n] / this.maxPressure : this.pressure[n];
    }

    public float getWheelRotation() {
        return this.isShiftDown() ? this.rotationXYZ[0] : this.rotationXYZ[1];
    }

    public float[] getRotation() {
        return this.rotationXYZ;
    }

    public float getRotationScale() {
        return this.rotationScale;
    }

    @Override
    public String toString() {
        return this.toString(null).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MouseEvent[").append(MouseEvent.getEventTypeString(this.getEventType())).append(", ").append(this.x).append("/").append(this.y).append(", button ").append(this.button).append(", count ").append(this.clickCount).append(", rotation [").append(this.rotationXYZ[0]).append(", ").append(this.rotationXYZ[1]).append(", ").append(this.rotationXYZ[2]).append("] * ").append(this.rotationScale);
        if (this.pointerIDs.length > 0) {
            stringBuilder.append(", pointer<").append(this.pointerIDs.length).append(">[");
            for (int i = 0; i < this.pointerIDs.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.pointerIDs[i]).append("/").append((Object)this.pointerTypes[i]).append(": ").append(this.x[i]).append("/").append(this.y[i]).append(", ").append("p[").append(this.pressure[i]).append("/").append(this.maxPressure).append("=").append(this.pressure[i] / this.maxPressure).append("]");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 200: {
                return "EVENT_MOUSE_CLICKED";
            }
            case 201: {
                return "EVENT_MOUSE_ENTERED";
            }
            case 202: {
                return "EVENT_MOUSE_EXITED";
            }
            case 203: {
                return "EVENT_MOUSE_PRESSED";
            }
            case 204: {
                return "EVENT_MOUSE_RELEASED";
            }
            case 205: {
                return "EVENT_MOUSE_MOVED";
            }
            case 206: {
                return "EVENT_MOUSE_DRAGGED";
            }
            case 207: {
                return "EVENT_MOUSE_WHEEL_MOVED";
            }
        }
        return "unknown (" + s + ")";
    }

    public static enum PointerType {
        Mouse(PointerClass.Offscreen),
        TouchPad(PointerClass.Offscreen),
        TouchScreen(PointerClass.Onscreen),
        Pen(PointerClass.Onscreen),
        Undefined(PointerClass.Undefined);

        PointerClass pc;

        public PointerClass getPointerClass() {
            return this.pc;
        }

        private PointerType(PointerClass pointerClass) {
            this.pc = pointerClass;
        }
    }

    public static enum PointerClass {
        Offscreen,
        Onscreen,
        Undefined;

    }
}

