/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.newt.event.KeyEvent;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.DisplayDriver;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class WindowDriver
extends WindowImpl
implements MutableSurface,
DriverClearFocus,
DriverUpdatePosition {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;

    @Override
    protected void createNativeImpl() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureFlags(16, true));
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    @Override
    protected void closeNativeImpl() {
        block4: {
            try {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                final long l = this.getWindowHandle();
                this.visibleChanged(true, false);
                this.setWindowHandle(0L);
                this.surfaceHandle = 0L;
                this.sscSurfaceHandle = 0L;
                this.isOffscreenInstance = false;
                if (0L != l) {
                    OSXUtil.RunOnMainThread(false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.close0(l);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG_IMPLEMENTATION) break block4;
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        long l = this.getWindowHandle();
        long l2 = this.surfaceHandle;
        if (0L != l2 && 0L != l) {
            return this.lockSurface0(l, l2) ? 3 : 1;
        }
        return 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        long l = this.getWindowHandle();
        long l2 = this.surfaceHandle;
        if (0L != l && 0L != l2 && !this.unlockSurface0(l, l2)) {
            throw new NativeWindowException("Failed to unlock surface, probably not locked!");
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l));
        }
        this.sscSurfaceHandle = l;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.orderOut0(0L != WindowDriver.this.getParentWindowHandle() ? WindowDriver.this.getParentWindowHandle() : WindowDriver.this.getWindowHandle());
                }
            });
        }
    }

    @Override
    protected void setTitleImpl(final String string) {
        OSXUtil.RunOnMainThread(false, new Runnable(){

            @Override
            public void run() {
                WindowDriver.this.setTitle0(WindowDriver.this.getWindowHandle(), string);
            }
        });
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.requestFocus0(WindowDriver.this.getWindowHandle(), bl);
                }
            });
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus(), isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.resignFocus0(WindowDriver.this.getWindowHandle());
                }
            });
        } else {
            this.focusChanged(false, false);
        }
    }

    private boolean useParent(NativeWindow nativeWindow) {
        return null != nativeWindow && 0L != nativeWindow.getWindowHandle();
    }

    @Override
    public void updatePosition(int n, int n2) {
        final long l = this.getWindowHandle();
        if (0L != l && !this.isOffscreenInstance) {
            NativeWindow nativeWindow = this.getParent();
            boolean bl = this.useParent(nativeWindow);
            int n3 = nativeWindow.getX();
            int n4 = nativeWindow.getY();
            final Point point = this.getLocationOnScreenImpl(n, n2, nativeWindow, bl);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("MacWindow: updatePosition() parent[" + bl + " " + n3 + "/" + n4 + "] " + n + "/" + n2 + " ->  " + n + "/" + n2 + " rel-client-pos, " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(l, point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
            this.positionChanged(true, n, n2);
        }
    }

    @Override
    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        NativeWindow nativeWindow;
        boolean bl3;
        long l = this.getWindowHandle();
        if (0L != l && !this.isOffscreenInstance && (bl3 = this.useParent(nativeWindow = this.getParent())) && (this.getWidth() != n || this.getHeight() != n2)) {
            int n3 = this.getX();
            int n4 = this.getY();
            final Point point = this.getLocationOnScreenImpl(n3, n4, nativeWindow, bl3);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("MacWindow: sizeChanged() parent[" + bl3 + " " + n3 + "/" + n4 + "] " + this.getX() + "/" + this.getY() + " " + n + "x" + n2 + " ->  " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
        }
        super.sizeChanged(bl, n, n2, bl2);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, final int n3, final int n4, int n5) {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3 = WindowDriver.isOffscreenInstance(this, this.getParent());
        boolean bl4 = this.isOffscreenInstance = 0L != this.sscSurfaceHandle || bl3;
        final Point point = this.isOffscreenInstance ? new Point(0, 0) : ((bl2 = this.useParent((NativeWindow)(object = this.getParent()))) ? this.getLocationOnScreenImpl(n, n2, (NativeWindow)object, bl2) : new Point(n, n2));
        if (DEBUG_IMPLEMENTATION) {
            object = this.getGraphicsConfiguration();
            NativeWindow nativeWindow = this.getParent();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = null != nativeWindow ? nativeWindow.getGraphicsConfiguration() : null;
            System.err.println("MacWindow reconfig.0: " + n + "/" + n2 + " -> clientPos " + point + " - " + n3 + "x" + n4 + ",\n\t parent type " + (null != nativeWindow ? nativeWindow.getClass().getName() : null) + ",\n\t   this-chosenCaps " + (null != object ? object.getChosenCapabilities() : null) + ",\n\t parent-chosenCaps " + (null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getChosenCapabilities() : null) + ", isOffscreenInstance(sscSurfaceHandle " + WindowDriver.toHexString(this.sscSurfaceHandle) + ", ioi: " + bl3 + ") -> " + this.isOffscreenInstance + "\n\t, " + WindowDriver.getReconfigureFlagsAsString(null, n5));
        }
        boolean bl5 = bl = 0 != (0x1000 & n5);
        if (0 != (0x10 & n5) && !bl) {
            if (!this.isOffscreenInstance) {
                OSXUtil.RunOnMainThread(false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.orderOut0(WindowDriver.this.getWindowHandle());
                        WindowDriver.this.visibleChanged(true, false);
                    }
                });
            } else {
                this.visibleChanged(true, false);
            }
        }
        if (0L == this.getWindowHandle() && bl || 0 != (2 & n5) || 0 != (1 & n5) || 0 != (4 & n5)) {
            if (this.isOffscreenInstance) {
                this.createWindow(true, 0L != this.getWindowHandle(), point, 64, 64, false, bl, false);
            } else {
                this.createWindow(false, 0L != this.getWindowHandle(), point, n3, n4, 0 != (0x400 & n5), bl, 0 != (0x800 & n5));
            }
        } else {
            if (n3 > 0 && n4 > 0) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.setWindowClientTopLeftPointAndSize0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), n3, n4, bl);
                        }
                    });
                }
                this.positionChanged(true, n, n2);
                this.sizeChanged(true, n3, n4, false);
            }
            if (0 != (0x10 & n5) && bl) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.orderFront0(WindowDriver.this.getWindowHandle());
                            WindowDriver.this.visibleChanged(true, true);
                        }
                    });
                } else {
                    this.visibleChanged(true, true);
                }
            }
            if (!this.isOffscreenInstance) {
                this.setAlwaysOnTop0(this.getWindowHandle(), 0 != (0x800 & n5));
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig.X: clientPos " + point + ", " + n3 + "x" + n4 + " -> clientPos " + this.getLocationOnScreenImpl(0, 0) + ", insets: " + this.getInsets());
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        NativeWindow nativeWindow = this.getParent();
        boolean bl = this.useParent(nativeWindow);
        return this.getLocationOnScreenImpl(n, n2, nativeWindow, bl);
    }

    private Point getLocationOnScreenImpl(int n, int n2, NativeWindow nativeWindow, boolean bl) {
        if (!bl && !this.isOffscreenInstance && 0L != this.surfaceHandle) {
            return OSXUtil.GetLocationOnScreen(this.surfaceHandle, true, n, n2);
        }
        Point point = new Point(n, n2);
        if (bl) {
            point.translate(nativeWindow.getLocationOnScreen(null));
        }
        return point;
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    protected void screenPositionChanged(boolean bl, int n, int n2) {
        if (this.getWindowHandle() != 0L) {
            NativeWindow nativeWindow = this.getParent();
            if (null == nativeWindow || this.isOffscreenInstance) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.0 (Screen Pos - TOP): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2);
                }
                this.positionChanged(bl, n, n2);
            } else {
                Point point = new Point(n, n2);
                Point point2 = nativeWindow.getLocationOnScreen(null);
                point.translate(point2.scale(-1, -1));
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.1 (Screen Pos - CHILD): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> absPos " + n + "/" + n2 + ", parentOnScreen " + point2 + " -> " + point);
                }
                this.positionChanged(bl, point.getX(), point.getY());
            }
        } else if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.positionChanged.2 (Screen Pos - IGN): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2);
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return WindowDriver.setPointerVisible0(this.getWindowHandle(), this.hasFocus(), bl);
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return WindowDriver.confinePointer0(this.getWindowHandle(), bl);
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n, int n2) {
        if (!this.isOffscreenInstance) {
            WindowDriver.warpPointer0(this.getWindowHandle(), n, n2);
        }
    }

    @Override
    public final void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected final void enqueueKeyEvent(boolean bl, short s, int n, short s2, char c, char c2) {
        short s3 = MacKeyUtil.validateKeyCode(s2, c);
        short s4 = '\u0000' != c2 ? KeyEvent.utf16ToVKey(c2) : (short)0;
        short s5 = 0 != s4 ? s4 : s3;
        switch (s) {
            case 301: {
                if (!this.isKeyCodeTracked(s3)) break;
                this.setKeyPressed(s3, false);
                break;
            }
            case 300: {
                if (!this.isKeyCodeTracked(s3) || !this.setKeyPressed(s3, true)) break;
                super.enqueueKeyEvent(bl, (short)301, n |= 0x20000000, s3, s5, c);
            }
        }
        super.enqueueKeyEvent(bl, s, n, s3, s5, c);
    }

    private void createWindow(final boolean bl, boolean bl2, final PointImmutable pointImmutable, final int n, final int n2, final boolean bl3, final boolean bl4, final boolean bl5) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.createWindow on thread " + Thread.currentThread().getName() + ": offscreen " + bl + ", recreate " + bl2 + ", pS " + pointImmutable + ", " + n + "x" + n2 + ", fullscreen " + bl3 + ", visible " + bl4 + ", alwaysOnTop " + bl5);
        }
        try {
            long l;
            final long l2 = this.getParentWindowHandle();
            if (0L != this.getWindowHandle()) {
                l = this.getWindowHandle();
                this.setWindowHandle(0L);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/ window, but no Newt NSView");
                }
                OSXUtil.RunOnMainThread(false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.changeContentView0(l2, l, 0L);
                        WindowDriver.this.close0(l);
                    }
                });
            } else {
                if (0L != this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/o window, but has Newt NSView");
                }
                this.surfaceHandle = this.createView0(pointImmutable.getX(), pointImmutable.getY(), n, n2, bl3, this.getScreen().getIndex());
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Could not create native view " + Thread.currentThread().getName() + " " + this);
                }
            }
            l = this.createWindow0(pointImmutable.getX(), pointImmutable.getY(), n, n2, bl3, this.isUndecorated() || bl ? 0 : 15, 2, this.getScreen().getIndex(), this.surfaceHandle);
            if (l == 0L) {
                throw new NativeWindowException("Could not create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.setWindowHandle(l);
            final boolean bl6 = this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl;
            OSXUtil.RunOnMainThread(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.initWindow0(l2, l, pointImmutable.getX(), pointImmutable.getY(), n, n2, bl6, bl3, bl4 && !bl, WindowDriver.this.getScreen().getIndex(), WindowDriver.this.surfaceHandle);
                    if (bl) {
                        WindowDriver.this.orderOut0(0L != l2 ? l2 : l);
                    } else {
                        WindowDriver.this.setTitle0(l, WindowDriver.this.getTitle());
                        WindowDriver.this.setAlwaysOnTop0(WindowDriver.this.getWindowHandle(), bl5);
                    }
                    WindowDriver.this.visibleChanged(true, bl4);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createView0(int var1, int var2, int var3, int var4, boolean var5, int var6);

    private native long createWindow0(int var1, int var2, int var3, int var4, boolean var5, int var6, int var7, int var8, long var9);

    private native void initWindow0(long var1, long var3, int var5, int var6, int var7, int var8, boolean var9, boolean var10, boolean var11, int var12, long var13);

    private native boolean lockSurface0(long var1, long var3);

    private native boolean unlockSurface0(long var1, long var3);

    private native void requestFocus0(long var1, boolean var3);

    private native void resignFocus0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native void changeContentView0(long var1, long var3, long var5);

    private native void setWindowClientTopLeftPointAndSize0(long var1, int var3, int var4, int var5, int var6, boolean var7);

    private native void setWindowClientTopLeftPoint0(long var1, int var3, int var4, boolean var5);

    private native void setAlwaysOnTop0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native boolean setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native boolean confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }
}

