/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.ScreenDriver;

public class RandR11
implements RandR {
    private static final boolean DEBUG = ScreenDriver.DEBUG;
    private int[] nrotations;
    private int nrotation_index;
    private int nres_number;
    private int nres_index;
    private int[] nrates;
    private int nrate_index;
    private int nmode_number;

    @Override
    public int[] getScreenModeFirstImpl(long l, int n) {
        this.nrotations = RandR11.getAvailableScreenModeRotations0(l, n);
        if (null == this.nrotations || 0 == this.nrotations.length) {
            return null;
        }
        this.nrotation_index = 0;
        this.nres_number = RandR11.getNumScreenModeResolutions0(l, n);
        if (0 == this.nres_number) {
            return null;
        }
        this.nres_index = 0;
        this.nrates = RandR11.getScreenModeRates0(l, n, this.nres_index);
        if (null == this.nrates || 0 == this.nrates.length) {
            return null;
        }
        this.nrate_index = 0;
        this.nmode_number = 0;
        return this.getScreenModeNextImpl(l, n);
    }

    @Override
    public int[] getScreenModeNextImpl(long l, int n) {
        int[] nArray = RandR11.getScreenModeResolution0(l, n, this.nres_index);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (0 >= nArray[0] || 0 >= nArray[1]) {
            throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + this.nres_index + "/" + this.nres_number);
        }
        int n2 = this.nrates[this.nrate_index];
        if (0 >= n2) {
            n2 = 60;
            if (DEBUG) {
                System.err.println("Invalid rate: " + n2 + " at index " + this.nrate_index + "/" + this.nrates.length + ", using default: " + 60);
            }
        }
        int n3 = this.nrotations[this.nrotation_index];
        int[] nArray2 = new int[9];
        int n4 = 0;
        nArray2[n4++] = this.nres_index;
        nArray2[n4++] = 0;
        nArray2[n4++] = nArray[0];
        nArray2[n4++] = nArray[1];
        nArray2[n4++] = 32;
        nArray2[n4++] = nArray[2];
        nArray2[n4++] = nArray[3];
        nArray2[n4++] = n2;
        nArray2[n4++] = n3;
        nArray2[n4 - 8] = n4 - 1;
        ++this.nmode_number;
        ++this.nrotation_index;
        if (this.nrotation_index == this.nrotations.length) {
            this.nrotation_index = 0;
            ++this.nrate_index;
            if (null == this.nrates || this.nrate_index == this.nrates.length) {
                ++this.nres_index;
                if (this.nres_index == this.nres_number) {
                    this.nrates = null;
                    this.nrotations = null;
                    return null;
                }
                this.nrates = RandR11.getScreenModeRates0(l, n, this.nres_index);
                if (null == this.nrates || 0 == this.nrates.length) {
                    return null;
                }
                this.nrate_index = 0;
            }
        }
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenMode getCurrentScreenModeImpl(long l, int n) {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        long l2 = RandR11.getScreenConfiguration0(l, n);
        if (0L == l2) {
            return null;
        }
        try {
            int n5 = RandR11.getNumScreenModeResolutions0(l, n);
            if (0 == n5) {
                ScreenMode screenMode = null;
                return screenMode;
            }
            n4 = RandR11.getCurrentScreenResolutionIndex0(l2);
            if (0 > n4) {
                ScreenMode screenMode = null;
                return screenMode;
            }
            if (n4 >= n5) {
                throw new RuntimeException("Invalid resolution index: ! " + n4 + " < " + n5);
            }
            nArray = RandR11.getScreenModeResolution0(l, n, n4);
            if (null == nArray || 0 == nArray.length) {
                ScreenMode screenMode = null;
                return screenMode;
            }
            if (0 >= nArray[0] || 0 >= nArray[1]) {
                throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n4 + "/" + n5);
            }
            n3 = RandR11.getCurrentScreenRate0(l2);
            if (0 > n3) {
                ScreenMode screenMode = null;
                return screenMode;
            }
            n2 = RandR11.getCurrentScreenRotation0(l2);
            if (0 > n2) {
                ScreenMode screenMode = null;
                return screenMode;
            }
        }
        finally {
            RandR11.freeScreenConfiguration0(l2);
        }
        int[] nArray2 = new int[8];
        n4 = 0;
        nArray2[n4++] = 0;
        nArray2[n4++] = nArray[0];
        nArray2[n4++] = nArray[1];
        nArray2[n4++] = 32;
        nArray2[n4++] = nArray[2];
        nArray2[n4++] = nArray[3];
        nArray2[n4++] = n3;
        nArray2[n4++] = n2;
        nArray2[n4 - 8] = n4;
        return ScreenModeUtil.streamIn(nArray2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentScreenModeImpl(long l, int n, ScreenMode screenMode, int n2, int n3) {
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        long l3 = RandR11.getScreenConfiguration0(l, n);
        if (0L == l3) {
            return bl;
        }
        try {
            int n4;
            int n5 = RandR11.getNumScreenModeResolutions0(l, n);
            if (0 > n3 || n3 >= n5) {
                throw new RuntimeException("Invalid resolution index: ! 0 < " + n3 + " < " + n5 + ", screenMode[" + n2 + "] " + screenMode);
            }
            int n6 = screenMode.getMonitorMode().getRefreshRate();
            if (RandR11.setCurrentScreenModeStart0(l, n, l3, n3, n6, n4 = screenMode.getRotation())) {
                while (!bl && System.currentTimeMillis() - l2 < 10000L) {
                    bl = RandR11.setCurrentScreenModePollEnd0(l, n, n3, n6, n4);
                    if (bl) continue;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            RandR11.freeScreenConfiguration0(l3);
        }
        return bl;
    }

    private static native int[] getAvailableScreenModeRotations0(long var0, int var2);

    private static native int getNumScreenModeResolutions0(long var0, int var2);

    private static native int[] getScreenModeResolution0(long var0, int var2, int var3);

    private static native int[] getScreenModeRates0(long var0, int var2, int var3);

    private static native long getScreenConfiguration0(long var0, int var2);

    private static native void freeScreenConfiguration0(long var0);

    private static native int getCurrentScreenResolutionIndex0(long var0);

    private static native int getCurrentScreenRate0(long var0);

    private static native int getCurrentScreenRotation0(long var0);

    private static native boolean setCurrentScreenModeStart0(long var0, int var2, long var3, int var5, int var6, int var7);

    private static native boolean setCurrentScreenModePollEnd0(long var0, int var2, int var3, int var4, int var5);
}

