/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.ScreenMode;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.RandR11;

public class ScreenDriver
extends ScreenImpl {
    private VersionNumber randrVersion;
    private RandR rAndR;
    private DisplayImpl.DisplayRunnable<Boolean> xineramaEnabledQueryWithTemp = new DisplayImpl.DisplayRunnable<Boolean>(){

        @Override
        public Boolean run(long l) {
            return new Boolean(X11Util.XineramaIsEnabled(l));
        }
    };

    @Override
    protected void createNativeImpl() {
        Long l = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Long>(){

            @Override
            public Long run(long l) {
                return new Long(ScreenDriver.GetScreen0(l, ScreenDriver.this.screen_idx));
            }
        });
        if (l == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)this.getDisplay().getGraphicsDevice();
        long l2 = x11GraphicsDevice.getHandle();
        this.aScreen = new X11GraphicsScreen(x11GraphicsDevice, this.screen_idx);
        int[] nArray = ScreenDriver.getRandRVersion0(l2);
        this.randrVersion = new VersionNumber(nArray[0], nArray[1], 0);
        if (DEBUG) {
            System.err.println("RandR " + this.randrVersion);
        }
        this.rAndR = !this.randrVersion.isZero() ? new RandR11() : null;
    }

    @Override
    protected void closeNativeImpl() {
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        if (null == this.rAndR) {
            return null;
        }
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                return ScreenDriver.this.rAndR.getScreenModeFirstImpl(l, ScreenDriver.this.screen_idx);
            }
        });
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        if (null == this.rAndR) {
            return null;
        }
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                return ScreenDriver.this.rAndR.getScreenModeNextImpl(l, ScreenDriver.this.screen_idx);
            }
        });
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        if (null == this.rAndR) {
            return null;
        }
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<ScreenMode>(){

            @Override
            public ScreenMode run(long l) {
                return ScreenDriver.this.rAndR.getCurrentScreenModeImpl(l, ScreenDriver.this.screen_idx);
            }
        });
    }

    @Override
    protected boolean setCurrentScreenModeImpl(final ScreenMode screenMode) {
        if (null == this.rAndR) {
            return false;
        }
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        final int n = arrayHashSet.indexOf(screenMode);
        if (0 > n) {
            throw new RuntimeException("ScreenMode not element of ScreenMode list: " + screenMode);
        }
        long l = System.currentTimeMillis();
        boolean bl = this.runWithTempDisplayHandle(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                int n2 = ScreenDriver.this.getScreenModesIdx2NativeIdx().get(n);
                return ScreenDriver.this.rAndR.setCurrentScreenModeImpl(l, ScreenDriver.this.screen_idx, screenMode, n, n2);
            }
        });
        if (DEBUG || !bl) {
            System.err.println("X11Screen.setCurrentScreenModeImpl: TO (10000) reached: " + (System.currentTimeMillis() - l) + "ms; Current: " + this.getCurrentScreenMode() + "; Desired: " + screenMode);
        }
        return bl;
    }

    @Override
    protected int validateScreenIndex(int n) {
        DisplayDriver displayDriver = (DisplayDriver)this.getDisplay();
        Boolean bl = displayDriver.isXineramaEnabled();
        if (null != bl) {
            return bl != false ? 0 : n;
        }
        return this.runWithTempDisplayHandle(this.xineramaEnabledQueryWithTemp) != false ? 0 : n;
    }

    @Override
    protected void getVirtualScreenOriginAndSize(final Point point, final Dimension dimension) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                point.setX(0);
                point.setY(0);
                dimension.setWidth(ScreenDriver.getWidth0(l, ScreenDriver.this.screen_idx));
                dimension.setHeight(ScreenDriver.getHeight0(l, ScreenDriver.this.screen_idx));
                return null;
            }
        });
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return this.display.runWithLockedDisplayDevice(displayRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTempDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        T t;
        long l = X11Util.openDisplay(this.display.getName());
        if (0L == l) {
            throw new RuntimeException("null device");
        }
        try {
            t = displayRunnable.run(l);
        }
        finally {
            X11Util.closeDisplay(l);
        }
        return t;
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getRandRVersion0(long var0);

    static {
        DisplayDriver.initSingleton();
    }
}

