/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXExt;
import jogamp.opengl.x11.glx.GLXExtImpl;
import jogamp.opengl.x11.glx.GLXExtProcAddressTable;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXContext
extends GLContextImpl {
    private static final Map<String, String> functionNameMap = new HashMap<String, String>();
    private static final Map<String, String> extensionNameMap;
    private GLXExt _glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    private int hasSwapInterval = 0;
    private int hasSwapGroupNV = 0;
    protected boolean isDirect;
    protected volatile VersionNumber glXServerVersion;
    protected volatile boolean isGLXVersionGreaterEqualOneThree;
    private static final int ctx_arb_attribs_idx_major = 0;
    private static final int ctx_arb_attribs_idx_minor = 2;
    private static final int ctx_arb_attribs_idx_flags = 6;
    private static final int ctx_arb_attribs_idx_profile = 8;
    private static final int[] ctx_arb_attribs_rom;

    X11GLXContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates() {
        this.glXExtProcAddressTable = null;
        this.hasSwapInterval = 0;
        this.hasSwapGroupNV = 0;
        this.isDirect = false;
        this.glXServerVersion = null;
        this.isGLXVersionGreaterEqualOneThree = false;
        super.resetStates();
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getGLXExtProcAddressTable();
    }

    public final GLXExtProcAddressTable getGLXExtProcAddressTable() {
        return this.glXExtProcAddressTable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this._glXExt == null) {
            this._glXExt = new GLXExtImpl(this);
        }
        return this._glXExt;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return functionNameMap;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return extensionNameMap;
    }

    protected final boolean isGLXVersionGreaterEqualOneThree() {
        if (null != this.glXServerVersion) {
            return this.isGLXVersionGreaterEqualOneThree;
        }
        this.glXServerVersion = ((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).getGLXVersionNumber(this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice());
        this.isGLXVersionGreaterEqualOneThree = null != this.glXServerVersion ? this.glXServerVersion.compareTo(X11GLXDrawableFactory.versionOneThree) >= 0 : false;
        return this.isGLXVersionGreaterEqualOneThree;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return this.isGLXVersionGreaterEqualOneThree();
    }

    private final boolean glXMakeContextCurrent(long l, long l2, long l3, long l4) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (this.isGLXVersionGreaterEqualOneThree()) {
                    bl = GLX.glXMakeContextCurrent(l, l2, l3, l4);
                    break block4;
                }
                if (l2 == l3) {
                    bl = GLX.glXMakeCurrent(l, l2, l4);
                    break block4;
                }
                throw new InternalError("Given readDrawable but no driver support");
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG_TRACE_SWITCH) break block4;
                System.err.println(X11GLXContext.getThreadName() + ": Warning: X11GLXContext.glXMakeContextCurrent failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l) + ", write " + X11GLXContext.toHexString(l2) + ", read " + X11GLXContext.toHexString(l3) + ", ctx " + X11GLXContext.toHexString(l4));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        long l2 = this.drawable.getNativeSurface().getDisplayHandle();
        this.glXMakeContextCurrent(l2, 0L, 0L, 0L);
        GLX.glXDestroyContext(l2, l);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        long l3;
        block16: {
            this.updateGLXProcAddressTable();
            GLXExt gLXExt = this.getGLXExt();
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl: " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", share " + X11GLXContext.toHexString(l) + ", direct " + bl + ", glXCreateContextAttribsARB: " + X11GLXContext.toHexString(this.glXExtProcAddressTable._addressof_glXCreateContextAttribsARB));
            }
            boolean bl2 = 0 != (2 & n);
            boolean bl3 = 0 != (0x10 & n);
            boolean bl4 = 0 != (0x20 & n);
            l3 = 0L;
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])ctx_arb_attribs_rom);
            intBuffer.put(1, n2);
            intBuffer.put(3, n3);
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                intBuffer.put(8, 37158);
                if (bl2) {
                    intBuffer.put(9, 2);
                } else {
                    intBuffer.put(9, 1);
                }
            }
            if (n2 >= 3) {
                int n4 = intBuffer.get(7);
                if (!bl2 && bl3) {
                    n4 |= 2;
                }
                if (bl4) {
                    n4 |= 1;
                }
                intBuffer.put(7, n4);
            }
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
            l2 = abstractGraphicsDevice.getHandle();
            try {
                X11Util.setX11ErrorHandler(true, !DEBUG);
                X11Lib.XSync(l2, false);
                l3 = gLXExt.glXCreateContextAttribsARB(l2, x11GLXGraphicsConfiguration.getFBConfig(), l, bl, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block16;
                Throwable throwable = new Throwable(X11GLXContext.getThreadName() + ": Info: X11GLXContext.createContextARBImpl glXCreateContextAttribsARB failed with " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"), runtimeException);
                throwable.printStackTrace();
            }
        }
        if (0L != l3) {
            if (!this.glXMakeContextCurrent(l2, this.drawable.getHandle(), this.drawableRead.getHandle(), l3)) {
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl couldn't make current " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.glXMakeContextCurrent(l2, 0L, 0L, 0L);
                GLX.glXDestroyContext(l2, l3);
                l3 = 0L;
            } else if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: OK " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: NO " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l3;
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) {
        long l;
        long l2;
        boolean bl = true;
        this.isDirect = false;
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)this.drawable.getFactoryImpl();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
        X11GLXContext x11GLXContext = (X11GLXContext)x11GLXDrawableFactory.getOrCreateSharedContext(abstractGraphicsDevice);
        long l3 = abstractGraphicsDevice.getHandle();
        if (null != gLContextImpl) {
            l2 = gLContextImpl.getHandle();
            if (l2 == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            bl = GLX.glXIsDirect(l3, l2);
        } else {
            l2 = 0L;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (x11GLXGraphicsConfiguration.getFBConfigID() < 0) {
            if (gLProfile.isGL3()) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create OpenGL >= 3.1 context");
            }
            this.contextHandle = GLX.glXCreateContext(l3, x11GLXGraphicsConfiguration.getXVisualInfo(), l2, bl);
            if (0L == this.contextHandle) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create context(0)");
            }
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(0) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true, 0, 0, 2, false);
            this.isDirect = GLX.glXIsDirect(l3, this.contextHandle);
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (old-1) share " + l2 + ", direct " + this.isDirect + "/" + bl);
            }
            return true;
        }
        boolean bl2 = false;
        if (null != x11GLXContext && x11GLXContext.isCreatedWithARBMethod()) {
            this.contextHandle = this.createContextARB(l2, bl);
            bl2 = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (ARB, using sharedContext) share " + l2);
            }
        }
        if (0L == this.contextHandle) {
            l = GLX.glXCreateNewContext(l3, x11GLXGraphicsConfiguration.getFBConfig(), 32788, l2, bl);
            if (0L == l) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create temp OpenGL context(1)");
            }
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), l)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(1) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(l) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true, 0, 0, 2, false);
            this.glXMakeContextCurrent(l3, 0L, 0L, 0L);
            if (!bl2) {
                boolean bl3 = this.isFunctionAvailable("glXCreateContextAttribsARB");
                boolean bl4 = this.isExtensionAvailable("GLX_ARB_create_context");
                if (bl3 && bl4) {
                    this.contextHandle = this.createContextARB(l2, bl);
                    bl2 = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (ARB, initial) share " + l2);
                        } else {
                            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - creation failed - share " + l2);
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - extension not available - share " + l2 + ", isProcCreateContextAttribsARBAvailable " + bl3 + ", isExtGLXARBCreateContextAvailable " + bl4);
                }
            }
        } else {
            l = 0L;
        }
        if (0L != this.contextHandle) {
            if (0L != l) {
                this.glXMakeContextCurrent(l3, 0L, 0L, 0L);
                GLX.glXDestroyContext(l3, l);
                if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException(X11GLXContext.getThreadName() + ": Cannot make previous verified context current");
                }
            }
        } else {
            if (gLProfile.isGL3()) {
                this.glXMakeContextCurrent(l3, 0L, 0L, 0L);
                GLX.glXDestroyContext(l3, l);
                throw new GLException(X11GLXContext.getThreadName() + ": X11GLXContext.createContextImpl ctx !ARB, profile > GL2 requested (OpenGL >= 3.0.1). Requested: " + gLProfile + ", current: " + this.getGLVersion());
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextImpl failed, fall back to !ARB context " + this.getGLVersion());
            }
            this.contextHandle = l;
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                this.glXMakeContextCurrent(l3, 0L, 0L, 0L);
                GLX.glXDestroyContext(l3, l);
                throw new GLException(X11GLXContext.getThreadName() + ": Error making context(1) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (old-2) share " + l2);
            }
        }
        this.isDirect = GLX.glXIsDirect(l3, this.contextHandle);
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK direct " + this.isDirect + "/" + bl);
        }
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (GLX.glXGetCurrentContext() != this.contextHandle && !this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + X11GLXContext.toHexString(this.contextHandle) + " current on Thread " + X11GLXContext.getThreadName() + " with display " + X11GLXContext.toHexString(l) + ", drawableWrite " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + X11GLXContext.toHexString(this.drawableRead.getHandle()) + " - " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (!this.glXMakeContextCurrent(l, 0L, 0L, 0L)) {
            throw new GLException(X11GLXContext.getThreadName() + ": Error freeing OpenGL context");
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        this.destroyContextARBImpl(this.contextHandle);
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        long l = this.getHandle();
        long l2 = gLContext.getHandle();
        long l3 = this.drawable.getNativeSurface().getDisplayHandle();
        if (0L == l3) {
            throw new GLException(X11GLXContext.getThreadName() + ": Connection to X display not yet set up");
        }
        GLX.glXCopyContext(l3, l2, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "GLX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": Initializing GLX extension address table: " + string);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.glXExtProcAddressTable = (GLXExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable reusing key(" + string + ") -> " + X11GLXContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getGLXExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getGLXExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable mapping key(" + string + ") -> " + X11GLXContext.toHexString(((Object)((Object)this.getGLXExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        NativeSurface nativeSurface = this.drawable.getNativeSurface();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        StringBuilder stringBuilder = new StringBuilder();
        x11GraphicsDevice.lock();
        try {
            if (DEBUG) {
                System.err.println("GLX Version client version " + GLXUtil.getClientVersionNumber() + ", server: " + GLXUtil.getGLXServerVersionNumber(x11GraphicsDevice));
            }
            if (((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).isGLXVersionGreaterEqualOneOne(x11GraphicsDevice)) {
                String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXGetClientString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryExtensionsString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex());
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryExtensionsString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryServerString): " + string);
                }
                stringBuilder.append(string).append(" ");
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        return stringBuilder;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return this.getGLDrawable().getFactory().canCreateGLPbuffer(this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice());
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        if (!this.drawable.getChosenGLCapabilities().isOnscreen()) {
            return false;
        }
        GLXExt gLXExt = this.getGLXExt();
        if (0 == this.hasSwapInterval) {
            try {
                if (gLXExt.isExtensionAvailable("GLX_SGI_swap_control")) {
                    if (DEBUG) {
                        System.err.println("X11GLXContext.setSwapInterval using: GLX_SGI_swap_control");
                    }
                    this.hasSwapInterval = 2;
                } else {
                    this.hasSwapInterval = -1;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapInterval = -1;
            }
        }
        if (2 == this.hasSwapInterval) {
            try {
                return 0 == gLXExt.glXSwapIntervalSGI(n);
            }
            catch (Throwable throwable) {
                this.hasSwapInterval = -1;
            }
        }
        return false;
    }

    private final int initSwapGroupImpl(GLXExt gLXExt) {
        if (0 == this.hasSwapGroupNV) {
            try {
                this.hasSwapGroupNV = gLXExt.isExtensionAvailable("GLX_NV_swap_group") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = 1;
            }
            if (DEBUG) {
                System.err.println("initSwapGroupImpl: GLX_NV_swap_group: " + this.hasSwapGroupNV);
            }
        }
        return this.hasSwapGroupNV;
    }

    @Override
    protected final boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)(nArray.length - n));
                IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)(nArray2.length - n2));
                if (gLXExt.glXQueryMaxSwapGroupsNV(nativeSurface.getDisplayHandle(), nativeSurface.getScreenIndex(), intBuffer, intBuffer2)) {
                    intBuffer.get(nArray, n, intBuffer.remaining());
                    intBuffer2.get(nArray, n, intBuffer2.remaining());
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean joinSwapGroupImpl(int n) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXJoinSwapGroupNV(this.drawable.getNativeSurface().getDisplayHandle(), this.drawable.getHandle(), n)) {
                    this.currentSwapGroup = n;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean bindSwapBarrierImpl(int n, int n2) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXBindSwapBarrierNV(this.drawable.getNativeSurface().getDisplayHandle(), n, n2)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getGLXExt().glXAllocateMemoryNV(n, f, f2, f3);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", direct ");
        stringBuilder.append(this.isDirect);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
        extensionNameMap = new HashMap<String, String>();
        extensionNameMap.put("GL_ARB_pbuffer", "GLX_SGIX_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "GLX_SGIX_pbuffer");
        ctx_arb_attribs_rom = new int[]{8337, 0, 8338, 0, 32785, 32788, 8340, 0, 0, 0, 0};
    }
}

