/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.PrintWriter;
import java.util.HashMap;
import processing.core.PApplet;
import processing.data.Sort;

public class IntHash {
    protected int count;
    protected String[] keys;
    protected int[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public IntHash() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new int[10];
    }

    public IntHash(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new int[length];
    }

    public IntHash(String[] k, int[] v) {
        this.count = Math.min(k.length, v.length);
        this.keys = new String[this.count];
        this.values = new int[this.count];
        System.arraycopy(k, 0, this.keys, 0, this.count);
        System.arraycopy(v, 0, this.values, 0, this.count);
    }

    public static IntHash fromTally(String[] list) {
        IntHash outgoing = new IntHash();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            outgoing.increment(s);
            ++n2;
        }
        outgoing.crop();
        return outgoing;
    }

    public static IntHash fromOrder(String[] list) {
        IntHash outgoing = new IntHash();
        int i = 0;
        while (i < list.length) {
            outgoing.set(list[i], i);
            ++i;
        }
        return outgoing;
    }

    public IntHash(PApplet parent, String filename) {
        String[] lines = parent.loadStrings(filename);
        this.keys = new String[lines.length];
        this.values = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = PApplet.parseInt(pieces[1]);
                ++this.count;
            }
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public String[] keys() {
        this.crop();
        return this.keys;
    }

    public String[] keyArray() {
        String[] outgoing = new String[this.count];
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public int value(int index) {
        return this.values[index];
    }

    public int[] values() {
        this.crop();
        return this.values;
    }

    public int[] valueArray() {
        int[] outgoing = new int[this.count];
        System.arraycopy(this.values, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public int get(String what) {
        int index = this.index(what);
        if (index == -1) {
            return 0;
        }
        return this.values[index];
    }

    public void set(String who, int amount) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public void add(String who, int amount) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + amount;
        }
    }

    public void increment(String who) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, 1);
        } else {
            int n = index;
            this.values[n] = this.values[n] + 1;
        }
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, int much) {
        if (this.count == this.keys.length) {
            String[] ktemp = new String[this.count << 1];
            System.arraycopy(this.keys, 0, ktemp, 0, this.count);
            this.keys = ktemp;
            int[] vtemp = new int[this.count << 1];
            System.arraycopy(this.values, 0, vtemp, 0, this.count);
            this.values = vtemp;
        }
        this.indices.put(what, new Integer(this.count));
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public void print() {
        this.write(new PrintWriter(System.out));
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public void remove(String which) {
        this.removeIndex(this.index(which));
    }

    public void removeIndex(int which) {
        this.indices.remove(this.keys[which]);
        int i = which;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0;
    }

    protected void swap(int a, int b) {
        String tkey = this.keys[a];
        int tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        Sort s = new Sort(){

            @Override
            public int size() {
                return IntHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int result = IntHash.this.keys[a].compareToIgnoreCase(IntHash.this.keys[b]);
                if (result != 0) {
                    return result;
                }
                return IntHash.this.values[b] - IntHash.this.values[a];
            }

            @Override
            public void swap(int a, int b) {
                IntHash.this.swap(a, b);
            }
        };
        s.run();
    }

    public void sortValues() {
        this.sortValues(true);
    }

    public void sortValues(final boolean descending) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return IntHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int diff = IntHash.this.values[b] - IntHash.this.values[a];
                if (diff == 0) {
                    diff = IntHash.this.keys[a].compareToIgnoreCase(IntHash.this.keys[b]);
                }
                return descending ? diff : -diff;
            }

            @Override
            public void swap(int a, int b) {
                IntHash.this.swap(a, b);
            }
        };
        s.run();
    }
}

