/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.util.Vector;
import netP5.NetListener;
import netP5.NetMessage;
import netP5.NetStatus;
import netP5.TcpPacket;

class NetPlug {
    protected boolean isEventMethod = false;
    protected Method _myEventMethod;
    protected String _myEventMethodName = "netEvent";
    protected boolean isStatusMethod = false;
    protected Method _myStatusMethod;
    protected String _myStatusMethodName = "netStatus";
    protected Class _myParentClass;
    protected Object _myParent;
    protected Vector _myNetListeners;
    protected boolean isNetListener;

    protected NetPlug(Object object) {
        this._myParent = object;
        this._myNetListeners = new Vector();
        this.checkMethod();
    }

    protected void invoke(Object object, Method method, Object[] objectArray) {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("NetP5 ClassCastException. parsing failed for NetMessage " + invocationTargetException);
        }
    }

    protected void checkMethod() {
        try {
            this.checkEventMethod();
            this.checkStatusMethod();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkEventMethod() {
        this._myParentClass = this._myParent.getClass();
        if (this._myEventMethodName != null) {
            try {
                this._myEventMethod = this._myParentClass.getDeclaredMethod(this._myEventMethodName, NetMessage.class);
                this.isEventMethod = true;
                this._myEventMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("### NOTE. no netEvent(NetMessage theMessage) method available.");
            }
        }
        return this._myEventMethod != null;
    }

    private boolean checkStatusMethod() {
        this._myParentClass = this._myParent.getClass();
        if (this._myStatusMethodName != null) {
            try {
                this._myStatusMethod = this._myParentClass.getDeclaredMethod(this._myStatusMethodName, NetStatus.class);
                this.isStatusMethod = true;
                this._myStatusMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this._myStatusMethod != null;
    }

    public void process(DatagramPacket datagramPacket, int n) {
        if (this.isNetListener || this.isEventMethod) {
            NetMessage netMessage = new NetMessage(datagramPacket);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netEvent(netMessage);
            }
            if (this.isEventMethod) {
                try {
                    this.invoke(this._myParent, this._myEventMethod, new Object[]{netMessage});
                }
                catch (ClassCastException classCastException) {
                    System.out.println("ChatP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    public void status(int n) {
        if (this.isNetListener || this.isEventMethod) {
            NetStatus netStatus = new NetStatus(n);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netStatus(netStatus);
            }
            if (this.isStatusMethod) {
                try {
                    this.invoke(this._myParent, this._myStatusMethod, new Object[]{netStatus});
                }
                catch (ClassCastException classCastException) {
                    System.out.println("ChatP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    public void process(TcpPacket tcpPacket, int n) {
        if (this.isNetListener || this.isEventMethod) {
            NetMessage netMessage = new NetMessage(tcpPacket);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netEvent(netMessage);
            }
            if (this.isEventMethod) {
                try {
                    this.invoke(this._myParent, this._myEventMethod, new Object[]{netMessage});
                }
                catch (ClassCastException classCastException) {
                    System.out.println("NetP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    protected void addListener(NetListener netListener) {
        this._myNetListeners.add(netListener);
        this.isNetListener = true;
    }

    protected void removeListener(NetListener netListener) {
        this._myNetListeners.remove(netListener);
        this.isNetListener = this._myNetListeners.size() > 0;
    }

    protected NetListener getListener(int n) {
        return (NetListener)this._myNetListeners.get(n);
    }

    protected Vector getListeners() {
        return this._myNetListeners;
    }
}

