/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.util;

import javax.media.nativewindow.util.PointImmutable;

public class Point
implements Cloneable,
PointImmutable {
    int x;
    int y;

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point() {
        this(0, 0);
    }

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.y == point.y && this.x == point.x;
        }
        return false;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.x;
        n = (n << 5) - n + this.y;
        return n;
    }

    public String toString() {
        return new String(this.x + " / " + this.y);
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public Point translate(Point point) {
        this.x += point.x;
        this.y += point.y;
        return this;
    }

    public Point translate(int n, int n2) {
        this.x += n;
        this.y += n2;
        return this;
    }

    public Point scale(int n, int n2) {
        this.x *= n;
        this.y *= n2;
        return this;
    }
}

