/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.util.Function;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.DisplayDriver;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class WindowDriver
extends WindowImpl
implements MutableSurface,
DriverClearFocus,
DriverUpdatePosition {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;

    @Override
    protected void createNativeImpl() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureFlags(16, true));
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    @Override
    protected void closeNativeImpl() {
        block4: {
            try {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                final long l = this.getWindowHandle();
                this.setWindowHandle(0L);
                this.surfaceHandle = 0L;
                this.sscSurfaceHandle = 0L;
                this.isOffscreenInstance = false;
                if (0L != l) {
                    OSXUtil.RunOnMainThread(true, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.close0(l);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG_IMPLEMENTATION) break block4;
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        if (!this.isOffscreenInstance) {
            return this.lockSurface0(this.getWindowHandle()) ? 3 : 1;
        }
        return 3;
    }

    @Override
    protected void unlockSurfaceImpl() {
        long l;
        if (!this.isOffscreenInstance && 0L != (l = this.getWindowHandle())) {
            this.unlockSurface0(l);
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l));
        }
        this.sscSurfaceHandle = l;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            this.orderOut0(0L != this.getParentWindowHandle() ? this.getParentWindowHandle() : this.getWindowHandle());
        }
    }

    @Override
    protected void setTitleImpl(String string) {
        this.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            this.requestFocus0(this.getWindowHandle(), bl);
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus(), isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            this.resignFocus0(this.getWindowHandle());
        } else {
            this.focusChanged(false, false);
        }
    }

    @Override
    public void updatePosition() {
        Point point = this.getLocationOnScreenImpl(0, 0);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: updatePosition() - isOffscreenInstance " + this.isOffscreenInstance + ", new abs pos: pS " + point);
        }
        if (!this.isOffscreenInstance) {
            this.setWindowClientTopLeftPoint0(this.getWindowHandle(), point.getX(), point.getY());
        }
        this.positionChanged(true, point.getX(), point.getY());
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        boolean bl = WindowDriver.isOffscreenInstance(this, this.getParent());
        this.isOffscreenInstance = 0L != this.sscSurfaceHandle || bl;
        Point point = this.isOffscreenInstance ? new Point(0, 0) : new Point(n, n2);
        if (DEBUG_IMPLEMENTATION) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.getGraphicsConfiguration();
            NativeWindow nativeWindow = this.getParent();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = null != nativeWindow ? nativeWindow.getGraphicsConfiguration() : null;
            System.err.println("MacWindow reconfig.0: " + n + "/" + n2 + " -> clientPos " + point + " - " + n3 + "x" + n4 + ",\n\t parent type " + (null != nativeWindow ? nativeWindow.getClass().getName() : null) + ",\n\t   this-chosenCaps " + (null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getChosenCapabilities() : null) + ",\n\t parent-chosenCaps " + (null != abstractGraphicsConfiguration2 ? abstractGraphicsConfiguration2.getChosenCapabilities() : null) + ", isOffscreenInstance(sscSurfaceHandle " + WindowDriver.toHexString(this.sscSurfaceHandle) + ", ioi: " + bl + ") -> " + this.isOffscreenInstance + "\n\t, " + WindowDriver.getReconfigureFlagsAsString(null, n5));
        }
        if (0 != (0x10 & n5) && 0 == (0x1000 & n5)) {
            if (!this.isOffscreenInstance) {
                this.orderOut0(this.getWindowHandle());
            }
            this.visibleChanged(true, false);
        }
        if (0L == this.getWindowHandle() && 0 != (0x1000 & n5) || 0 != (2 & n5) || 0 != (1 & n5) || 0 != (4 & n5)) {
            if (this.isOffscreenInstance) {
                this.createWindow(true, 0L != this.getWindowHandle(), point, 64, 64, false);
            } else {
                this.createWindow(false, 0L != this.getWindowHandle(), point, n3, n4, 0 != (0x400 & n5));
            }
            if (this.isVisible()) {
                n5 |= 0x10;
            }
        }
        if (n3 > 0 && n4 > 0 && n >= 0 && n2 >= 0) {
            if (!this.isOffscreenInstance) {
                this.setWindowClientTopLeftPointAndSize0(this.getWindowHandle(), point.getX(), point.getY(), n3, n4);
            }
            this.positionChanged(true, n, n2);
            this.sizeChanged(true, n3, n4, false);
        }
        if (0 != (0x10 & n5) && 0 != (0x1000 & n5)) {
            if (!this.isOffscreenInstance) {
                this.orderFront0(this.getWindowHandle());
            }
            this.visibleChanged(true, true);
        }
        if (!this.isOffscreenInstance) {
            this.setAlwaysOnTop0(this.getWindowHandle(), 0 != (0x800 & n5));
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig.X: clientPos " + point + ", " + n3 + "x" + n4 + " -> clientPos " + this.getLocationOnScreenImpl(0, 0) + ", topPos " + this.getTopLevelLocationOnScreen(0, 0) + ", insets: " + this.getInsets());
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        boolean bl;
        NativeWindow nativeWindow = this.getParent();
        boolean bl2 = bl = null != nativeWindow && 0L != nativeWindow.getWindowHandle();
        if (!bl && !this.isOffscreenInstance && 0L != this.surfaceHandle) {
            return OSXUtil.GetLocationOnScreen(this.surfaceHandle, true, n, n2);
        }
        Point point = new Point(n, n2);
        point.setX(Math.max(point.getX(), 0));
        point.setY(Math.max(point.getY(), 0));
        if (bl) {
            point.translate(nativeWindow.getLocationOnScreen(null));
        }
        return point;
    }

    private Point getTopLevelLocationOnScreen(int n, int n2) {
        InsetsImmutable insetsImmutable = this.getInsets();
        return this.getLocationOnScreenImpl(n -= insetsImmutable.getLeftWidth(), n2 -= insetsImmutable.getTopHeight());
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    protected void screenPositionChanged(boolean bl, int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.positionChanged (Screen Pos): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2);
        }
        if (this.getWindowHandle() != 0L) {
            NativeWindow nativeWindow = this.getParent();
            if (null == nativeWindow) {
                this.positionChanged(bl, n, n2);
            } else {
                Point point = new Point(n, n2);
                point.translate(nativeWindow.getLocationOnScreen(null).scale(-1, -1));
                this.positionChanged(bl, point.getX(), point.getY());
            }
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return WindowDriver.setPointerVisible0(this.getWindowHandle(), this.hasFocus(), bl);
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            return WindowDriver.confinePointer0(this.getWindowHandle(), bl);
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n, int n2) {
        if (!this.isOffscreenInstance) {
            WindowDriver.warpPointer0(this.getWindowHandle(), n, n2);
        }
    }

    @Override
    public final void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        short s4 = MacKeyUtil.validateKeyCode(s2, c);
        switch (s) {
            case 301: {
                if (!this.isKeyCodeTracked(s4)) break;
                this.keyRepeatState.put((long)s4, false);
                this.keyPressedState.put((long)s4, false);
                break;
            }
            case 300: {
                if (!this.isKeyCodeTracked(s4) || !this.keyPressedState.put((long)s4, true)) break;
                this.keyRepeatState.put((long)s4, true);
                super.enqueueKeyEvent(bl, (short)301, n |= 0x20000000, s4, s4, c);
            }
        }
        super.enqueueKeyEvent(bl, s, n, s4, s4, c);
    }

    private void createWindow(final boolean bl, boolean bl2, final PointImmutable pointImmutable, final int n, final int n2, final boolean bl3) {
        if (0L != this.getWindowHandle() && !bl2) {
            return;
        }
        try {
            if (0L != this.getWindowHandle()) {
                this.surfaceHandle = OSXUtil.RunOnMainThread(true, new Function<Long, Object>(){

                    public Long eval(Object ... objectArray) {
                        return WindowDriver.this.changeContentView0(WindowDriver.this.getParentWindowHandle(), WindowDriver.this.getWindowHandle(), 0L);
                    }
                }, new Object[0]);
                if (bl2 && 0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - recreate, window but no view");
                }
                OSXUtil.RunOnMainThread(true, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.close0(WindowDriver.this.getWindowHandle());
                    }
                });
                this.setWindowHandle(0L);
            } else {
                this.surfaceHandle = 0L;
            }
            this.setWindowHandle(OSXUtil.RunOnMainThread(true, new Function<Long, Object>(){

                public Long eval(Object ... objectArray) {
                    return WindowDriver.this.createWindow0(WindowDriver.this.getParentWindowHandle(), pointImmutable.getX(), pointImmutable.getY(), n, n2, WindowDriver.this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl, bl3, WindowDriver.this.isUndecorated() || bl ? 0 : 15, 2, WindowDriver.this.getScreen().getIndex(), WindowDriver.this.surfaceHandle);
                }
            }, new Object[0]));
            if (this.getWindowHandle() == 0L) {
                throw new NativeWindowException("Could create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.surfaceHandle = this.contentView0(this.getWindowHandle());
            if (bl) {
                this.orderOut0(0L != this.getParentWindowHandle() ? this.getParentWindowHandle() : this.getWindowHandle());
            } else {
                this.setTitle0(this.getWindowHandle(), this.getTitle());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createWindow0(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9, int var10, int var11, long var12);

    private native boolean lockSurface0(long var1);

    private native void unlockSurface0(long var1);

    private native void requestFocus0(long var1, boolean var3);

    private native void resignFocus0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native long changeContentView0(long var1, long var3, long var5);

    private native void setWindowClientTopLeftPointAndSize0(long var1, int var3, int var4, int var5, int var6);

    private native void setWindowClientTopLeftPoint0(long var1, int var3, int var4);

    private native void setAlwaysOnTop0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native boolean setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native boolean confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }
}

