/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.x11.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    private int[] nrotations;
    private int nrotation_index;
    private int nres_number;
    private int nres_index;
    private int[] nrates;
    private int nrate_index;
    private int nmode_number;
    private DisplayImpl.DisplayRunnable<Boolean> xineramaEnabledQueryWithTemp = new DisplayImpl.DisplayRunnable<Boolean>(){

        @Override
        public Boolean run(long l) {
            return new Boolean(X11Util.XineramaIsEnabled(l));
        }
    };

    @Override
    protected void createNativeImpl() {
        Long l = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Long>(){

            @Override
            public Long run(long l) {
                return new Long(ScreenDriver.GetScreen0(l, ScreenDriver.this.screen_idx));
            }
        });
        if (l == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        this.aScreen = new X11GraphicsScreen((X11GraphicsDevice)this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                ScreenDriver.access$202(ScreenDriver.this, ScreenDriver.getAvailableScreenModeRotations0(l, ScreenDriver.this.screen_idx));
                if (null == ScreenDriver.this.nrotations || 0 == ScreenDriver.this.nrotations.length) {
                    return null;
                }
                ScreenDriver.this.nrotation_index = 0;
                ScreenDriver.this.nres_number = ScreenDriver.getNumScreenModeResolutions0(l, ScreenDriver.this.screen_idx);
                if (0 == ScreenDriver.this.nres_number) {
                    return null;
                }
                ScreenDriver.this.nres_index = 0;
                ScreenDriver.access$1002(ScreenDriver.this, ScreenDriver.getScreenModeRates0(l, ScreenDriver.this.screen_idx, ScreenDriver.this.nres_index));
                if (null == ScreenDriver.this.nrates || 0 == ScreenDriver.this.nrates.length) {
                    return null;
                }
                ScreenDriver.this.nrate_index = 0;
                ScreenDriver.this.nmode_number = 0;
                return ScreenDriver.this.getScreenModeNextImpl();
            }
        });
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                int[] nArray = ScreenDriver.getScreenModeResolution0(l, ScreenDriver.this.screen_idx, ScreenDriver.this.nres_index);
                if (null == nArray || 0 == nArray.length) {
                    return null;
                }
                if (0 >= nArray[0] || 0 >= nArray[1]) {
                    throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + ScreenDriver.this.nres_index + "/" + ScreenDriver.this.nres_number);
                }
                int n = ScreenDriver.this.nrates[ScreenDriver.this.nrate_index];
                if (0 >= n) {
                    n = 60;
                    if (Screen.DEBUG) {
                        System.err.println("Invalid rate: " + n + " at index " + ScreenDriver.this.nrate_index + "/" + ScreenDriver.this.nrates.length + ", using default: " + 60);
                    }
                }
                int n2 = ScreenDriver.this.nrotations[ScreenDriver.this.nrotation_index];
                int[] nArray2 = new int[9];
                int n3 = 0;
                nArray2[n3++] = ScreenDriver.this.nres_index;
                nArray2[n3++] = 0;
                nArray2[n3++] = nArray[0];
                nArray2[n3++] = nArray[1];
                nArray2[n3++] = 32;
                nArray2[n3++] = nArray[2];
                nArray2[n3++] = nArray[3];
                nArray2[n3++] = n;
                nArray2[n3++] = n2;
                nArray2[n3 - 8] = n3 - 1;
                ScreenDriver.this.nmode_number++;
                ScreenDriver.this.nrotation_index++;
                if (ScreenDriver.this.nrotation_index == ScreenDriver.this.nrotations.length) {
                    ScreenDriver.this.nrotation_index = 0;
                    ScreenDriver.this.nrate_index++;
                    if (null == ScreenDriver.this.nrates || ScreenDriver.this.nrate_index == ScreenDriver.this.nrates.length) {
                        ScreenDriver.this.nres_index++;
                        if (ScreenDriver.this.nres_index == ScreenDriver.this.nres_number) {
                            ScreenDriver.access$1002(ScreenDriver.this, null);
                            ScreenDriver.access$202(ScreenDriver.this, null);
                            return null;
                        }
                        ScreenDriver.access$1002(ScreenDriver.this, ScreenDriver.getScreenModeRates0(l, ScreenDriver.this.screen_idx, ScreenDriver.this.nres_index));
                        if (null == ScreenDriver.this.nrates || 0 == ScreenDriver.this.nrates.length) {
                            return null;
                        }
                        ScreenDriver.this.nrate_index = 0;
                    }
                }
                return nArray2;
            }
        });
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<ScreenMode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ScreenMode run(long l) {
                int n;
                int n2;
                int[] nArray;
                int n3;
                long l2 = ScreenDriver.getScreenConfiguration0(l, ScreenDriver.this.screen_idx);
                if (0L == l2) {
                    return null;
                }
                try {
                    int n4 = ScreenDriver.getNumScreenModeResolutions0(l, ScreenDriver.this.screen_idx);
                    if (0 == n4) {
                        ScreenMode screenMode = null;
                        return screenMode;
                    }
                    n3 = ScreenDriver.getCurrentScreenResolutionIndex0(l2);
                    if (0 > n3) {
                        ScreenMode screenMode = null;
                        return screenMode;
                    }
                    if (n3 >= n4) {
                        throw new RuntimeException("Invalid resolution index: ! " + n3 + " < " + n4);
                    }
                    nArray = ScreenDriver.getScreenModeResolution0(l, ScreenDriver.this.screen_idx, n3);
                    if (null == nArray || 0 == nArray.length) {
                        ScreenMode screenMode = null;
                        return screenMode;
                    }
                    if (0 >= nArray[0] || 0 >= nArray[1]) {
                        throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n3 + "/" + n4);
                    }
                    n2 = ScreenDriver.getCurrentScreenRate0(l2);
                    if (0 > n2) {
                        ScreenMode screenMode = null;
                        return screenMode;
                    }
                    n = ScreenDriver.getCurrentScreenRotation0(l2);
                    if (0 > n) {
                        ScreenMode screenMode = null;
                        return screenMode;
                    }
                }
                finally {
                    ScreenDriver.freeScreenConfiguration0(l2);
                }
                int[] nArray2 = new int[8];
                n3 = 0;
                nArray2[n3++] = 0;
                nArray2[n3++] = nArray[0];
                nArray2[n3++] = nArray[1];
                nArray2[n3++] = 32;
                nArray2[n3++] = nArray[2];
                nArray2[n3++] = nArray[3];
                nArray2[n3++] = n2;
                nArray2[n3++] = n;
                nArray2[n3 - 8] = n3;
                return ScreenModeUtil.streamIn(nArray2, 0);
            }
        });
    }

    @Override
    protected boolean setCurrentScreenModeImpl(final ScreenMode screenMode) {
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        final int n = arrayHashSet.indexOf(screenMode);
        if (0 > n) {
            throw new RuntimeException("ScreenMode not element of ScreenMode list: " + screenMode);
        }
        final long l = System.currentTimeMillis();
        boolean bl = this.runWithTempDisplayHandle(new DisplayImpl.DisplayRunnable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run(long l3) {
                boolean bl = false;
                long l2 = ScreenDriver.getScreenConfiguration0(l3, ScreenDriver.this.screen_idx);
                if (0L == l2) {
                    return bl;
                }
                try {
                    int n5 = ScreenDriver.getNumScreenModeResolutions0(l3, ScreenDriver.this.screen_idx);
                    int n2 = ScreenDriver.this.getScreenModesIdx2NativeIdx().get(n);
                    if (0 > n2 || n2 >= n5) {
                        throw new RuntimeException("Invalid resolution index: ! 0 < " + n2 + " < " + n5 + ", screenMode[" + n + "] " + screenMode);
                    }
                    int n3 = screenMode.getMonitorMode().getRefreshRate();
                    int n4 = screenMode.getRotation();
                    if (ScreenDriver.setCurrentScreenModeStart0(l3, ScreenDriver.this.screen_idx, l2, n2, n3, n4)) {
                        while (!bl && System.currentTimeMillis() - l < 10000L) {
                            bl = ScreenDriver.setCurrentScreenModePollEnd0(l3, ScreenDriver.this.screen_idx, n2, n3, n4);
                            if (bl) continue;
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                finally {
                    ScreenDriver.freeScreenConfiguration0(l2);
                }
                return bl;
            }
        });
        if (DEBUG || !bl) {
            System.err.println("X11Screen.setCurrentScreenModeImpl: TO (10000) reached: " + (System.currentTimeMillis() - l) + "ms; Current: " + this.getCurrentScreenMode() + "; Desired: " + screenMode);
        }
        return bl;
    }

    @Override
    protected int validateScreenIndex(int n) {
        DisplayDriver displayDriver = (DisplayDriver)this.getDisplay();
        Boolean bl = displayDriver.isXineramaEnabled();
        if (null != bl) {
            return bl != false ? 0 : n;
        }
        return this.runWithTempDisplayHandle(this.xineramaEnabledQueryWithTemp) != false ? 0 : n;
    }

    @Override
    protected void getVirtualScreenOriginAndSize(final Point point, final Dimension dimension) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                point.setX(0);
                point.setY(0);
                dimension.setWidth(ScreenDriver.getWidth0(l, ScreenDriver.this.screen_idx));
                dimension.setHeight(ScreenDriver.getHeight0(l, ScreenDriver.this.screen_idx));
                return null;
            }
        });
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return this.display.runWithLockedDisplayDevice(displayRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTempDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        T t;
        long l = X11Util.openDisplay(this.display.getName());
        if (0L == l) {
            throw new RuntimeException("null device");
        }
        try {
            t = displayRunnable.run(l);
        }
        finally {
            X11Util.closeDisplay(l);
        }
        return t;
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getAvailableScreenModeRotations0(long var0, int var2);

    private static native int getNumScreenModeResolutions0(long var0, int var2);

    private static native int[] getScreenModeResolution0(long var0, int var2, int var3);

    private static native int[] getScreenModeRates0(long var0, int var2, int var3);

    private static native long getScreenConfiguration0(long var0, int var2);

    private static native void freeScreenConfiguration0(long var0);

    private static native int getCurrentScreenResolutionIndex0(long var0);

    private static native int getCurrentScreenRate0(long var0);

    private static native int getCurrentScreenRotation0(long var0);

    private static native boolean setCurrentScreenModeStart0(long var0, int var2, long var3, int var5, int var6, int var7);

    private static native boolean setCurrentScreenModePollEnd0(long var0, int var2, int var3, int var4, int var5);

    static /* synthetic */ int[] access$202(ScreenDriver screenDriver, int[] nArray) {
        screenDriver.nrotations = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$1002(ScreenDriver screenDriver, int[] nArray) {
        screenDriver.nrates = nArray;
        return nArray;
    }

    static {
        DisplayDriver.initSingleton();
    }
}

