/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import processing.core.PApplet;
import processing.data.Table;
import processing.data.TableHTML;

class HTMLTableScraper {
    ArrayList<Table> tables = new ArrayList();
    TableHTML currentTable;

    public HTMLTableScraper(PApplet parent, String where) {
        this(parent.createReader(where));
    }

    public HTMLTableScraper(File file) {
        this(PApplet.createReader(file));
    }

    public HTMLTableScraper(String html) {
        this(new StringReader(html));
    }

    public HTMLTableScraper(Reader reader) {
        TableHandler handler = new TableHandler();
        this.parse(reader, handler);
    }

    void parse(Reader reader, HTMLEditorKit.ParserCallback handler) {
        HTMLEditorKit.Parser parser = new HTMLEditorKit(){

            @Override
            public HTMLEditorKit.Parser getParser() {
                return super.getParser();
            }
        }.getParser();
        try {
            parser.parse(reader, handler, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public Table getTable(int index) {
        return this.tables.get(index);
    }

    public Table[] getTables() {
        Table[] outgoing = new TableHTML[this.tables.size()];
        this.tables.toArray(outgoing);
        return outgoing;
    }

    public ArrayList<Table> getTableList() {
        return this.tables;
    }

    public void writeTables(PApplet parent, String prefix) {
        int digits = 0;
        int num = this.getTableCount();
        while (num > 0) {
            num /= 10;
            ++digits;
        }
        int i = 0;
        while (i < this.getTableCount()) {
            String name = String.valueOf(prefix) + PApplet.nf(i, digits);
            parent.saveTable(this.tables.get(i), String.valueOf(name) + ".csv");
            ++i;
        }
    }

    class TableHandler
    extends HTMLEditorKit.ParserCallback {
        TableHandler() {
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
            if (tag == HTML.Tag.TABLE) {
                HTMLTableScraper.this.currentTable = new TableHTML(HTMLTableScraper.this.currentTable);
                HTMLTableScraper.this.tables.add(HTMLTableScraper.this.currentTable);
            } else if (HTMLTableScraper.this.currentTable != null) {
                if (tag == HTML.Tag.TR) {
                    HTMLTableScraper.this.currentTable.beginTableRow();
                } else if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
                    int advance = 1;
                    String colspanStr = (String)a.getAttribute(HTML.Attribute.COLSPAN);
                    if (colspanStr != null) {
                        advance = Integer.parseInt(colspanStr);
                    }
                    HTMLTableScraper.this.currentTable.beginTableData(advance);
                    if (a.getAttribute(HTML.Attribute.ROWSPAN) != null) {
                        System.err.println("rowspan attribute in this table is being ignored");
                    }
                }
            }
        }

        @Override
        public void handleText(char[] c, int pos) {
            if (HTMLTableScraper.this.currentTable != null) {
                String data = new String(c).trim();
                HTMLTableScraper.this.currentTable.setContent(data);
            }
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
            if (HTMLTableScraper.this.currentTable != null) {
                if (tag == HTML.Tag.TABLE) {
                    HTMLTableScraper.this.currentTable = HTMLTableScraper.this.currentTable.parent;
                } else if (tag == HTML.Tag.TR) {
                    HTMLTableScraper.this.currentTable.endTableRow();
                } else if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
                    HTMLTableScraper.this.currentTable.endTableData();
                }
            }
        }
    }
}

