/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;

public abstract class Renderer {
    protected static final boolean DEBUG = Region.DEBUG;
    protected static final boolean DEBUG_INSTANCE = false;
    protected final int renderModes;
    protected int vp_width;
    protected int vp_height;
    protected boolean initialized;
    protected final RenderState rs;
    private boolean vboSupported = false;

    public static boolean isWeightValid(float f) {
        return 0.0f <= f && f <= 1.9f;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final int getWidth() {
        return this.vp_width;
    }

    public final int getHeight() {
        return this.vp_height;
    }

    public float getWeight() {
        return this.rs.getWeight().floatValue();
    }

    public float getAlpha() {
        return this.rs.getAlpha().floatValue();
    }

    public final PMVMatrix getMatrix() {
        return this.rs.pmvMatrix();
    }

    protected abstract boolean initShaderProgram(GL2ES2 var1);

    protected abstract void destroyImpl(GL2ES2 var1);

    protected Renderer(RenderState renderState, int n) {
        this.rs = renderState;
        this.renderModes = n;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public boolean usesVariableCurveWeight() {
        return Region.isNonUniformWeight(this.renderModes);
    }

    public final boolean areRenderModesCompatible(Region region) {
        int n = this.getRenderModes() & 2;
        return n == (region.getRenderModes() & n);
    }

    public final boolean isVBOSupported() {
        return this.vboSupported;
    }

    public final void init(GL2ES2 gL2ES2) throws GLException {
        if (this.initialized) {
            return;
        }
        boolean bl = this.vboSupported = gL2ES2.isFunctionAvailable("glGenBuffers") && gL2ES2.isFunctionAvailable("glBindBuffer") && gL2ES2.isFunctionAvailable("glBufferData") && gL2ES2.isFunctionAvailable("glDrawElements") && gL2ES2.isFunctionAvailable("glVertexAttribPointer") && gL2ES2.isFunctionAvailable("glDeleteBuffers");
        if (DEBUG) {
            System.err.println("TextRendererImpl01: VBO Supported = " + this.isVBOSupported());
        }
        if (!this.vboSupported) {
            throw new GLException("VBO not supported");
        }
        this.rs.attachTo(gL2ES2);
        gL2ES2.glEnable(3042);
        gL2ES2.glBlendFunc(770, 771);
        this.initialized = this.initShaderProgram(gL2ES2);
        if (!this.initialized) {
            throw new GLException("Shader initialization failed");
        }
        if (!this.rs.getShaderState().uniform(gL2ES2, this.rs.getPMVMatrix())) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.rs.getShaderState());
        }
        if (Region.isNonUniformWeight(this.getRenderModes()) && !this.rs.getShaderState().uniform(gL2ES2, this.rs.getWeight())) {
            throw new GLException("Error setting weight in shader: " + this.rs.getShaderState());
        }
        if (!this.rs.getShaderState().uniform(gL2ES2, this.rs.getAlpha())) {
            throw new GLException("Error setting global alpha in shader: " + this.rs.getShaderState());
        }
        if (!this.rs.getShaderState().uniform(gL2ES2, this.rs.getColorStatic())) {
            throw new GLException("Error setting global color in shader: " + this.rs.getShaderState());
        }
    }

    public final void flushCache(GL2ES2 gL2ES2) {
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (!this.initialized) {
            return;
        }
        this.rs.getShaderState().useProgram(gL2ES2, false);
        this.destroyImpl(gL2ES2);
        this.rs.destroy(gL2ES2);
        this.initialized = false;
    }

    public final RenderState getRenderState() {
        return this.rs;
    }

    public final ShaderState getShaderState() {
        return this.rs.getShaderState();
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl) {
        this.rs.getShaderState().useProgram(gL2ES2, bl);
    }

    public void setWeight(GL2ES2 gL2ES2, float f) {
        if (!Renderer.isWeightValid(f)) {
            throw new IllegalArgumentException("Weight out of range");
        }
        this.rs.getWeight().setData(f);
        if (null != gL2ES2 && this.rs.getShaderState().inUse() && Region.isNonUniformWeight(this.getRenderModes())) {
            this.rs.getShaderState().uniform(gL2ES2, this.rs.getWeight());
        }
    }

    public void setAlpha(GL2ES2 gL2ES2, float f) {
        this.rs.getAlpha().setData(f);
        if (null != gL2ES2 && this.rs.getShaderState().inUse()) {
            this.rs.getShaderState().uniform(gL2ES2, this.rs.getAlpha());
        }
    }

    public void getColorStatic(GL2ES2 gL2ES2, float[] fArray) {
        FloatBuffer floatBuffer = (FloatBuffer)this.rs.getColorStatic().getBuffer();
        fArray[0] = floatBuffer.get(0);
        fArray[1] = floatBuffer.get(1);
        fArray[2] = floatBuffer.get(2);
    }

    public void setColorStatic(GL2ES2 gL2ES2, float f, float f2, float f3) {
        FloatBuffer floatBuffer = (FloatBuffer)this.rs.getColorStatic().getBuffer();
        floatBuffer.put(0, f);
        floatBuffer.put(1, f2);
        floatBuffer.put(2, f3);
        if (null != gL2ES2 && this.rs.getShaderState().inUse()) {
            this.rs.getShaderState().uniform(gL2ES2, this.rs.getColorStatic());
        }
    }

    public void rotate(GL2ES2 gL2ES2, float f, float f2, float f3, float f4) {
        this.rs.pmvMatrix().glRotatef(f, f2, f3, f4);
        this.updateMatrix(gL2ES2);
    }

    public void translate(GL2ES2 gL2ES2, float f, float f2, float f3) {
        this.rs.pmvMatrix().glTranslatef(f, f2, f3);
        this.updateMatrix(gL2ES2);
    }

    public void scale(GL2ES2 gL2ES2, float f, float f2, float f3) {
        this.rs.pmvMatrix().glScalef(f, f2, f3);
        this.updateMatrix(gL2ES2);
    }

    public void resetModelview(GL2ES2 gL2ES2) {
        this.rs.pmvMatrix().glMatrixMode(5888);
        this.rs.pmvMatrix().glLoadIdentity();
        this.updateMatrix(gL2ES2);
    }

    public void updateMatrix(GL2ES2 gL2ES2) {
        if (this.initialized && null != gL2ES2 && this.rs.getShaderState().inUse()) {
            this.rs.getShaderState().uniform(gL2ES2, this.rs.getPMVMatrix());
        }
    }

    public boolean reshapePerspective(GL2ES2 gL2ES2, float f, int n, int n2, float f2, float f3) {
        this.vp_width = n;
        this.vp_height = n2;
        float f4 = (float)n / (float)n2;
        PMVMatrix pMVMatrix = this.rs.pmvMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(f, f4, f2, f3);
        this.updateMatrix(gL2ES2);
        return true;
    }

    public boolean reshapeOrtho(GL2ES2 gL2ES2, int n, int n2, float f, float f2) {
        this.vp_width = n;
        this.vp_height = n2;
        PMVMatrix pMVMatrix = this.rs.pmvMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glOrthof(0.0f, n, 0.0f, n2, f, f2);
        this.updateMatrix(gL2ES2);
        return true;
    }

    protected String getVertexShaderName(GL2ES2 gL2ES2) {
        return "curverenderer01" + this.getShaderGLVersionSuffix(gL2ES2);
    }

    protected String getFragmentShaderName(GL2ES2 gL2ES2) {
        String string = Region.isVBAA(this.renderModes) ? "b" : "a";
        return "curverenderer01" + string + this.getShaderGLVersionSuffix(gL2ES2);
    }

    protected String getShaderGLVersionSuffix(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES2()) {
            return "-es2";
        }
        return "-gl2";
    }
}

