/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.AnimatorBase;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public class Animator
extends AnimatorBase {
    protected ThreadGroup threadGroup;
    private Runnable runnable;
    private boolean runAsFastAsPossible;
    protected boolean isAnimating;
    protected boolean pauseIssued;
    protected volatile boolean stopIssued;
    private final AnimatorBase.Condition waitForStartedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !Animator.this.isStartedImpl() || !Animator.this.drawablesEmpty && !Animator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForStoppedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStartedImpl();
        }
    };
    private final AnimatorBase.Condition waitForPausedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStartedImpl() && Animator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForResumeCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStartedImpl() && (!Animator.this.drawablesEmpty && !Animator.this.isAnimating || Animator.this.drawablesEmpty && !Animator.this.pauseIssued);
        }
    };

    public Animator() {
        if (DEBUG) {
            System.err.println("Animator created");
        }
    }

    public Animator(ThreadGroup threadGroup) {
        this.setThreadGroup(threadGroup);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup);
        }
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, w/ " + gLAutoDrawable);
        }
    }

    public Animator(ThreadGroup threadGroup, GLAutoDrawable gLAutoDrawable) {
        this.setThreadGroup(threadGroup);
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup + " and " + gLAutoDrawable);
        }
    }

    @Override
    protected String getBaseName(String string) {
        return string + "Animator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRunAsFastAsPossible(boolean bl) {
        this.stateSync.lock();
        try {
            this.runAsFastAsPossible = bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setIsAnimatingSynced(boolean bl) {
        this.stateSync.lock();
        try {
            this.isAnimating = bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private final boolean isAnimatingImpl() {
        return this.animThread != null && this.isAnimating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAnimating() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null && this.isAnimating;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private final boolean isPausedImpl() {
        return this.animThread != null && this.pauseIssued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPaused() {
        this.stateSync.lock();
        try {
            boolean bl = this.animThread != null && this.pauseIssued;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    public synchronized void setThreadGroup(ThreadGroup threadGroup) throws GLException {
        if (this.isStartedImpl()) {
            throw new GLException("Animator already started.");
        }
        this.threadGroup = threadGroup;
    }

    @Override
    public synchronized boolean start() {
        if (this.isStartedImpl()) {
            return false;
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.fpsCounter.resetFPSCounter();
        String string = Thread.currentThread().getName() + "-" + this.baseName;
        Thread thread = null == this.threadGroup ? new Thread(this.runnable, string) : new Thread(this.threadGroup, this.runnable, string);
        thread.setDaemon(false);
        if (DEBUG) {
            Thread thread2 = Thread.currentThread();
            System.err.println("Animator " + thread2.getName() + "[daemon " + thread2.isDaemon() + "]: starting " + thread.getName() + "[daemon " + thread.isDaemon() + "]");
        }
        thread.start();
        return this.finishLifecycleAction(this.waitForStartedCondition, 0L);
    }

    @Override
    public synchronized boolean stop() {
        if (!this.isStartedImpl()) {
            return false;
        }
        this.stopIssued = true;
        return this.finishLifecycleAction(this.waitForStoppedCondition, 0L);
    }

    @Override
    public synchronized boolean pause() {
        if (!this.isStartedImpl() || this.pauseIssued) {
            return false;
        }
        this.pauseIssued = true;
        return this.finishLifecycleAction(this.waitForPausedCondition, 0L);
    }

    @Override
    public synchronized boolean resume() {
        if (!this.isStartedImpl() || !this.pauseIssued) {
            return false;
        }
        this.pauseIssued = false;
        return this.finishLifecycleAction(this.waitForResumeCondition, 0L);
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        public String toString() {
            return "[started " + Animator.this.isStartedImpl() + ", animating " + Animator.this.isAnimatingImpl() + ", paused " + Animator.this.isPausedImpl() + ", drawable " + Animator.this.drawables.size() + ", drawablesEmpty " + Animator.this.drawablesEmpty + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Animator animator;
            try {
                if (AnimatorBase.DEBUG) {
                    System.err.println("Animator start:" + Thread.currentThread() + ": " + this.toString());
                }
                Animator.this.fpsCounter.resetFPSCounter();
                Animator.this.animThread = Thread.currentThread();
                Animator.this.setIsAnimatingSynced(false);
                while (!Animator.this.stopIssued) {
                    animator = Animator.this;
                    synchronized (animator) {
                        boolean bl = false;
                        while (!Animator.this.stopIssued && (Animator.this.pauseIssued || Animator.this.drawablesEmpty)) {
                            if (Animator.this.drawablesEmpty) {
                                Animator.this.pauseIssued = true;
                            }
                            boolean bl2 = Animator.this.pauseIssued;
                            if (AnimatorBase.DEBUG) {
                                System.err.println("Animator pause:" + Thread.currentThread() + ": " + this.toString());
                            }
                            if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty && !bl) {
                                bl = true;
                                Animator.this.setDrawablesExclCtxState(false);
                                Animator.this.display();
                            }
                            Animator.this.setIsAnimatingSynced(false);
                            Animator.this.notifyAll();
                            try {
                                Animator.this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!bl2) continue;
                            Animator.this.fpsCounter.resetFPSCounter();
                            if (!AnimatorBase.DEBUG) continue;
                            System.err.println("Animator resume:" + Thread.currentThread() + ": " + this.toString());
                        }
                        if (!Animator.this.stopIssued && !Animator.this.isAnimating) {
                            Animator.this.setIsAnimatingSynced(true);
                            Animator.this.setDrawablesExclCtxState(Animator.this.exclusiveContext);
                            Animator.this.notifyAll();
                        }
                    }
                    if (!Animator.this.stopIssued) {
                        Animator.this.display();
                    }
                    if (Animator.this.stopIssued || Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
            }
            finally {
                if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty) {
                    Animator.this.setDrawablesExclCtxState(false);
                    Animator.this.display();
                }
                animator = Animator.this;
                synchronized (animator) {
                    if (AnimatorBase.DEBUG) {
                        System.err.println("Animator stop " + Thread.currentThread() + ": " + this.toString());
                    }
                    Animator.this.stopIssued = false;
                    Animator.this.pauseIssued = false;
                    Animator.this.animThread = null;
                    Animator.this.setIsAnimatingSynced(false);
                    Animator.this.notifyAll();
                }
            }
        }
    }
}

