/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.util.ArrayList;
import netP5.AbstractMulticast;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.Multicast;
import netP5.NetAddress;
import netP5.NetAddressList;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;
import netP5.TcpServer;
import netP5.UdpClient;
import netP5.UdpPacketListener;
import netP5.UdpServer;
import oscP5.OscMessage;
import oscP5.OscPacket;
import oscP5.OscProperties;

public class OscNetManager
implements UdpPacketListener,
TcpPacketListener {
    protected OscProperties _myOscProperties;
    protected UdpClient _myUdpClient = null;
    protected UdpServer _myUdpServer = null;
    protected TcpServer _myTcpServer = null;
    protected TcpClient _myTcpClient = null;
    protected boolean isTcpClient = false;
    protected boolean isTcpServer = false;
    protected AbstractMulticast _myMulticast = null;
    protected ArrayList<UdpPacketListener> _myUdpListener = new ArrayList();
    protected ArrayList<TcpPacketListener> _myTcpListener = new ArrayList();
    public static final int NONE = 0;

    public void start(OscProperties oscProperties) {
        this.stop();
        this._myOscProperties = oscProperties;
        int n = this._myOscProperties.networkProtocol();
        switch (n) {
            case 0: {
                this.newUdp();
                break;
            }
            case 1: {
                this.newMulticast();
                break;
            }
            case 2: {
                this.newTcp();
            }
        }
        this._myOscProperties.isLocked = true;
    }

    protected void stop() {
        this._myUdpClient = null;
        if (this._myMulticast != null) {
            Logger.printDebug("OscP5.stop", "multicast.");
            this._myMulticast.dispose();
        }
        if (this._myUdpServer != null) {
            Logger.printDebug("OscP5.stop", "stopping udpserver.");
            this._myUdpServer.dispose();
        }
        this._myMulticast = null;
        this._myUdpServer = null;
        Logger.printProcess("OscP5", "stopped.");
    }

    private void newUdp() {
        this._myUdpClient = this._myOscProperties.remoteAddress() != null && this._myOscProperties.remoteAddress().isvalid() ? new UdpClient(this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port()) : new UdpClient();
        if (this._myOscProperties.listeningPort() > 0) {
            this._myUdpServer = new UdpServer(this, this._myOscProperties.listeningPort(), this._myOscProperties.datagramSize());
        }
    }

    private void newTcp() {
        if (this._myOscProperties.listeningPort() > 0) {
            this._myTcpServer = new TcpServer(this, this._myOscProperties.listeningPort(), 3);
            this.isTcpServer = true;
        } else if (this._myOscProperties.remoteAddress().isvalid()) {
            this._myTcpClient = new TcpClient(this, this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port(), 3);
            this.isTcpClient = true;
        }
    }

    private void newMulticast() {
        if (this._myOscProperties.remoteAddress() != null && this._myOscProperties.remoteAddress().isvalid()) {
            this._myMulticast = new Multicast(this, this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port(), this._myOscProperties.datagramSize());
        } else {
            System.out.println("ERROR @ Multicast");
        }
    }

    public void setTimeToLive(int n) {
        if (this._myMulticast != null) {
            this._myMulticast.setTimeToLive(n);
        } else {
            Logger.printWarning("OscNetManager.setTimeToLive", "only supported for multicast session.");
        }
    }

    public TcpServer tcpServer() {
        return this._myTcpServer;
    }

    public TcpClient tcpClient() {
        return this._myTcpClient;
    }

    public void addUdpListener(UdpPacketListener udpPacketListener) {
        this._myUdpListener.add(udpPacketListener);
    }

    public void removeUdpListener(UdpPacketListener udpPacketListener) {
        this._myUdpListener.remove(udpPacketListener);
    }

    public void addTcpListener(TcpPacketListener tcpPacketListener) {
        this._myTcpListener.add(tcpPacketListener);
    }

    public void removeTcpListener(TcpPacketListener tcpPacketListener) {
        this._myTcpListener.remove(tcpPacketListener);
    }

    public void send(OscPacket oscPacket) {
        if (!this._myOscProperties.sendStatus() && this._myOscProperties.networkProtocol() != 2) {
            Logger.printWarning("OscNetManager.send", "please specify a remote address. send(OscPacket theOscPacket) is only supported when there is a host specified in OscProperties.");
        } else {
            try {
                switch (this._myOscProperties.networkProtocol()) {
                    case 0: {
                        if (this._myOscProperties.srsp()) {
                            this._myUdpServer.send(oscPacket.getBytes(), this._myOscProperties.remoteAddress().inetaddress(), this._myOscProperties.remoteAddress().port());
                            break;
                        }
                        this._myUdpClient.send(oscPacket.getBytes(), this._myOscProperties.remoteAddress().inetaddress(), this._myOscProperties.remoteAddress().port());
                        break;
                    }
                    case 2: {
                        if (this.isTcpServer) {
                            this._myTcpServer.send(oscPacket.getBytes());
                            break;
                        }
                        if (!this.isTcpClient) break;
                        this._myTcpClient.send(oscPacket.getBytes());
                        break;
                    }
                    case 1: {
                        this._myMulticast.send(oscPacket.getBytes());
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                Logger.printError("OscManager.send", "NullPointerException " + nullPointerException);
            }
        }
    }

    public void send(DatagramPacket datagramPacket) {
        if (this._myOscProperties.srsp()) {
            this._myUdpServer.send(datagramPacket);
        } else {
            this._myUdpClient.send(datagramPacket);
        }
    }

    public void send(OscPacket oscPacket, String string, int n) {
        try {
            switch (this._myOscProperties.networkProtocol()) {
                case 0: {
                    if (this._myOscProperties.srsp()) {
                        this._myUdpServer.send(oscPacket.getBytes(), string, n);
                        break;
                    }
                    this._myUdpClient.send(oscPacket.getBytes(), string, n);
                    break;
                }
                case 1: {
                    this._myMulticast.send(oscPacket.getBytes());
                    break;
                }
                case 2: {
                    Logger.printWarning("OscP5.send", "send(OscPacket thePacket,String theAddress,int thePort) is not supported in TCP mode.");
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            Logger.printError("OscP5.send", "NullPointerException " + nullPointerException);
        }
    }

    public void send(OscPacket oscPacket, NetAddressList netAddressList) {
        switch (this._myOscProperties.networkProtocol()) {
            case 0: {
                byte[] byArray = oscPacket.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                for (int i = 0; i < netAddressList.list().size(); ++i) {
                    datagramPacket.setAddress(netAddressList.get(i).inetaddress());
                    datagramPacket.setPort(netAddressList.get(i).port());
                    this.send(datagramPacket);
                }
                break;
            }
            case 2: {
                Logger.printWarning("OscP5.send", "send(OscPacket thePacket,NetAddressList theList) is not supported in TCP mode.");
            }
        }
    }

    public void send(OscPacket oscPacket, NetAddress netAddress) {
        switch (this._myOscProperties.networkProtocol()) {
            case 0: {
                if (!netAddress.isvalid()) break;
                byte[] byArray = oscPacket.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                datagramPacket.setAddress(netAddress.inetaddress());
                datagramPacket.setPort(netAddress.port());
                this.send(datagramPacket);
                break;
            }
            case 2: {
                Logger.printWarning("OscP5.send", "send(OscPacket thePacket,NetAddress theHost) is not supported in TCP mode.");
            }
        }
    }

    public void send(String string, Object[] objectArray) {
        this.send(new OscMessage(string, objectArray));
    }

    public void send(String string, Object[] objectArray, String string2, int n) {
        this.send(new OscMessage(string, objectArray), string2, n);
    }

    public void send(String string, Object[] objectArray, NetAddressList netAddressList) {
        this.send((OscPacket)new OscMessage(string, objectArray), netAddressList);
    }

    public void send(String string, Object[] objectArray, NetAddress netAddress) {
        this.send((OscPacket)new OscMessage(string, objectArray), netAddress);
    }

    public void process(DatagramPacket datagramPacket, int n) {
        for (int i = 0; i < this._myUdpListener.size(); ++i) {
            this._myUdpListener.get(i).process(datagramPacket, n);
        }
    }

    public void process(TcpPacket tcpPacket, int n) {
        for (int i = 0; i < this._myTcpListener.size(); ++i) {
            this._myTcpListener.get(i).process(tcpPacket, n);
        }
    }

    public void remove(AbstractTcpClient abstractTcpClient) {
    }

    public void status(int n) {
    }
}

