/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLGLCapabilities;

public class EGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    private GLCapabilitiesChooser chooser;

    public final long getNativeConfig() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfig();
    }

    public final int getNativeConfigID() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfigID();
    }

    EGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, EGLGLCapabilities eGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable);
        this.chooser = gLCapabilitiesChooser;
    }

    public static EGLGraphicsConfiguration create(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        long l2 = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(l, n);
        if (0L < l2) {
            int n2 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities((EGLGraphicsDevice)abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), l2, n2, false);
            return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser());
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    void updateGraphicsConfiguration() {
        CapabilitiesImmutable capabilitiesImmutable = this.getChosenCapabilities();
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(this.getScreen().getDevice(), capabilitiesImmutable).chooseGraphicsConfiguration(capabilitiesImmutable, this.getRequestedCapabilities(), this.chooser, this.getScreen(), 0);
        if (null != eGLGraphicsConfiguration) {
            this.setChosenCapabilities(eGLGraphicsConfiguration.getChosenCapabilities());
            if (DEBUG) {
                System.err.println("updateGraphicsConfiguration(1): " + this);
            }
        }
    }

    public static long EGLConfigId2EGLConfig(long l, int n) {
        IntBuffer intBuffer;
        PointerBuffer pointerBuffer;
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int[])new int[]{12328, n, 12344});
        if (!EGL.eglChooseConfig(l, intBuffer2, pointerBuffer = PointerBuffer.allocateDirect((int)1), 1, intBuffer = Buffers.newDirectIntBuffer((int)1))) {
            return 0L;
        }
        if (intBuffer.get(0) == 0) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    public static boolean isEGLConfigValid(long l, long l2) {
        if (0L == l2) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigAttrib(l, l2, 12328, intBuffer)) {
            int n = EGL.eglGetError();
            if (DEBUG) {
                System.err.println("Info: Couldn't retrieve EGL ConfigID for config " + EGLGraphicsConfiguration.toHexString(l2) + ", error " + EGLGraphicsConfiguration.toHexString(n));
            }
            return false;
        }
        return true;
    }

    static int EGLConfigDrawableTypeBits(EGLGraphicsDevice eGLGraphicsDevice, long l) {
        int n = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigAttrib(eGLGraphicsDevice.getHandle(), l, 12339, intBuffer)) {
            throw new GLException("Could not determine EGL_SURFACE_TYPE");
        }
        int n2 = intBuffer.get(0);
        if (0 != (n2 & 4)) {
            n |= 1;
        }
        if (0 != (n2 & 2)) {
            n |= 2;
        }
        if (0 != (n2 & 1)) {
            n |= 0xC;
        }
        return n;
    }

    public static EGLGLCapabilities EGLConfig2Capabilities(EGLGraphicsDevice eGLGraphicsDevice, GLProfile gLProfile, long l, int n, boolean bl) {
        int n2;
        int n3;
        IntBuffer intBuffer;
        long l2 = eGLGraphicsDevice.getHandle();
        if (!EGL.eglGetConfigAttrib(l2, l, 12328, intBuffer = Buffers.newDirectIntBuffer((int)1))) {
            if (DEBUG) {
                System.err.println("EGL couldn't retrieve ConfigID for config " + EGLGraphicsConfiguration.toHexString(l) + ", error " + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return null;
        }
        int n4 = intBuffer.get(0);
        if (!EGL.eglGetConfigAttrib(l2, l, 12352, intBuffer)) {
            if (DEBUG) {
                System.err.println("EGL couldn't retrieve EGL_RENDERABLE_TYPE for config " + EGLGraphicsConfiguration.toHexString(l) + ", error " + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return null;
        }
        int n5 = intBuffer.get(0);
        int n6 = EGL.eglGetConfigAttrib(l2, l, 12334, intBuffer) ? intBuffer.get(0) : 0;
        EGLGLCapabilities eGLGLCapabilities = null;
        try {
            if (null == gLProfile) {
                gLProfile = EGLGLCapabilities.getCompatible(eGLGraphicsDevice, n5);
            }
            if (!EGLGLCapabilities.isCompatible(gLProfile, n5)) {
                if (DEBUG) {
                    System.err.println("config " + EGLGraphicsConfiguration.toHexString(l) + ": Requested GLProfile " + gLProfile + " not compatible with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n5) + "]");
                }
                return null;
            }
            eGLGLCapabilities = new EGLGLCapabilities(l, n4, n6, gLProfile, n5);
        }
        catch (GLException gLException) {
            if (DEBUG) {
                System.err.println("config " + EGLGraphicsConfiguration.toHexString(l) + ": " + gLException);
            }
            return null;
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12327, intBuffer) && 12368 == intBuffer.get(0)) {
            eGLGLCapabilities.setHardwareAccelerated(false);
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12337, intBuffer)) {
            eGLGLCapabilities.setSampleBuffers(intBuffer.get(0) > 0);
            eGLGLCapabilities.setNumSamples(intBuffer.get(0));
        }
        if (!eGLGLCapabilities.getSampleBuffers() && EGL.eglGetConfigAttrib(l2, l, 12512, intBuffer) && intBuffer.get(0) > 0 && EGL.eglGetConfigAttrib(l2, l, 12513, intBuffer)) {
            eGLGLCapabilities.setSampleExtension("NV_coverage_sample");
            eGLGLCapabilities.setSampleBuffers(true);
            eGLGLCapabilities.setNumSamples(intBuffer.get(0));
        }
        if (bl) {
            eGLGLCapabilities.setBackgroundOpaque(false);
        } else if (EGL.eglGetConfigAttrib(l2, l, 12340, intBuffer)) {
            eGLGLCapabilities.setBackgroundOpaque(intBuffer.get(0) != 12370);
        }
        if (!eGLGLCapabilities.isBackgroundOpaque()) {
            if (EGL.eglGetConfigAttrib(l2, l, 12343, intBuffer)) {
                eGLGLCapabilities.setTransparentRedValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
            if (EGL.eglGetConfigAttrib(l2, l, 12342, intBuffer)) {
                eGLGLCapabilities.setTransparentGreenValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
            if (EGL.eglGetConfigAttrib(l2, l, 12341, intBuffer)) {
                eGLGLCapabilities.setTransparentBlueValue(intBuffer.get(0) == -1 ? -1 : intBuffer.get(0));
            }
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12324, intBuffer)) {
            eGLGLCapabilities.setRedBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12323, intBuffer)) {
            eGLGLCapabilities.setGreenBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12322, intBuffer)) {
            eGLGLCapabilities.setBlueBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12321, intBuffer)) {
            eGLGLCapabilities.setAlphaBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12326, intBuffer)) {
            eGLGLCapabilities.setStencilBits(intBuffer.get(0));
        }
        if (EGL.eglGetConfigAttrib(l2, l, 12325, intBuffer)) {
            eGLGLCapabilities.setDepthBits(intBuffer.get(0));
        }
        if (0 == (n3 = n & (n2 = EGLGraphicsConfiguration.EGLConfigDrawableTypeBits(eGLGraphicsDevice, l)))) {
            return null;
        }
        return (EGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(eGLGraphicsDevice, n3, eGLGLCapabilities);
    }

    public static IntBuffer GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        int n;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)32);
        int n2 = 0;
        intBuffer.put(n2++, 12339);
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n = 4;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n = 1;
        } else if (gLCapabilitiesImmutable.isPBuffer()) {
            n = 1;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n = 2;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        intBuffer.put(n2++, n);
        intBuffer.put(n2++, 12324);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n2++, 12323);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n2++, 12322);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n2++, 12321);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n2++, 12326);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n2++, 12325);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            if (gLCapabilitiesImmutable.getSampleExtension().equals("NV_coverage_sample")) {
                intBuffer.put(n2++, 12512);
                intBuffer.put(n2++, 1);
                intBuffer.put(n2++, 12513);
                intBuffer.put(n2++, gLCapabilitiesImmutable.getNumSamples());
            } else {
                intBuffer.put(n2++, 12338);
                intBuffer.put(n2++, 1);
                intBuffer.put(n2++, 12337);
                intBuffer.put(n2++, gLCapabilitiesImmutable.getNumSamples());
            }
        }
        intBuffer.put(n2++, 12340);
        intBuffer.put(n2++, gLCapabilitiesImmutable.isBackgroundOpaque() ? 12344 : 12340);
        if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
            intBuffer.put(n2++, 12343);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1);
            intBuffer.put(n2++, 12342);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1);
            intBuffer.put(n2++, 12341);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1);
        }
        intBuffer.put(n2++, 12352);
        if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES1()) {
            intBuffer.put(n2++, 1);
        } else if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES2()) {
            intBuffer.put(n2++, 4);
        } else {
            intBuffer.put(n2++, 8);
        }
        intBuffer.put(n2++, 12344);
        return intBuffer;
    }

    public static IntBuffer CreatePBufferSurfaceAttribList(int n, int n2, int n3) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)16);
        int n4 = 0;
        intBuffer.put(n4++, 12375);
        intBuffer.put(n4++, n);
        intBuffer.put(n4++, 12374);
        intBuffer.put(n4++, n2);
        intBuffer.put(n4++, 12416);
        intBuffer.put(n4++, n3);
        intBuffer.put(n4++, 12417);
        intBuffer.put(n4++, 12380 == n3 ? 12380 : 12383);
        intBuffer.put(n4++, 12344);
        return intBuffer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ",\n\teglConfigHandle " + EGLGraphicsConfiguration.toHexString(this.getNativeConfig()) + ", eglConfigID " + EGLGraphicsConfiguration.toHexString(this.getNativeConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

