/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.opengl.JoglVersion;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.opengl.Debug;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;

public class GLProfile {
    public static final boolean DEBUG = Debug.debug("GLProfile");
    public static final String GL4bc = "GL4bc";
    public static final String GL4 = "GL4";
    public static final String GL3bc = "GL3bc";
    public static final String GL3 = "GL3";
    public static final String GL2 = "GL2";
    public static final String GLES1 = "GLES1";
    public static final String GLES2 = "GLES2";
    public static final String GL2ES1 = "GL2ES1";
    public static final String GL2ES2 = "GL2ES2";
    public static final String GL2GL3 = "GL2GL3";
    private static final String GL_DEFAULT = "GL_DEFAULT";
    public static final String[] GL_PROFILE_LIST_ALL;
    public static final String[] GL_PROFILE_LIST_MAX;
    public static final String[] GL_PROFILE_LIST_MIN;
    public static final String[] GL_PROFILE_LIST_MIN_DESKTOP;
    public static final String[] GL_PROFILE_LIST_MAX_FIXEDFUNC;
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER;
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER_CORE;
    private static boolean isAWTAvailable;
    private static boolean hasDesktopGLFactory;
    private static boolean hasGL234Impl;
    private static boolean hasEGLFactory;
    private static boolean hasGLES2Impl;
    private static boolean hasGLES1Impl;
    private static GLDrawableFactoryImpl eglFactory;
    private static GLDrawableFactoryImpl desktopFactory;
    private static AbstractGraphicsDevice defaultDevice;
    private static volatile boolean initialized;
    private static RecursiveThreadGroupLock initLock;
    private static HashMap<String, HashMap<String, GLProfile>> deviceConn2ProfileMap;
    private final GLProfile profileImpl;
    private final String profile;
    private final boolean isHardwareRasterizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSingleton() {
        boolean bl;
        initLock.lock();
        try {
            if (!initialized) {
                initialized = true;
                bl = true;
                if (DEBUG) {
                    System.err.println("GLProfile.initSingleton() - thread " + Thread.currentThread().getName());
                    Thread.dumpStack();
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Platform.initSingleton();
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ClassLoader classLoader = GLProfile.class.getClassLoader();
                                try {
                                    ReflectionUtil.createInstance((String)(GLProfile.getGLImplBaseClassName(GLProfile.GL4bc) + "Impl"), (Class[])new Class[]{GLProfile.class, GLContextImpl.class}, (Object[])new Object[]{null, null}, (ClassLoader)classLoader);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    ReflectionUtil.createInstance((String)(GLProfile.getGLImplBaseClassName(GLProfile.GLES2) + "Impl"), (Class[])new Class[]{GLProfile.class, GLContextImpl.class}, (Object[])new Object[]{null, null}, (ClassLoader)classLoader);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    ReflectionUtil.createInstance((String)(GLProfile.getGLImplBaseClassName(GLProfile.GLES1) + "Impl"), (Class[])new Class[]{GLProfile.class, GLContextImpl.class}, (Object[])new Object[]{null, null}, (ClassLoader)classLoader);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }, "GLProfile-GL_Bootstrapping").start();
                        if (TempJarCache.isInitialized()) {
                            ClassLoader classLoader = GLProfile.class.getClassLoader();
                            Class[] classArray = new Class[]{NWJNILibLoader.class, GLProfile.class, null};
                            if (ReflectionUtil.isClassAvailable((String)"com.jogamp.newt.NewtFactory", (ClassLoader)classLoader)) {
                                classArray[2] = ReflectionUtil.getClass((String)"com.jogamp.newt.NewtFactory", (boolean)false, (ClassLoader)classLoader);
                            }
                            JNILibLoaderBase.addNativeJarLibs((Class[])classArray, (String)"-all", (String[])new String[]{"-noawt", "-mobile", "-core"});
                        }
                        GLProfile.initProfilesForDefaultDevices();
                        return null;
                    }
                });
            } else {
                bl = false;
            }
        }
        finally {
            initLock.unlock();
        }
        if (DEBUG && bl && (hasGL234Impl || hasGLES1Impl || hasGLES2Impl)) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(defaultDevice, null, true));
        }
    }

    public static void initProfiles(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        GLProfile.getProfileMap(abstractGraphicsDevice, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        initLock.lock();
        try {
            if (initialized) {
                initialized = false;
                if (DEBUG) {
                    System.err.println("GLProfile.shutdown() - thread " + Thread.currentThread().getName());
                    Thread.dumpStack();
                }
                GLDrawableFactory.shutdown();
            }
        }
        finally {
            initLock.unlock();
        }
    }

    public static boolean isAvailable(AbstractGraphicsDevice abstractGraphicsDevice, String string) {
        GLProfile.initSingleton();
        return GLProfile.isAvailableImpl(GLProfile.getProfileMap(abstractGraphicsDevice, false), string);
    }

    private static boolean isAvailableImpl(HashMap<String, GLProfile> hashMap, String string) {
        return null != hashMap && null != hashMap.get(string);
    }

    public static boolean isAvailable(String string) {
        return GLProfile.isAvailable(null, string);
    }

    public static boolean isAnyAvailable() {
        return GLProfile.isAvailable(null, null);
    }

    public static String glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLProfile.glAvailabilityToString(abstractGraphicsDevice, null).toString();
    }

    public static StringBuilder glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder) {
        return GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder, null, 0);
    }

    private static StringBuilder doIndent(StringBuilder stringBuilder, String string, int n) {
        while (n > 0) {
            stringBuilder.append(string);
            --n;
        }
        return stringBuilder;
    }

    public static StringBuilder glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder, String string, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = null != string;
        GLProfile.initSingleton();
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, false);
        if (bl) {
            GLProfile.doIndent(stringBuilder, string, n).append("Native");
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, ++n).append(GL4bc).append(string);
        } else {
            stringBuilder.append("Native[GL4bc ");
        }
        boolean bl2 = GLProfile.isAvailableImpl(hashMap, GL4bc);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 4, 2);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL4).append(string);
        } else {
            stringBuilder.append(", GL4 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL4);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 4, 4);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL3bc).append(string);
        } else {
            stringBuilder.append(", GL3bc ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL3bc);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 3, 2);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL3).append(string);
        } else {
            stringBuilder.append(", GL3 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL3);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 3, 4);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL2).append(string);
        } else {
            stringBuilder.append(", GL2 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL2);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 2, 2);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL2ES1).append(string);
        } else {
            stringBuilder.append(", GL2ES1 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL2ES1));
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GLES1).append(string);
        } else {
            stringBuilder.append(", GLES1 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GLES1);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 1, 8);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GL2ES2).append(string);
        } else {
            stringBuilder.append(", GL2ES2 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL2ES2));
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append(GLES2).append(string);
        } else {
            stringBuilder.append(", GLES2 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GLES2);
        stringBuilder.append(bl2);
        if (bl2) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 2, 8);
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, --n).append("Profiles");
            ++n;
        } else {
            stringBuilder.append("], Profiles[");
        }
        if (null != hashMap) {
            Iterator<GLProfile> iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n);
                }
                stringBuilder.append(iterator.next().toString());
                if (bl) continue;
                stringBuilder.append(", ");
            }
            if (bl) {
                GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("default ");
            } else {
                stringBuilder.append(", default ");
            }
            try {
                stringBuilder.append(GLProfile.getDefault(abstractGraphicsDevice));
            }
            catch (GLException gLException) {
                stringBuilder.append("n/a");
            }
        }
        if (bl) {
            stringBuilder.append(Platform.getNewline());
        } else {
            stringBuilder.append("]");
        }
        return stringBuilder;
    }

    public static String glAvailabilityToString() {
        return GLProfile.glAvailabilityToString(null);
    }

    public static GLProfile getDefault(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, GL_DEFAULT);
        return gLProfile;
    }

    public static GLProfile getDefault() {
        return GLProfile.getDefault(defaultDevice);
    }

    public static GLProfile getMaximum(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX, bl);
    }

    public static GLProfile getMaximum(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX, bl);
    }

    public static GLProfile getMinimum(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MIN, bl);
    }

    public static GLProfile getMinimum(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MIN, bl);
    }

    public static GLProfile getMaxFixedFunc(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_FIXEDFUNC, bl);
    }

    public static GLProfile getMaxFixedFunc(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_FIXEDFUNC, bl);
    }

    public static GLProfile getMaxProgrammable(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER, bl);
    }

    public static GLProfile getMaxProgrammable(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER, bl);
    }

    public static GLProfile getMaxProgrammableCore(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER_CORE, bl);
    }

    public static GLProfile getMaxProgrammableCore(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER_CORE, bl);
    }

    public static GLProfile getGL2ES1(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES1() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES2(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES2).getImpl();
    }

    public static GLProfile getGL2ES2() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES2).getImpl();
    }

    public static GLProfile getGL2GL3(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2GL3).getImpl();
    }

    public static GLProfile getGL2GL3() throws GLException {
        return GLProfile.get(defaultDevice, GL2GL3).getImpl();
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String string) throws GLException {
        HashMap<String, GLProfile> hashMap;
        GLProfile gLProfile;
        if (null == string || string.equals("GL")) {
            string = GL_DEFAULT;
        }
        if (null == (gLProfile = (hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true)).get(string))) {
            throw new GLException("Profile " + string + " is not available on " + abstractGraphicsDevice + ", but: " + hashMap.values());
        }
        return gLProfile;
    }

    public static GLProfile get(String string) throws GLException {
        return GLProfile.get(defaultDevice, string);
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String[] stringArray, boolean bl) throws GLException {
        GLProfile gLProfile = null;
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true);
        for (int i = 0; i < stringArray.length; ++i) {
            GLProfile gLProfile2 = hashMap.get(stringArray[i]);
            if (null == gLProfile2) continue;
            if (!bl) {
                return gLProfile2;
            }
            if (gLProfile2.isHardwareRasterizer()) {
                return gLProfile2;
            }
            if (null != gLProfile) continue;
            gLProfile = gLProfile2;
        }
        if (null != gLProfile) {
            return gLProfile;
        }
        throw new GLException("Profiles " + GLProfile.array2String(stringArray) + " not available on device " + abstractGraphicsDevice);
    }

    public static GLProfile get(String[] stringArray, boolean bl) throws GLException {
        return GLProfile.get(defaultDevice, stringArray, bl);
    }

    public static boolean usesNativeGLES1(String string) {
        return GLES1.equals(string);
    }

    public static boolean usesNativeGLES2(String string) {
        return GLES2.equals(string);
    }

    public static boolean usesNativeGLES(String string) {
        return GLProfile.usesNativeGLES2(string) || GLProfile.usesNativeGLES1(string);
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getGLTypeName(int n) {
        switch (n) {
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5126: {
                return "GL_FLOAT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5124: {
                return "GL_INT";
            }
            case 5125: {
                return "GL_UNSIGNED_INT";
            }
            case 5130: {
                return "GL_DOUBLE";
            }
            case 5127: {
                return "GL_2_BYTES";
            }
            case 5128: {
                return "GL_3_BYTES";
            }
            case 5129: {
                return "GL_4_BYTES";
            }
        }
        return null;
    }

    public static String getGLArrayName(int n) {
        switch (n) {
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return null;
    }

    public final String getGLImplBaseClassName() {
        return GLProfile.getGLImplBaseClassName(this.getImplName());
    }

    private static final String getGLImplBaseClassName(String string) {
        if (GLES2 == string) {
            return "jogamp.opengl.es2.GLES2";
        }
        if (GLES1 == string) {
            return "jogamp.opengl.es1.GLES1";
        }
        if (GL4bc == string || GL4 == string || GL3bc == string || GL3 == string || GL2 == string) {
            return "jogamp.opengl.gl4.GL4bc";
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GLProfile) {
            GLProfile gLProfile = (GLProfile)object;
            return this.getName() == gLProfile.getName() && this.getImplName() == gLProfile.getImplName();
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + this.getImplName().hashCode();
        n = 97 * n + this.getName().hashCode();
        return n;
    }

    public final void verifyEquality(GLProfile gLProfile) throws GLException {
        if (!this.equals(gLProfile)) {
            throw new GLException("GLProfiles are not equal: " + this + " != " + gLProfile);
        }
    }

    public final String getName() {
        return this.profile;
    }

    public final GLProfile getImpl() {
        return null != this.profileImpl ? this.profileImpl : this;
    }

    public final boolean isHardwareRasterizer() {
        return this.isHardwareRasterizer;
    }

    public final String getImplName() {
        return null != this.profileImpl ? this.profileImpl.getName() : this.getName();
    }

    public final boolean isGL4bc() {
        return GL4bc == this.profile;
    }

    public final boolean isGL4() {
        return this.isGL4bc() || GL4 == this.profile;
    }

    public final boolean isGL3bc() {
        return this.isGL4bc() || GL3bc == this.profile;
    }

    public final boolean isGL3() {
        return this.isGL4() || this.isGL3bc() || GL3 == this.profile;
    }

    public final boolean isGL2() {
        return this.isGL3bc() || GL2 == this.profile;
    }

    public final boolean isGLES1() {
        return GLES1 == this.profile;
    }

    public final boolean isGLES2() {
        return GLES2 == this.profile;
    }

    public final boolean isGLES() {
        return GLES2 == this.profile || GLES1 == this.profile;
    }

    public final boolean isGL2ES1() {
        return GL2ES1 == this.profile || this.isGLES1() || this.isGL2();
    }

    public final boolean isGL2GL3() {
        return GL2GL3 == this.profile || this.isGL3() || this.isGL2();
    }

    public final boolean isGL2ES2() {
        return GL2ES2 == this.profile || this.isGLES2() || this.isGL2GL3();
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public final boolean usesNativeGLES1() {
        return GLES1 == this.getImplName();
    }

    public final boolean usesNativeGLES2() {
        return GLES2 == this.getImplName();
    }

    public final boolean usesNativeGLES() {
        return this.usesNativeGLES2() || this.usesNativeGLES1();
    }

    public boolean isValidDataType(int n, boolean bl) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5126: 
            case 5132: {
                return true;
            }
            case 5124: 
            case 5125: {
                if (this.isGL2ES2()) {
                    return true;
                }
            }
            case 5130: {
                if (this.isGL3()) {
                    return true;
                }
            }
            case 5127: 
            case 5128: 
            case 5129: {
                if (!this.isGL2()) break;
                return true;
            }
        }
        if (bl) {
            throw new GLException("Illegal data type on profile " + this + ": " + n);
        }
        return false;
    }

    public boolean isValidArrayDataType(int n, int n2, int n3, boolean bl, boolean bl2) {
        block82: {
            String string;
            block84: {
                block83: {
                    block81: {
                        string = GLProfile.getGLArrayName(n);
                        if (!this.isGLES1()) break block81;
                        if (bl) {
                            if (bl2) {
                                throw new GLException("Illegal array type for " + string + " on profile GLES1: VertexAttribPointer");
                            }
                            return false;
                        }
                        block0 : switch (n) {
                            case 32884: 
                            case 32888: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32885: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 3: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32886: {
                                switch (n3) {
                                    case 5121: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                        }
                        break block82;
                    }
                    if (!this.isGLES2()) break block83;
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5126: 
                        case 5132: {
                            break block82;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GLES2: " + n3);
                            }
                            return false;
                        }
                    }
                }
                if (!this.isGL2ES2()) break block82;
                if (!bl) break block84;
                switch (n3) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 5130: {
                        break;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                        }
                        return false;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break block82;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                        }
                        return false;
                    }
                }
            }
            block32 : switch (n) {
                case 32884: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32885: {
                    switch (n3) {
                        case 5120: 
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                    }
                    return false;
                }
                case 32886: {
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32888: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "GLProfile[" + this.getName() + "/" + this.getImplName() + "." + (this.isHardwareRasterizer ? "hw" : "sw") + "]";
    }

    private static void initProfilesForDefaultDevices() {
        boolean bl;
        AbstractGraphicsDevice abstractGraphicsDevice;
        Object object;
        NativeWindowFactory.initSingleton();
        if (DEBUG) {
            System.err.println("GLProfile.init - thread: " + Thread.currentThread().getName());
            System.err.println(VersionUtil.getPlatformInfo());
            System.err.println(GlueGenVersion.getInstance());
            System.err.println((Object)NativeWindowVersion.getInstance());
            System.err.println((Object)JoglVersion.getInstance());
        }
        ClassLoader classLoader = GLProfile.class.getClassLoader();
        isAWTAvailable = NativeWindowFactory.isAWTAvailable() && ReflectionUtil.isClassAvailable((String)"javax.media.opengl.awt.GLCanvas", (ClassLoader)classLoader);
        hasGL234Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.gl4.GL4bcImpl", (ClassLoader)classLoader);
        hasGLES1Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.es1.GLES1Impl", (ClassLoader)classLoader);
        hasGLES2Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.es2.GLES2Impl", (ClassLoader)classLoader);
        GLDrawableFactory.initSingleton();
        Throwable throwable = null;
        try {
            desktopFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GL2);
            if (null != desktopFactory && null != (object = (DesktopGLDynamicLookupHelper)desktopFactory.getGLDynamicLookupHelper(0))) {
                hasDesktopGLFactory = object.isLibComplete() && hasGL234Impl;
            }
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (DEBUG && null != throwable) {
            throwable.printStackTrace();
        }
        if (null == desktopFactory) {
            hasDesktopGLFactory = false;
            hasGL234Impl = false;
            object = null;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Desktop GLDrawable factory not available");
            }
        } else {
            object = desktopFactory.getDefaultDevice();
        }
        if (ReflectionUtil.isClassAvailable((String)"jogamp.opengl.egl.EGLDrawableFactory", (ClassLoader)classLoader)) {
            throwable = null;
            try {
                eglFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GLES2);
                if (null != eglFactory) {
                    hasEGLFactory = true;
                    hasGLES2Impl = null != eglFactory.getGLDynamicLookupHelper(2) && hasGLES2Impl;
                    hasGLES1Impl = null != eglFactory.getGLDynamicLookupHelper(1) && hasGLES1Impl;
                }
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            catch (SecurityException securityException) {
                throwable = securityException;
            }
            catch (NullPointerException nullPointerException) {
                throwable = nullPointerException;
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
            }
            if (DEBUG && null != throwable) {
                throwable.printStackTrace();
            }
        }
        if (null == eglFactory) {
            hasGLES2Impl = false;
            hasGLES1Impl = false;
            abstractGraphicsDevice = null;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - EGL GLDrawable factory not available");
            }
        } else {
            abstractGraphicsDevice = eglFactory.getDefaultDevice();
        }
        if (null != object) {
            defaultDevice = object;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device is desktop derived: " + defaultDevice);
            }
        } else if (null != abstractGraphicsDevice) {
            defaultDevice = abstractGraphicsDevice;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device is EGL derived: " + defaultDevice);
            }
        } else {
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device not available");
            }
            defaultDevice = null;
        }
        boolean bl2 = null != abstractGraphicsDevice ? GLProfile.initProfilesForDevice(abstractGraphicsDevice) : false;
        boolean bl3 = null != object ? GLProfile.initProfilesForDevice((AbstractGraphicsDevice)object) : false;
        boolean bl4 = bl = bl2 || bl3;
        if (DEBUG) {
            System.err.println("GLProfile.init addedAnyProfile       " + bl + " (desktop: " + bl3 + ", egl " + bl2 + ")");
            System.err.println("GLProfile.init isAWTAvailable        " + isAWTAvailable);
            System.err.println("GLProfile.init hasDesktopGLFactory   " + hasDesktopGLFactory);
            System.err.println("GLProfile.init hasGL234Impl          " + hasGL234Impl);
            System.err.println("GLProfile.init hasEGLFactory         " + hasEGLFactory);
            System.err.println("GLProfile.init hasGLES1Impl          " + hasGLES1Impl);
            System.err.println("GLProfile.init hasGLES2Impl          " + hasGLES2Impl);
            System.err.println("GLProfile.init defaultDevice         " + defaultDevice);
            System.err.println("GLProfile.init defaultDevice Desktop " + (Object)object);
            System.err.println("GLProfile.init defaultDevice EGL     " + abstractGraphicsDevice);
            System.err.println("GLProfile.init profile order         " + GLProfile.array2String(GL_PROFILE_LIST_ALL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initProfilesForDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            return false;
        }
        initLock.lock();
        try {
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactoryImpl(abstractGraphicsDevice);
            gLDrawableFactory.enterThreadCriticalZone();
            try {
                boolean bl = GLProfile.initProfilesForDeviceCritical(abstractGraphicsDevice);
                gLDrawableFactory.leaveThreadCriticalZone();
                return bl;
            }
            catch (Throwable throwable) {
                gLDrawableFactory.leaveThreadCriticalZone();
                throw throwable;
            }
        }
        finally {
            initLock.unlock();
        }
    }

    private static boolean initProfilesForDeviceCritical(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2;
        block20: {
            int n;
            block21: {
                boolean bl3;
                boolean bl4;
                boolean bl5 = GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    System.err.println("Info: GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + " (" + abstractGraphicsDevice.getClass().getName() + "), isSet " + bl5 + ", hasDesktopGLFactory " + hasDesktopGLFactory + ", hasEGLFactory " + hasEGLFactory);
                }
                if (bl5) {
                    String string = abstractGraphicsDevice.getUniqueID();
                    HashMap<String, GLProfile> hashMap = deviceConn2ProfileMap.get(string);
                    if (null == hashMap) {
                        throw new InternalError("GLContext Avail. GLVersion is set - but no profile map for device: " + abstractGraphicsDevice);
                    }
                    return null != hashMap.get(GL_DEFAULT);
                }
                bl2 = false;
                bl = false;
                boolean bl6 = bl4 = hasDesktopGLFactory && desktopFactory.getIsDeviceCompatible(abstractGraphicsDevice);
                if (bl4) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, true, true);
                    Thread thread = desktopFactory.getSharedResourceThread();
                    if (null != thread) {
                        initLock.addOwner(thread);
                    }
                    boolean bl7 = desktopFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != thread) {
                        initLock.removeOwner(thread);
                    }
                    if (DEBUG) {
                        System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": desktop Shared Ctx " + bl7);
                    }
                    if (!bl7) {
                        hasDesktopGLFactory = false;
                    } else if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                        throw new InternalError("Available GLVersions not set");
                    }
                    bl2 = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                }
                boolean bl8 = bl3 = hasEGLFactory && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice);
                if (bl3 && (hasGLES2Impl || hasGLES1Impl)) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, false, true);
                    Thread thread = eglFactory.getSharedResourceThread();
                    if (null != thread) {
                        initLock.addOwner(thread);
                    }
                    n = eglFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != thread) {
                        initLock.removeOwner(thread);
                    }
                    if (n == 0) {
                        hasEGLFactory = false;
                        hasGLES2Impl = false;
                        hasGLES1Impl = false;
                    }
                    if (DEBUG) {
                        System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": egl Shared Ctx " + (n != 0));
                    }
                    bl = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                }
                if (!bl2 && !bl) {
                    GLProfile.setProfileMap(abstractGraphicsDevice, new HashMap<String, GLProfile>());
                    if (DEBUG) {
                        System.err.println("GLProfile: device could not be initialized: " + abstractGraphicsDevice);
                        System.err.println("GLProfile: compatible w/ desktop: " + bl4 + ", egl " + bl3);
                        System.err.println("GLProfile: desktoplFactory      " + desktopFactory);
                        System.err.println("GLProfile: eglFactory           " + eglFactory);
                        System.err.println("GLProfile: hasGLES1Impl         " + hasGLES1Impl);
                        System.err.println("GLProfile: hasGLES2Impl         " + hasGLES2Impl);
                    }
                }
                if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                    GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                }
                if (!DEBUG) break block20;
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": added profile(s): desktop " + bl2 + ", egl " + bl);
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
                if (!bl2) break block21;
                GLProfile.dumpGLInfo(desktopFactory, abstractGraphicsDevice);
                List<GLCapabilitiesImmutable> list = desktopFactory.getAvailableCapabilities(abstractGraphicsDevice);
                for (n = 0; n < list.size(); ++n) {
                    System.err.println(list.get(n));
                }
                break block20;
            }
            if (!bl) break block20;
            GLProfile.dumpGLInfo(eglFactory, abstractGraphicsDevice);
            List<GLCapabilitiesImmutable> list = eglFactory.getAvailableCapabilities(abstractGraphicsDevice);
            for (n = 0; n < list.size(); ++n) {
                System.err.println(list.get(n));
            }
        }
        return bl2 || bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpGLInfo(GLDrawableFactoryImpl gLDrawableFactoryImpl, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext gLContext = gLDrawableFactoryImpl.getOrCreateSharedContext(abstractGraphicsDevice);
        if (null != gLContext) {
            System.err.println("GLProfile.dumpGLInfo: " + gLContext);
            gLContext.makeCurrent();
            try {
                System.err.println(JoglVersion.getGLInfo(gLContext.getGL(), null));
            }
            finally {
                gLContext.release();
            }
        } else {
            System.err.println("GLProfile.dumpGLInfo: shared context n/a");
        }
    }

    public static AbstractGraphicsDevice getDefaultDevice() {
        GLProfile.initSingleton();
        return defaultDevice;
    }

    private static String array2String(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static void glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder, int n, int n2) {
        String string = GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n2);
        if (null == string) {
            throw new GLException("Internal Error");
        }
        stringBuilder.append("[");
        stringBuilder.append(string);
        stringBuilder.append("]");
    }

    private static boolean computeProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, boolean bl2) {
        if (DEBUG) {
            System.err.println("GLProfile.init map " + abstractGraphicsDevice.getConnection() + ", desktopCtxUndef " + bl + ", esCtxUndef " + bl2);
        }
        boolean[] blArray = new boolean[1];
        GLProfile gLProfile = null;
        GLProfile gLProfile2 = null;
        HashMap<String, GLProfile> hashMap = new HashMap<String, GLProfile>(GL_PROFILE_LIST_ALL.length + 1);
        for (int i = 0; i < GL_PROFILE_LIST_ALL.length; ++i) {
            String string = GL_PROFILE_LIST_ALL[i];
            String string2 = GLProfile.computeProfileImpl(abstractGraphicsDevice, string, bl, bl2, blArray);
            if (null != string2) {
                GLProfile gLProfile3;
                if (string.equals(string2)) {
                    gLProfile3 = new GLProfile(string, null, blArray[0]);
                } else {
                    GLProfile gLProfile4 = hashMap.get(string2);
                    if (null == gLProfile4) {
                        throw new InternalError("XXX0");
                    }
                    gLProfile3 = new GLProfile(string, gLProfile4, blArray[0]);
                }
                hashMap.put(string, gLProfile3);
                if (DEBUG) {
                    System.err.println("GLProfile.init map " + gLProfile3 + " on device " + abstractGraphicsDevice.getConnection());
                }
                if (null == gLProfile2 && blArray[0]) {
                    gLProfile2 = gLProfile3;
                    if (!DEBUG) continue;
                    System.err.println("GLProfile.init map defaultHW " + gLProfile3 + " on device " + abstractGraphicsDevice.getConnection());
                    continue;
                }
                if (null != gLProfile) continue;
                gLProfile = gLProfile3;
                if (!DEBUG) continue;
                System.err.println("GLProfile.init map defaultAny " + gLProfile3 + " on device " + abstractGraphicsDevice.getConnection());
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("GLProfile.init map *** no mapping for " + string + " on device " + abstractGraphicsDevice.getConnection());
        }
        if (null != gLProfile2) {
            hashMap.put(GL_DEFAULT, gLProfile2);
        } else if (null != gLProfile) {
            hashMap.put(GL_DEFAULT, gLProfile);
        }
        GLProfile.setProfileMap(abstractGraphicsDevice, hashMap);
        return hashMap.size() > 0;
    }

    private static String computeProfileImpl(AbstractGraphicsDevice abstractGraphicsDevice, String string, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = bl3 = Platform.OS_TYPE == Platform.OSType.MACOS;
        if (GL2ES1.equals(string)) {
            boolean bl5;
            boolean[] blArray2 = new boolean[1];
            boolean bl6 = hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice, blArray2));
            boolean bl7 = bl5 = bl6 && blArray2[0];
            if (hasGL234Impl) {
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray) && (!bl5 || blArray[0])) {
                    return GL4bc;
                }
                if (GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray) && (!bl5 || blArray[0])) {
                    return GL3bc;
                }
                if ((bl || GLContext.isGL2Available(abstractGraphicsDevice, blArray)) && (!bl5 || blArray[0])) {
                    return GL2;
                }
            }
            if (bl6) {
                blArray[0] = blArray2[0];
                return GLES1;
            }
        } else if (GL2ES2.equals(string)) {
            boolean bl8;
            boolean[] blArray3 = new boolean[1];
            boolean bl9 = hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice, blArray3));
            boolean bl10 = bl8 = bl9 && blArray3[0];
            if (hasGL234Impl) {
                if (!bl3) {
                    if (GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray) && (!bl8 || blArray[0])) {
                        return GL4bc;
                    }
                    if (GLContext.isGL4Available(abstractGraphicsDevice, blArray) && (!bl8 || blArray[0])) {
                        return GL4;
                    }
                    if (GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray) && (!bl8 || blArray[0])) {
                        return GL3bc;
                    }
                    if (GLContext.isGL3Available(abstractGraphicsDevice, blArray) && (!bl8 || blArray[0])) {
                        return GL3;
                    }
                }
                if ((bl || GLContext.isGL2Available(abstractGraphicsDevice, blArray)) && (!bl8 || blArray[0])) {
                    return GL2;
                }
            }
            if (bl9) {
                blArray[0] = blArray3[0];
                return GLES2;
            }
        } else if (GL2GL3.equals(string)) {
            if (hasGL234Impl) {
                if (!bl3 && GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray)) {
                    return GL4bc;
                }
                if (!bl3 && GLContext.isGL4Available(abstractGraphicsDevice, blArray)) {
                    return GL4;
                }
                if (!bl3 && GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray)) {
                    return GL3bc;
                }
                if (!bl3 && GLContext.isGL3Available(abstractGraphicsDevice, blArray)) {
                    return GL3;
                }
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice, blArray)) {
                    return GL2;
                }
            }
        } else {
            if (GL4bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray))) {
                return GL4bc;
            }
            if (GL4.equals(string) && hasGL234Impl && (bl || GLContext.isGL4Available(abstractGraphicsDevice, blArray))) {
                return GL4;
            }
            if (GL3bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray))) {
                return GL3bc;
            }
            if (GL3.equals(string) && hasGL234Impl && (bl || GLContext.isGL3Available(abstractGraphicsDevice, blArray))) {
                return GL3;
            }
            if (GL2.equals(string) && hasGL234Impl && (bl || GLContext.isGL2Available(abstractGraphicsDevice, blArray))) {
                return GL2;
            }
            if (GLES2.equals(string) && hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice, blArray))) {
                return GLES2;
            }
            if (GLES1.equals(string) && hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice, blArray))) {
                return GLES1;
            }
        }
        return null;
    }

    private static HashMap<String, GLProfile> getProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        String string;
        HashMap<String, GLProfile> hashMap;
        GLProfile.initSingleton();
        if (null == defaultDevice) {
            throw new GLException("No default device available");
        }
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        if (null != (hashMap = deviceConn2ProfileMap.get(string = abstractGraphicsDevice.getUniqueID()))) {
            return hashMap;
        }
        if (!GLProfile.initProfilesForDevice(abstractGraphicsDevice)) {
            if (bl) {
                throw new GLException("No Profile available for " + abstractGraphicsDevice);
            }
            return null;
        }
        hashMap = deviceConn2ProfileMap.get(string);
        if (null == hashMap && bl) {
            throw new InternalError("initProfilesForDevice(..) didn't setProfileMap(..) for " + abstractGraphicsDevice);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, HashMap<String, GLProfile> hashMap) {
        HashMap<String, HashMap<String, GLProfile>> hashMap2 = deviceConn2ProfileMap;
        synchronized (hashMap2) {
            deviceConn2ProfileMap.put(abstractGraphicsDevice.getUniqueID(), hashMap);
        }
    }

    private GLProfile(String string, GLProfile gLProfile, boolean bl) {
        this.profile = string;
        this.profileImpl = gLProfile;
        this.isHardwareRasterizer = bl;
    }

    static {
        Platform.initSingleton();
        GL_PROFILE_LIST_ALL = new String[]{GL4bc, GL3bc, GL2, GL4, GL3, GL2GL3, GLES2, GL2ES2, GLES1, GL2ES1};
        GL_PROFILE_LIST_MAX = new String[]{GL4bc, GL4, GL3bc, GL3, GL2, GLES2, GLES1};
        GL_PROFILE_LIST_MIN = new String[]{GLES1, GLES2, GL2, GL3, GL3bc, GL4, GL4bc};
        GL_PROFILE_LIST_MIN_DESKTOP = new String[]{GL2, GL3bc, GL4bc, GL3, GL4};
        GL_PROFILE_LIST_MAX_FIXEDFUNC = new String[]{GL4bc, GL3bc, GL2, GLES1};
        GL_PROFILE_LIST_MAX_PROGSHADER = new String[]{GL4bc, GL4, GL3bc, GL3, GL2, GLES2};
        GL_PROFILE_LIST_MAX_PROGSHADER_CORE = new String[]{GL4, GL3, GLES2};
        eglFactory = null;
        desktopFactory = null;
        defaultDevice = null;
        initialized = false;
        initLock = LockFactory.createRecursiveThreadGroupLock();
        deviceConn2ProfileMap = new HashMap();
    }
}

