/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.newt.Window;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.driver.awt.WindowDriver;

public class AWTCanvas
extends Canvas {
    private GraphicsDevice device;
    private GraphicsConfiguration chosen;
    private AWTGraphicsConfiguration awtConfig;
    private WindowDriver newtWindowImpl;
    private CapabilitiesChooser chooser = null;
    private CapabilitiesImmutable capabilities;
    private boolean displayConfigChanged = false;
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public AWTCanvas(WindowDriver windowDriver, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesChooser capabilitiesChooser) {
        this.newtWindowImpl = windowDriver;
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Capabilities null");
        }
        this.capabilities = capabilitiesImmutable;
        this.chooser = capabilitiesChooser;
    }

    public AWTGraphicsConfiguration getAWTGraphicsConfiguration() {
        return this.awtConfig;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        this.newtWindowImpl.windowRepaint(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.displayConfigChanged;
        this.displayConfigChanged = false;
        return bl;
    }

    @Override
    public void addNotify() {
        Object object;
        this.awtConfig = AWTCanvas.chooseGraphicsConfiguration(this.capabilities, this.capabilities, this.chooser, this.device);
        if (Window.DEBUG_IMPLEMENTATION) {
            object = new Exception("Info: Created Config: " + this.awtConfig);
            ((Throwable)object).printStackTrace();
        }
        if (null == this.awtConfig) {
            throw new NativeWindowException("Error: NULL AWTGraphicsConfiguration");
        }
        this.chosen = this.awtConfig.getAWTGraphicsConfiguration();
        this.disableBackgroundErase();
        super.addNotify();
        this.disableBackgroundErase();
        object = super.getGraphicsConfiguration();
        if (null != object) {
            this.device = ((GraphicsConfiguration)object).getDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        try {
            this.dispose();
        }
        finally {
            super.removeNotify();
        }
    }

    private void dispose() {
        if (null != this.awtConfig) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.awtConfig.getNativeGraphicsConfiguration().getScreen().getDevice();
            String string = null;
            if (Window.DEBUG_IMPLEMENTATION) {
                string = abstractGraphicsDevice.toString();
            }
            boolean bl = abstractGraphicsDevice.close();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("AWTCanvas.dispose(): closed GraphicsDevice: " + string + ", result: " + bl);
            }
        }
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                GraphicsConfiguration graphicsConfiguration2;
                AWTGraphicsConfiguration aWTGraphicsConfiguration = AWTCanvas.chooseGraphicsConfiguration(this.awtConfig.getChosenCapabilities(), this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = graphicsConfiguration2 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getAWTGraphicsConfiguration() : null;
                if (Window.DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Info: Call Stack: " + Thread.currentThread().getName());
                    exception.printStackTrace();
                    System.err.println("Created Config (n): HAVE    GC " + this.chosen);
                    System.err.println("Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("Created Config (n): Choosen GC " + graphicsConfiguration2);
                    System.err.println("Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("Created Config (n): EQUALS CAPS " + aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities()));
                }
                if (graphicsConfiguration2 != null) {
                    this.chosen = graphicsConfiguration2;
                    if (!aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities())) {
                        this.displayConfigChanged = true;
                    }
                    this.awtConfig = aWTGraphicsConfiguration;
                }
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    private static AWTGraphicsConfiguration chooseGraphicsConfiguration(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, GraphicsDevice graphicsDevice) {
        AbstractGraphicsScreen abstractGraphicsScreen = null != graphicsDevice ? AWTGraphicsScreen.createScreenDevice(graphicsDevice, 0) : AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, capabilitiesImmutable.getClass()).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, 0);
        if (aWTGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = AWTCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("AWTCanvas: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("AWTCanvas: TK disableBackgroundErase error: " + exception);
            }
        }
    }
}

