/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class AndroidVersion {
    public static final boolean isAvailable;
    public static final String CODENAME;
    public static final String INCREMENTAL;
    public static final String RELEASE;
    public static final int SDK_INT;
    public static final String SDK_NAME;
    private static final String androidBuildVersion = "android.os.Build$VERSION";
    private static final String androidBuildVersionCodes = "android.os.Build$VERSION_CODES";

    private static final Map<Integer, String> getVersionCodes(Class<?> clazz, Object object) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n = fieldArray[i].getInt(object);
                String string = fieldArray[i].getName();
                hashMap.put(new Integer(n), string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    private static final String getString(Class<?> clazz, Object object, String string) {
        try {
            Field field = clazz.getField(string);
            return (String)field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static final int getInt(Class<?> clazz, Object object, String string) {
        try {
            Field field = clazz.getField(string);
            return field.getInt(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    static {
        ClassLoader classLoader = AndroidVersion.class.getClassLoader();
        Class<?> clazz = null;
        Object var2_2 = null;
        Class<?> clazz2 = null;
        Object var4_4 = null;
        try {
            clazz = ReflectionUtil.getClass(androidBuildVersion, true, classLoader);
            var2_2 = clazz.newInstance();
            clazz2 = ReflectionUtil.getClass(androidBuildVersionCodes, true, classLoader);
            var4_4 = clazz2.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = isAvailable = null != var2_2;
        if (isAvailable) {
            CODENAME = AndroidVersion.getString(clazz, var2_2, "CODENAME");
            INCREMENTAL = AndroidVersion.getString(clazz, var2_2, "INCREMENTAL");
            RELEASE = AndroidVersion.getString(clazz, var2_2, "RELEASE");
            SDK_INT = AndroidVersion.getInt(clazz, var2_2, "SDK_INT");
            Map<Integer, String> map = AndroidVersion.getVersionCodes(clazz2, var4_4);
            String string = map.get(new Integer(SDK_INT));
            SDK_NAME = null != string ? string : "SDK_" + SDK_INT;
        } else {
            CODENAME = null;
            INCREMENTAL = null;
            RELEASE = null;
            SDK_INT = -1;
            SDK_NAME = null;
        }
    }
}

