/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public abstract class TaskBase
implements Runnable {
    protected final Object syncObject;
    protected final boolean catchExceptions;
    protected Object attachment;
    protected Throwable runnableException;
    protected long tCreated;
    protected long tStarted;
    protected volatile long tExecuted;
    protected volatile boolean isFlushed;

    protected TaskBase(Object object, boolean bl) {
        this.syncObject = object;
        this.catchExceptions = bl;
        this.tCreated = System.currentTimeMillis();
        this.tStarted = 0L;
        this.tExecuted = 0L;
        this.isFlushed = false;
    }

    public final Object getSyncObject() {
        return this.syncObject;
    }

    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (!this.isExecuted() && this.hasWaiter()) {
            Object object = this.syncObject;
            synchronized (object) {
                this.isFlushed = true;
                this.syncObject.notifyAll();
            }
        }
    }

    public final boolean isInQueue() {
        return 0L != this.tExecuted && !this.isFlushed;
    }

    public final boolean isExecuted() {
        return 0L != this.tExecuted;
    }

    public final boolean isFlushed() {
        return this.isFlushed;
    }

    public final boolean hasWaiter() {
        return null != this.syncObject;
    }

    public final Throwable getThrowable() {
        return this.runnableException;
    }

    public final long getTimestampCreate() {
        return this.tCreated;
    }

    public final long getTimestampBeforeExec() {
        return this.tStarted;
    }

    public final long getTimestampAfterExec() {
        return this.tExecuted;
    }

    public final long getDurationInQueue() {
        return this.tStarted - this.tCreated;
    }

    public final long getDurationInExec() {
        return this.tExecuted - this.tStarted;
    }

    public final long getDurationTotal() {
        return this.tExecuted - this.tCreated;
    }

    public String toString() {
        return "RunnableTask[executed " + this.isExecuted() + ", t2-t0 " + this.getDurationTotal() + ", t2-t1 " + this.getDurationInExec() + ", t1-t0 " + this.getDurationInQueue() + ", throwable " + this.getThrowable() + ", Attachment " + this.attachment + "]";
    }
}

