import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

void setup() 
{
  size(400,400);
 
  // start oscP5, telling it to listen for incoming messages at port 5001 */
  oscP5 = new OscP5(this,5001);
 
  // set the remote location to be the localhost on port 1234 (Isadora's default OSC port)
  myRemoteLocation = new NetAddress("127.0.0.1",1234);
}
void mousePressed() {  
  // create an osc message
  OscMessage myMessage = new OscMessage("/mousepress");
 
  myMessage.add(123); // add an int to the osc message
  myMessage.add(12.34); // add a float to the osc message 
  myMessage.add("hello Izzy!"); // add a string to the osc message
 
  // send the message
  oscP5.send(myMessage, myRemoteLocation); 
}
 
void draw()
{
 
}

//In order to receive messages in Processing, we need to define
// a function called oscEvent(). Whenever an OSC message is received
// it is passed to the oscEvent() function.
void oscEvent(OscMessage theOscMessage) 
{  
  // get the first value as an integer
  int firstValue = theOscMessage.get(0).intValue();
 
  // get the second value as a float  
  float secondValue = theOscMessage.get(1).floatValue();
 
  // get the third value as a string
  String thirdValue = theOscMessage.get(2).stringValue();
 
  // print out the message
  print("OSC Message Received: ");
  print(theOscMessage.addrPattern() + " ");
  println(firstValue + " " + secondValue + " " + thirdValue);
}
